/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block.blockentity;

import io.github.wouink.furnish.block.container.MailboxContainer;
import io.github.wouink.furnish.block.util.TileEntityHelper;
import io.github.wouink.furnish.item.Letter;
import io.github.wouink.furnish.setup.FurnishRegistries;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MailboxBlockEntity
extends RandomizableContainerBlockEntity {
    public static final int SIZE = 18;
    protected NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private String owner;
    private String ownerDisplayName;

    public MailboxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FurnishRegistries.Mailbox_BlockEntity.get(), pos, state);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    protected void m_6520_(NonNullList<ItemStack> newInventory) {
        this.inventory = newInventory;
    }

    protected Component m_6820_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128359_("Owner", this.owner == null ? "" : this.owner);
        nbt.m_128359_("OwnerDisplayName", this.ownerDisplayName == null ? "" : this.ownerDisplayName);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.owner = nbt.m_128461_("Owner");
        this.ownerDisplayName = nbt.m_128461_("OwnerDisplayName");
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return new MailboxContainer(syncId, playerInventory, (Container)this);
    }

    public int m_6643_() {
        return 18;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return false;
    }

    public void updateDisplayName(Player playerEntity) {
        if (this.isOwner(playerEntity)) {
            String playerName = playerEntity.m_36316_().getName();
            if (this.ownerDisplayName == null || !this.ownerDisplayName.equals(playerName)) {
                this.ownerDisplayName = playerName;
                TileEntityHelper.broadcastUpdate((BlockEntity)this, false);
            }
        }
    }

    public void setOwner(Player playerEntity) {
        this.owner = playerEntity.m_20149_();
        this.updateDisplayName(playerEntity);
    }

    public UUID getOwner() {
        return UUID.fromString(this.owner);
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public boolean isOwner(Player playerEntity) {
        return this.hasOwner() && playerEntity.m_20149_().equals(this.owner);
    }

    public boolean hasMail() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public boolean isFull() {
        return !this.inventory.contains((Object)ItemStack.f_41583_);
    }

    public ItemStack addMail(ItemStack stack) {
        int slot;
        if (!this.m_58900_().m_204336_(FurnishRegistries.BYPASSES_MAIL_TAG_TAG) && !stack.m_204117_(FurnishRegistries.MAIL_TAG)) {
            return stack;
        }
        if (stack.m_41720_() instanceof Letter) {
            Letter.signLetter(stack, "Anonymous Player");
        }
        if ((slot = this.getFreeSlot()) < this.m_6643_()) {
            Player mailboxOwner;
            ItemStack result = (ItemStack)this.inventory.set(slot, (Object)stack);
            TileEntityHelper.broadcastUpdate((BlockEntity)this, false);
            if (result.m_41619_() && (mailboxOwner = this.f_58857_.m_46003_(this.getOwner())) != null) {
                if (this.m_8077_()) {
                    mailboxOwner.m_5661_((Component)Component.m_237110_((String)"msg.furnish.mailbox.new_mail_loc", (Object[])new Object[]{this.m_7770_()}), true);
                } else {
                    mailboxOwner.m_5661_((Component)Component.m_237115_((String)"msg.furnish.mailbox.new_mail"), true);
                }
                if (mailboxOwner instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)mailboxOwner;
                    TileEntityHelper.playSoundToPlayer(serverPlayer, (SoundEvent)FurnishRegistries.Mail_Received_Sound.get(), SoundSource.MASTER, 1.0f, 1.0f);
                }
            }
            return result;
        }
        return stack;
    }

    public Component getOwnerDisplayName() {
        return !this.hasOwner() || this.ownerDisplayName.isEmpty() ? null : Component.m_237113_((String)this.ownerDisplayName);
    }

    private int getFreeSlot() {
        int slot;
        for (slot = 0; slot < this.inventory.size() && !((ItemStack)this.inventory.get(slot)).m_41619_(); ++slot) {
        }
        return slot;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }
}

