/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block;

import io.github.wouink.furnish.Furnish;
import io.github.wouink.furnish.block.util.VoxelShapeHelper;
import io.github.wouink.furnish.setup.FurnishBlocks;
import io.github.wouink.furnish.setup.FurnishRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Curtain
extends HorizontalDirectionalBlock {
    private static final VoxelShape[] CURTAIN = VoxelShapeHelper.getRotatedShapes(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0));
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty LEFT = FurnishBlocks.CustomProperties.LEFT;
    public static final BooleanProperty RIGHT = FurnishBlocks.CustomProperties.RIGHT;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;

    public Curtain(BlockBehaviour.Properties p) {
        super(p.m_60955_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, OPEN, POWERED, LEFT, RIGHT, UP, DOWN});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = this.m_49966_();
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        state = (BlockState)state.m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
        state = Curtain.calculateState(state, (LevelAccessor)level, pos);
        return state;
    }

    private static BlockState calculateState(BlockState initialState, LevelAccessor level, BlockPos pos) {
        BlockState state = initialState;
        Direction facing = (Direction)initialState.m_61143_((Property)f_54117_);
        state = (BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_121945_(facing.m_122427_())).m_60734_() instanceof Curtain));
        state = (BlockState)state.m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_121945_(facing.m_122428_())).m_60734_() instanceof Curtain));
        state = (BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_7494_()).m_60734_() instanceof Curtain));
        state = (BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_7495_()).m_60734_() instanceof Curtain));
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos fromPos) {
        return Curtain.calculateState(state, world, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return CURTAIN[((Direction)state.m_61143_((Property)f_54117_)).ordinal() - 2];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83040_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player playerEntity, InteractionHand hand, BlockHitResult result) {
        if (!world.m_5776_()) {
            Curtain.setCurtainsInLine((LevelAccessor)world, pos, (Boolean)state.m_61143_((Property)OPEN) == false);
        }
        world.m_5594_(null, pos, (SoundEvent)FurnishRegistries.Curtain_Sound.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    private static void setCurtainsInColumn(LevelAccessor level, BlockPos pos, boolean open) {
        BlockState state;
        Furnish.debug("column " + pos);
        BlockPos scan = pos;
        while ((state = level.m_8055_(scan)).m_60734_() instanceof Curtain) {
            level.m_7731_(scan, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            scan = scan.m_7494_();
        }
        scan = pos.m_7495_();
        while ((state = level.m_8055_(scan)).m_60734_() instanceof Curtain) {
            level.m_7731_(scan, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            scan = scan.m_7495_();
        }
    }

    private static void setCurtainsInLine(LevelAccessor level, BlockPos pos, boolean open) {
        BlockState state;
        Furnish.debug("line " + pos + " to " + open);
        Direction facing = (Direction)level.m_8055_(pos).m_61143_((Property)f_54117_);
        BlockPos scan = pos;
        while ((state = level.m_8055_(scan)).m_60734_() instanceof Curtain) {
            Curtain.setCurtainsInColumn(level, scan, open);
            scan = scan.m_121945_(facing.m_122427_());
        }
        scan = pos.m_121945_(facing.m_122428_());
        while ((state = level.m_8055_(scan)).m_60734_() instanceof Curtain) {
            Curtain.setCurtainsInColumn(level, scan, open);
            scan = scan.m_121945_(facing.m_122428_());
        }
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos blockPos2, boolean bl) {
        if (!level.m_5776_()) {
            boolean flag = level.m_276867_(pos);
            if ((Boolean)state.m_61143_((Property)POWERED) != flag) {
                level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
                Curtain.setCurtainsInLine((LevelAccessor)level, pos, flag);
                if ((Boolean)state.m_61143_((Property)OPEN) != flag) {
                    level.m_5594_(null, pos, (SoundEvent)FurnishRegistries.Curtain_Sound.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }
}

