/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish;

import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.networking.simple.SimpleNetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import io.github.wouink.furnish.event.GivePlateToEnderman;
import io.github.wouink.furnish.event.InteractWithShutterThroughWindow;
import io.github.wouink.furnish.event.KnockOnDoor;
import io.github.wouink.furnish.event.PlaceCarpet;
import io.github.wouink.furnish.event.PlaceSnow;
import io.github.wouink.furnish.event.PopLecternBook;
import io.github.wouink.furnish.network.C2S_UpdateItemStack;
import io.github.wouink.furnish.setup.FurnishBlocks;
import io.github.wouink.furnish.setup.FurnishClient;
import io.github.wouink.furnish.setup.FurnishRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Furnish {
    public static final String MODID = "furnish";
    public static final Logger LOG = LogManager.getLogger((String)"Furnish");
    public static final SimpleNetworkManager NET = SimpleNetworkManager.create((String)"furnish");
    public static final MessageType CL_UPDATE_ITEMSTACK = NET.registerC2S("cl_update_itemstack", C2S_UpdateItemStack::new);
    private static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((String)"furnish", (ResourceKey)Registries.f_279569_);
    public static final RegistrySupplier<CreativeModeTab> CREATIVE_TAB = CREATIVE_TABS.register("furnish", () -> CreativeTabRegistry.create((Component)Component.m_237115_((String)"itemGroup.furnish.furnish"), () -> new ItemStack((ItemLike)FurnishBlocks.Furniture_Workbench.get())));

    public static void init() {
        FurnishBlocks.init();
        FurnishRegistries.BLOCKS.register();
        LOG.info("Registered Furnish Blocks.");
        FurnishRegistries.ITEMS.register();
        LOG.info("Registered Furnish Items.");
        FurnishRegistries.RECIPE_TYPES.register();
        LOG.info("Registered Furnish Recipe Types.");
        FurnishRegistries.RECIPE_SERIALIZERS.register();
        LOG.info("Registered Furnish Recipe Serializers.");
        FurnishRegistries.SOUND_EVENTS.register();
        LOG.info("Registered Furnish Sound Events.");
        FurnishRegistries.CONTAINERS.register();
        LOG.info("Registered Furnish Containers.");
        FurnishRegistries.ENTITIES.register();
        LOG.info("Registered Furnish Entities.");
        FurnishRegistries.BLOCK_ENTITIES.register();
        LOG.info("Registered Furnish Block Entities.");
        FurnishRegistries.PAINTING_VARIANTS.register();
        LOG.info("Registered Furnish Painting Variants.");
        CREATIVE_TABS.register();
        LOG.info("Registered Furnish Creative Tab.");
        BlockEvent.PLACE.register(PlaceCarpet::onCarpetPlaced);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(PlaceSnow::onSnowLayerUsedOnBlock);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(InteractWithShutterThroughWindow::onRightClickWindow);
        InteractionEvent.LEFT_CLICK_BLOCK.register(PopLecternBook::onLecternLeftClick);
        InteractionEvent.LEFT_CLICK_BLOCK.register(KnockOnDoor::onDoorHit);
        EntityEvent.ADD.register(GivePlateToEnderman::onEndermanSpawn);
        LOG.info("Registered Furnish Events.");
    }

    public static void initClient() {
        if (Platform.getEnvironment() == Env.CLIENT) {
            FurnishClient.registerBlockRenderTypes();
            FurnishClient.bindScreensToContainers();
            FurnishClient.registerEntityRenderers();
            FurnishClient.copyDoorKnockSilencerPack();
        } else {
            LOG.error("Attempt to call initClient elsewhere than on client.");
        }
    }

    public static void debug(String msg) {
    }
}

