/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.util;

import com.terraformersmc.terraform.shapes.api.Shape;
import com.terraformersmc.terraform.shapes.api.validator.Validator;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;

public class RegionalSafelistValidator
implements Validator {
    private final List<BlockState> safeStates;
    private final LevelSimulatedReader testableWorld;
    private final Direction dir;

    public RegionalSafelistValidator(LevelSimulatedReader world, Direction dir, List<BlockState> safeStates) {
        this.safeStates = safeStates;
        this.testableWorld = world;
        this.dir = dir;
    }

    public RegionalSafelistValidator(LevelSimulatedReader world, Direction dir, BlockState ... safeStates) {
        this(world, dir, Arrays.asList(safeStates));
    }

    public boolean validate(Shape shape) {
        return shape.stream().allMatch(position -> {
            double height = shape.max().getY() - shape.min().getY();
            double width = shape.max().getZ() - shape.min().getZ();
            double depth = shape.max().getX() - shape.min().getX();
            return switch (this.dir) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.UP -> this.testableWorld.m_7433_(position.toBlockPos(), state -> position.getY() > shape.min().getY() + height / 4.0 ? state.m_60795_() : this.safeStates.contains(state) || state.m_60795_());
                case Direction.DOWN -> this.testableWorld.m_7433_(position.toBlockPos(), state -> position.getY() < shape.min().getY() + height * 3.0 / 4.0 ? state.m_60795_() : this.safeStates.contains(state) || state.m_60795_());
                case Direction.SOUTH -> this.testableWorld.m_7433_(position.toBlockPos(), state -> position.getZ() > shape.min().getZ() + width / 4.0 ? state.m_60795_() : this.safeStates.contains(state) || state.m_60795_());
                case Direction.NORTH -> this.testableWorld.m_7433_(position.toBlockPos(), state -> position.getZ() < shape.min().getZ() + width * 3.0 / 4.0 ? state.m_60795_() : this.safeStates.contains(state) || state.m_60795_());
                case Direction.EAST -> this.testableWorld.m_7433_(position.toBlockPos(), state -> position.getX() > shape.min().getX() + depth / 4.0 ? state.m_60795_() : this.safeStates.contains(state) || state.m_60795_());
                case Direction.WEST -> this.testableWorld.m_7433_(position.toBlockPos(), state -> position.getX() < shape.min().getX() + depth * 3.0 / 4.0 ? state.m_60795_() : this.safeStates.contains(state) || state.m_60795_());
            };
        });
    }
}

