/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.placementmodifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraformersmc.cinderscapes.init.CinderscapesPlacementModifierTypes;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class SafelistRangeFloorPlacementModifier
extends PlacementModifier {
    public static final Codec<SafelistRangeFloorPlacementModifier> UNIFORM_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VerticalAnchor.f_158914_.fieldOf("min_inclusive").forGetter(provider -> provider.minOffset), (App)VerticalAnchor.f_158914_.fieldOf("max_inclusive").forGetter(provider -> provider.maxOffset), (App)BlockState.f_61039_.listOf().fieldOf("safelist").forGetter(provider -> provider.safelist)).apply((Applicative)instance, SafelistRangeFloorPlacementModifier::new));
    private final List<BlockState> safelist;
    private final VerticalAnchor minOffset;
    private final VerticalAnchor maxOffset;

    public SafelistRangeFloorPlacementModifier(VerticalAnchor minOffset, VerticalAnchor maxOffset, List<BlockState> safelist) {
        this.safelist = safelist;
        this.minOffset = minOffset;
        this.maxOffset = maxOffset;
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(x, 0, z);
        BlockPos.MutableBlockPos offsetPos = new BlockPos.MutableBlockPos(x, 0, z);
        List<Integer> ys = IntStream.range(this.minOffset.m_142322_((WorldGenerationContext)context), this.maxOffset.m_142322_((WorldGenerationContext)context)).filter(y -> {
            testPos.m_142448_(y);
            offsetPos.m_142448_(y - 1);
            BlockState testState = context.m_191828_((BlockPos)testPos);
            BlockState offsetState = context.m_191828_((BlockPos)offsetPos);
            return testState.m_60795_() && offsetState.m_60815_() && this.safelist.contains(offsetState);
        }).boxed().toList();
        if (ys.size() > 0) {
            testPos.m_142448_(ys.get(random.m_188503_(ys.size())).intValue());
        } else {
            testPos.m_142448_(0);
        }
        return Stream.of(testPos);
    }

    public PlacementModifierType<?> m_183327_() {
        return CinderscapesPlacementModifierTypes.COUNT_FLOOR;
    }
}

