/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.item;

import com.terraformersmc.cinderscapes.config.CinderscapesConfig;
import com.terraformersmc.cinderscapes.init.CinderscapesBlocks;
import com.terraformersmc.cinderscapes.init.CinderscapesItems;
import com.terraformersmc.cinderscapes.item.ItemGroupEntries;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class CinderscapesItemGroups {
    private static final ResourceKey<CreativeModeTab> ITEM_GROUP = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)ResourceLocation.m_214293_((String)"cinderscapes", (String)"items"));
    private static final HashMap<ResourceKey<CreativeModeTab>, HashMap<ItemLike, ItemGroupEntries>> ITEM_GROUP_ENTRY_MAPS = new HashMap(8);

    public static void addGroupEntry(ItemLike item, ResourceKey<CreativeModeTab> group) {
        CinderscapesItemGroups.addGroupEntry(item, group, null);
    }

    public static void addGroupEntry(ItemLike item, ResourceKey<CreativeModeTab> group, @Nullable ItemLike relative) {
        HashMap entryMap = ITEM_GROUP_ENTRY_MAPS.computeIfAbsent(group, key -> new HashMap(32));
        ItemGroupEntries entries = entryMap.computeIfAbsent(relative, ItemGroupEntries::empty);
        entries.addItem(item);
    }

    public static void init() {
    }

    static {
        Item BUILDING_NETHER_WOOD = Items.f_42144_;
        Item BUILDING_NETHER_QUARTZ = Items.f_42334_;
        Item BUILDING_NETHER_STORAGE_BLOCK = Items.f_42791_;
        Item FUNCTIONAL_NETHER_SIGN = Items.f_244637_;
        Item NATURAL_NYLIUM = Items.f_42541_;
        Item NATURAL_SNOWLIKE = Items.f_151015_;
        Item NATURAL_QUARTZ_ORE = Items.f_42154_;
        Item NATURAL_FUNGUS = Items.f_41955_;
        Item NATURAL_STEM = Items.f_41844_;
        Item NATURAL_WART_BLOCK = Items.f_42260_;
        Item NATURAL_NETHER_VEGETATION = Items.f_41906_;
        Item NATURAL_TALL_VEGETATION = Items.f_42211_;
        Item NATURAL_BERRIES = Items.f_42780_;
        Item FOOD_BERRIES = Items.f_151079_;
        Item INGREDIENTS_QUARTZ = Items.f_42692_;
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_STEM, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_HYPHAE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.STRIPPED_SCORCHED_STEM, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.STRIPPED_SCORCHED_HYPHAE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_PLANKS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_STAIRS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_SLAB, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_FENCE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_FENCE_GATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_DOOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_TRAPDOOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_PRESSURE_PLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_BUTTON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_STEM, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_HYPHAE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.STRIPPED_UMBRAL_STEM, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.STRIPPED_UMBRAL_HYPHAE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_PLANKS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_STAIRS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_SLAB, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_FENCE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_FENCE_GATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_DOOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_TRAPDOOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_PRESSURE_PLATE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_BUTTON, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_WOOD);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.CRYSTALLINE_QUARTZ, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SULFUR_QUARTZ_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SULFUR_QUARTZ_STAIRS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SULFUR_QUARTZ_SLAB, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.CHISELED_SULFUR_QUARTZ_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SULFUR_QUARTZ_BRICKS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SULFUR_QUARTZ_PILLAR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOOTH_SULFUR_QUARTZ, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOOTH_SULFUR_QUARTZ_STAIRS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOOTH_SULFUR_QUARTZ_SLAB, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.CRYSTALLINE_SULFUR_QUARTZ, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.ROSE_QUARTZ_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.ROSE_QUARTZ_STAIRS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.ROSE_QUARTZ_SLAB, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.CHISELED_ROSE_QUARTZ_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.ROSE_QUARTZ_BRICKS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.ROSE_QUARTZ_PILLAR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOOTH_ROSE_QUARTZ, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOOTH_ROSE_QUARTZ_STAIRS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOOTH_ROSE_QUARTZ_SLAB, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.CRYSTALLINE_ROSE_QUARTZ, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOKY_QUARTZ_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOKY_QUARTZ_STAIRS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOKY_QUARTZ_SLAB, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.CHISELED_SMOKY_QUARTZ_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOKY_QUARTZ_BRICKS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOKY_QUARTZ_PILLAR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOOTH_SMOKY_QUARTZ, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOOTH_SMOKY_QUARTZ_STAIRS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOOTH_SMOKY_QUARTZ_SLAB, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.CRYSTALLINE_SMOKY_QUARTZ, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SULFUR_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)BUILDING_NETHER_STORAGE_BLOCK);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SULFUR_QUARTZ_ORE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_QUARTZ_ORE);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.ROSE_QUARTZ_ORE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_QUARTZ_ORE);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SMOKY_QUARTZ_ORE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_QUARTZ_ORE);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SULFUR_ORE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_QUARTZ_ORE);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SULFUR_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_QUARTZ_ORE);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.ASH_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_SNOWLIKE);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.ASH, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_SNOWLIKE);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_NYLIUM, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NYLIUM);
        if (CinderscapesConfig.INSTANCE.easterEggs) {
            CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.NODZOL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NYLIUM);
        }
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_STEM, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_STEM);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_HYPHAE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_STEM);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_STEM, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_STEM);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_HYPHAE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_STEM);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_FUNGUS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_FUNGUS);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_WART_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_WART_BLOCK);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_FLESH_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_WART_BLOCK);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.TWILIGHT_FESCUES, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NETHER_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.TWILIGHT_TENDRILS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NETHER_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_SPROUTS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NETHER_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_TENDRILS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NETHER_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.PHOTOFERN, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NETHER_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_SHRUB, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NETHER_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.PYRACINTH, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NETHER_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.CRYSTINIUM, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NETHER_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.POLYPITE_QUARTZ, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NETHER_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.POLYPITE_SULFUR_QUARTZ, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NETHER_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.POLYPITE_ROSE_QUARTZ, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NETHER_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.POLYPITE_SMOKY_QUARTZ, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NETHER_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.TWILIGHT_VINE_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NETHER_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.GHASTLY_ECTOPLASM, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_NETHER_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.TALL_PHOTOFERN, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_TALL_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.LUMINOUS_POD, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_TALL_VEGETATION);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesItems.BRAMBLE_BERRIES, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_, (ItemLike)NATURAL_BERRIES);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_SIGN, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_, (ItemLike)FUNCTIONAL_NETHER_SIGN);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.SCORCHED_HANGING_SIGN, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_, (ItemLike)FUNCTIONAL_NETHER_SIGN);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_SIGN, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_, (ItemLike)FUNCTIONAL_NETHER_SIGN);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesBlocks.UMBRAL_HANGING_SIGN, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_, (ItemLike)FUNCTIONAL_NETHER_SIGN);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesItems.BRAMBLE_BERRIES, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256839_, (ItemLike)FOOD_BERRIES);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesItems.SULFUR_QUARTZ, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_, (ItemLike)INGREDIENTS_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesItems.ROSE_QUARTZ, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_, (ItemLike)INGREDIENTS_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesItems.SMOKY_QUARTZ, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_, (ItemLike)INGREDIENTS_QUARTZ);
        CinderscapesItemGroups.addGroupEntry((ItemLike)CinderscapesItems.SULFUR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_, (ItemLike)INGREDIENTS_QUARTZ);
        for (ResourceKey<CreativeModeTab> group : ITEM_GROUP_ENTRY_MAPS.keySet()) {
            ItemGroupEvents.modifyEntriesEvent(group).register(content -> {
                FeatureFlagSet featureSet = content.getEnabledFeatures();
                HashMap<ItemLike, ItemGroupEntries> entryMap = ITEM_GROUP_ENTRY_MAPS.get(group);
                for (ItemLike relative : entryMap.keySet()) {
                    ItemGroupEntries entries = entryMap.get(relative);
                    if (relative == null) {
                        content.m_246601_(entries.getCollection());
                        continue;
                    }
                    content.addAfter(relative, entries.getCollection());
                }
            });
        }
        Registry.m_194579_((Registry)BuiltInRegistries.f_279662_, ITEM_GROUP, (Object)FabricItemGroup.builder().m_257941_((Component)Component.m_237113_((String)"Cinderscapes")).m_257737_(() -> CinderscapesBlocks.UMBRAL_FUNGUS.m_5456_().m_7968_()).m_257501_((context, entries) -> ITEM_GROUP_ENTRY_MAPS.values().stream().map(HashMap::values).flatMap(Collection::stream).map(ItemGroupEntries::getCollection).flatMap(Collection::stream).collect(Collectors.groupingByConcurrent(ItemStack::m_41720_)).keySet().stream().sorted(Comparator.comparing(item -> item.m_41466_().getString())).forEach(arg_0 -> ((CreativeModeTab.Output)entries).m_246326_(arg_0))).m_257652_());
    }
}

