/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.init;

import com.terraformersmc.cinderscapes.block.PolypiteQuartzBlock;
import com.terraformersmc.cinderscapes.feature.config.CrystalShardFeatureConfig;
import com.terraformersmc.cinderscapes.feature.config.PolypiteQuartzFeatureConfig;
import com.terraformersmc.cinderscapes.feature.config.ShaleFeatureConfig;
import com.terraformersmc.cinderscapes.init.CinderscapesBlocks;
import com.terraformersmc.cinderscapes.init.CinderscapesFeatures;
import java.util.List;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public final class CinderscapesConfiguredFeatures {
    private static final RuleTest RULE_TEST_BASE_STONE_NETHER = new TagMatchTest(BlockTags.f_13062_);
    private static final RuleTest RULE_TEST_NETHERRACK = new BlockMatchTest(Blocks.f_50134_);
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEBRIS_ORE_LARGE = CinderscapesConfiguredFeatures.createRegistryKey("ashy_shoals/debris_ore_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEBRIS_ORE_SMALL = CinderscapesConfiguredFeatures.createRegistryKey("ashy_shoals/debris_ore_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ASH_PILE = CinderscapesConfiguredFeatures.createRegistryKey("ashy_shoals/ash_pile");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ASHY_VEGETATION = CinderscapesConfiguredFeatures.createRegistryKey("ashy_shoals/vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BRAMBLE_BERRY_BUSHES = CinderscapesConfiguredFeatures.createRegistryKey("ashy_shoals/bramble_berry_bushes");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ASHY_SOUL_SAND = CinderscapesConfiguredFeatures.createRegistryKey("ashy_shoals/soul_sand");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ASHY_SOUL_SOIL = CinderscapesConfiguredFeatures.createRegistryKey("ashy_shoals/soul_soil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ASHY_GRAVEL = CinderscapesConfiguredFeatures.createRegistryKey("ashy_shoals/gravel");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ASH_TOP_LAYER = CinderscapesConfiguredFeatures.createRegistryKey("ashy_shoals/ash_top_layer");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEAD_TREE = CinderscapesConfiguredFeatures.createRegistryKey("ashy_shoals/dead_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WEEPING_VINE = CinderscapesConfiguredFeatures.createRegistryKey("blackstone_shales/weeping_vine");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHALES_SOUL_SAND = CinderscapesConfiguredFeatures.createRegistryKey("blackstone_shales/soul_sand");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHALES_SOUL_SOIL = CinderscapesConfiguredFeatures.createRegistryKey("blackstone_shales/soul_soil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHALE = CinderscapesConfiguredFeatures.createRegistryKey("blackstone_shales/shale");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHROOMLIGHT_BUSH = CinderscapesConfiguredFeatures.createRegistryKey("luminous_grove/shroomlight_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> UMBRAL_VINE = CinderscapesConfiguredFeatures.createRegistryKey("luminous_grove/umbral_vine");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LUMINOUS_VEGETATION = CinderscapesConfiguredFeatures.createRegistryKey("luminous_grove/vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LUMINOUS_POD = CinderscapesConfiguredFeatures.createRegistryKey("luminous_grove/luminous_pod");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_PHOTOFERN = CinderscapesConfiguredFeatures.createRegistryKey("luminous_grove/tall_photofern");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CANOPIED_HUGE_FUNGUS = CinderscapesConfiguredFeatures.createRegistryKey("luminous_grove/canopied_huge_fungus");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CANOPIED_HUGE_FUNGUS_PLANTED = CinderscapesConfiguredFeatures.createRegistryKey("luminous_grove/canopied_huge_fungus_planted");
    public static final ResourceKey<ConfiguredFeature<?, ?>> QUARTZ_VEGETATION = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> QUARTZ_ORE = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/quartz_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SULFUR_QUARTZ_ORE = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/sulfur_quartz_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROSE_QUARTZ_ORE = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/rose_quartz_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMOKY_QUARTZ_ORE = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/smoky_quartz_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GOLD_ORE = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/gold_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SULFUR_ORE = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/sulfur_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CEILING_SHARD_QUARTZ = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/ceiling_shard_quartz");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CEILING_SHARD_SULFUR_QUARTZ = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/ceiling_shard_sulfur_quartz");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CEILING_SHARD_ROSE_QUARTZ = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/ceiling_shard_rose_quartz");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CEILING_SHARD_SMOKY_QUARTZ = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/ceiling_shard_smoky_quartz");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOOR_SHARD_QUARTZ = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/floor_shard_quartz");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOOR_SHARD_SULFUR_QUARTZ = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/floor_shard_sulfur_quartz");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOOR_SHARD_ROSE_QUARTZ = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/floor_shard_rose_quartz");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOOR_SHARD_SMOKY_QUARTZ = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/floor_shard_smoky_quartz");
    public static final ResourceKey<ConfiguredFeature<?, ?>> POLYPITE_QUARTZ = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/polypite_quartz");
    public static final ResourceKey<ConfiguredFeature<?, ?>> POLYPITE_SULFUR_QUARTZ = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/polypite_sulfur_quartz");
    public static final ResourceKey<ConfiguredFeature<?, ?>> POLYPITE_ROSE_QUARTZ = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/polypite_rose_quartz");
    public static final ResourceKey<ConfiguredFeature<?, ?>> POLYPITE_SMOKY_QUARTZ = CinderscapesConfiguredFeatures.createRegistryKey("quartz_cavern/polypite_smoky_quartz");

    public static void populate(FabricDynamicRegistryProvider.Entries entries) {
        entries.add(DEBRIS_ORE_LARGE, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65731_, new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)RULE_TEST_BASE_STONE_NETHER, (BlockState)Blocks.f_50722_.m_49966_())), 3, 1.0f)));
        entries.add(DEBRIS_ORE_SMALL, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65731_, new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)RULE_TEST_BASE_STONE_NETHER, (BlockState)Blocks.f_50722_.m_49966_())), 2, 1.0f)));
        entries.add(ASH_PILE, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.ASH_PILE, FeatureConfiguration.f_67737_));
        entries.add(ASHY_VEGETATION, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.VEGETATION, CinderscapesFeatures.ASHY_SHOALS_VEGETATION_CONFIG));
        entries.add(BRAMBLE_BERRY_BUSHES, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65763_, CinderscapesFeatures.BRAMBLE_BERRY_BUSH_CONFIG));
        entries.add(ASHY_SOUL_SAND, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65749_, CinderscapesFeatures.SOUL_SAND_REPLACE_CONFIG));
        entries.add(ASHY_SOUL_SOIL, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65749_, CinderscapesFeatures.SOUL_SOIL_REPLACE_CONFIG));
        entries.add(ASHY_GRAVEL, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65749_, CinderscapesFeatures.GRAVEL_REPLACE_CONFIG));
        entries.add(ASH_TOP_LAYER, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.ASH_TOP_LAYER, FeatureConfiguration.f_67737_));
        entries.add(DEAD_TREE, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.DEAD_TREE, FeatureConfiguration.f_67737_));
        entries.add(WEEPING_VINE, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65745_, FeatureConfiguration.f_67737_));
        entries.add(SHALES_SOUL_SAND, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65749_, CinderscapesFeatures.SOUL_SAND_REPLACE_CONFIG));
        entries.add(SHALES_SOUL_SOIL, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65749_, CinderscapesFeatures.SOUL_SOIL_REPLACE_CONFIG));
        entries.add(SHALE, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.SHALE_FEATURE, new ShaleFeatureConfig(Blocks.f_50730_.m_49966_(), 7, 12)));
        entries.add(SHROOMLIGHT_BUSH, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.SHROOMLIGHT_BUSH, FeatureConfiguration.f_67737_));
        entries.add(UMBRAL_VINE, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.UMBRAL_VINE, FeatureConfiguration.f_67737_));
        entries.add(LUMINOUS_VEGETATION, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.VEGETATION, CinderscapesFeatures.LUMINOUS_GROVE_VEGETATION_CONFIG));
        entries.add(LUMINOUS_POD, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65763_, CinderscapesFeatures.LUMINOUS_POD_CONFIG));
        entries.add(TALL_PHOTOFERN, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65763_, CinderscapesFeatures.TALL_PHOTOFERN_CONFIG));
        entries.add(CANOPIED_HUGE_FUNGUS, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.CANOPIED_HUGE_FUNGUS, CinderscapesFeatures.UMBRAL_FUNGUS_NOT_PLANTED_CONFIG));
        entries.add(CANOPIED_HUGE_FUNGUS_PLANTED, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.CANOPIED_HUGE_FUNGUS, CinderscapesFeatures.UMBRAL_FUNGUS_CONFIG));
        entries.add(QUARTZ_VEGETATION, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.VEGETATION, CinderscapesFeatures.QUARTZ_CAVERN_VEGETATION_CONFIG));
        entries.add(QUARTZ_ORE, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65731_, new OreConfiguration(RULE_TEST_NETHERRACK, Blocks.f_50331_.m_49966_(), 14)));
        entries.add(SULFUR_QUARTZ_ORE, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65731_, new OreConfiguration(RULE_TEST_NETHERRACK, CinderscapesBlocks.SULFUR_QUARTZ_ORE.m_49966_(), 14)));
        entries.add(ROSE_QUARTZ_ORE, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65731_, new OreConfiguration(RULE_TEST_NETHERRACK, CinderscapesBlocks.ROSE_QUARTZ_ORE.m_49966_(), 14)));
        entries.add(SMOKY_QUARTZ_ORE, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65731_, new OreConfiguration(RULE_TEST_NETHERRACK, CinderscapesBlocks.SMOKY_QUARTZ_ORE.m_49966_(), 14)));
        entries.add(GOLD_ORE, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65731_, new OreConfiguration(RULE_TEST_NETHERRACK, Blocks.f_49998_.m_49966_(), 10)));
        entries.add(SULFUR_ORE, CinderscapesConfiguredFeatures.configureFeature(Feature.f_65731_, new OreConfiguration(RULE_TEST_NETHERRACK, CinderscapesBlocks.SULFUR_ORE.m_49966_(), 14)));
        List<BlockState> SHARD_WHITELIST = List.of(Blocks.f_50016_.m_49966_(), Blocks.f_49994_.m_49966_(), Blocks.f_50134_.m_49966_(), Blocks.f_50135_.m_49966_(), Blocks.f_50331_.m_49966_(), CinderscapesBlocks.ROSE_QUARTZ_ORE.m_49966_(), CinderscapesBlocks.SMOKY_QUARTZ_ORE.m_49966_(), CinderscapesBlocks.SULFUR_QUARTZ_ORE.m_49966_(), CinderscapesBlocks.SULFUR_ORE.m_49966_());
        entries.add(CEILING_SHARD_QUARTZ, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.CRYSTAL_SHARD_FEATURE, new CrystalShardFeatureConfig(CinderscapesBlocks.CRYSTALLINE_QUARTZ.m_49966_(), Direction.DOWN, SHARD_WHITELIST)));
        entries.add(CEILING_SHARD_SULFUR_QUARTZ, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.CRYSTAL_SHARD_FEATURE, new CrystalShardFeatureConfig(CinderscapesBlocks.CRYSTALLINE_SULFUR_QUARTZ.m_49966_(), Direction.DOWN, SHARD_WHITELIST)));
        entries.add(CEILING_SHARD_ROSE_QUARTZ, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.CRYSTAL_SHARD_FEATURE, new CrystalShardFeatureConfig(CinderscapesBlocks.CRYSTALLINE_ROSE_QUARTZ.m_49966_(), Direction.DOWN, SHARD_WHITELIST)));
        entries.add(CEILING_SHARD_SMOKY_QUARTZ, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.CRYSTAL_SHARD_FEATURE, new CrystalShardFeatureConfig(CinderscapesBlocks.CRYSTALLINE_SMOKY_QUARTZ.m_49966_(), Direction.DOWN, SHARD_WHITELIST)));
        entries.add(FLOOR_SHARD_QUARTZ, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.CRYSTAL_SHARD_FEATURE, new CrystalShardFeatureConfig(CinderscapesBlocks.CRYSTALLINE_QUARTZ.m_49966_(), Direction.UP, SHARD_WHITELIST)));
        entries.add(FLOOR_SHARD_SULFUR_QUARTZ, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.CRYSTAL_SHARD_FEATURE, new CrystalShardFeatureConfig(CinderscapesBlocks.CRYSTALLINE_SULFUR_QUARTZ.m_49966_(), Direction.UP, SHARD_WHITELIST)));
        entries.add(FLOOR_SHARD_ROSE_QUARTZ, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.CRYSTAL_SHARD_FEATURE, new CrystalShardFeatureConfig(CinderscapesBlocks.CRYSTALLINE_ROSE_QUARTZ.m_49966_(), Direction.UP, SHARD_WHITELIST)));
        entries.add(FLOOR_SHARD_SMOKY_QUARTZ, CinderscapesConfiguredFeatures.configureFeature(CinderscapesFeatures.CRYSTAL_SHARD_FEATURE, new CrystalShardFeatureConfig(CinderscapesBlocks.CRYSTALLINE_SMOKY_QUARTZ.m_49966_(), Direction.UP, SHARD_WHITELIST)));
        entries.add(POLYPITE_QUARTZ, CinderscapesConfiguredFeatures.configurePolypiteQuartz((PolypiteQuartzBlock)CinderscapesBlocks.POLYPITE_QUARTZ));
        entries.add(POLYPITE_SULFUR_QUARTZ, CinderscapesConfiguredFeatures.configurePolypiteQuartz((PolypiteQuartzBlock)CinderscapesBlocks.POLYPITE_SULFUR_QUARTZ));
        entries.add(POLYPITE_ROSE_QUARTZ, CinderscapesConfiguredFeatures.configurePolypiteQuartz((PolypiteQuartzBlock)CinderscapesBlocks.POLYPITE_ROSE_QUARTZ));
        entries.add(POLYPITE_SMOKY_QUARTZ, CinderscapesConfiguredFeatures.configurePolypiteQuartz((PolypiteQuartzBlock)CinderscapesBlocks.POLYPITE_SMOKY_QUARTZ));
    }

    private static ConfiguredFeature<PolypiteQuartzFeatureConfig, ?> configurePolypiteQuartz(PolypiteQuartzBlock block) {
        return new ConfiguredFeature(CinderscapesFeatures.POLYPITE_QUARTZ, (FeatureConfiguration)new PolypiteQuartzFeatureConfig(block));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> createRegistryKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocation.m_214293_((String)"cinderscapes", (String)name));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> ConfiguredFeature<FC, ?> configureFeature(F feature, FC config) {
        return new ConfiguredFeature(feature, config);
    }

    public static void init() {
    }
}

