/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.feature;

import com.terraformersmc.cinderscapes.block.GhastlyEctoplasmBlock;
import com.terraformersmc.cinderscapes.init.CinderscapesBlocks;
import com.terraformersmc.cinderscapes.util.MathHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction8;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class UmbralVineFeature
extends Feature<NoneFeatureConfiguration> {
    public UmbralVineFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource random = context.m_225041_();
        BlockPos pos = context.m_159777_();
        WorldGenLevel world = context.m_159774_();
        while (pos.m_123342_() > context.m_159775_().m_6337_()) {
            if (world.m_8055_(pos).m_60734_() == Blocks.f_50134_ && !world.m_46859_(pos.m_7494_())) {
                boolean airBelow = false;
                for (int y = 0; y < 6; ++y) {
                    if (!world.m_46859_(pos.m_6625_(y))) continue;
                    airBelow = true;
                }
                if (airBelow) {
                    if (world.m_46859_(pos.m_122012_()) && !world.m_46859_(pos.m_122019_()) && !world.m_46859_(pos.m_122029_()) && !world.m_46859_(pos.m_122024_())) {
                        return this.angleVine(world, pos, Direction8.NORTH, random);
                    }
                    if (world.m_46859_(pos.m_122019_()) && !world.m_46859_(pos.m_122012_()) && !world.m_46859_(pos.m_122029_()) && !world.m_46859_(pos.m_122024_())) {
                        return this.angleVine(world, pos, Direction8.SOUTH, random);
                    }
                    if (world.m_46859_(pos.m_122029_()) && !world.m_46859_(pos.m_122019_()) && !world.m_46859_(pos.m_122012_()) && !world.m_46859_(pos.m_122024_())) {
                        return this.angleVine(world, pos, Direction8.EAST, random);
                    }
                    if (world.m_46859_(pos.m_122024_()) && !world.m_46859_(pos.m_122019_()) && !world.m_46859_(pos.m_122029_()) && !world.m_46859_(pos.m_122012_())) {
                        return this.angleVine(world, pos, Direction8.WEST, random);
                    }
                }
            }
            pos = pos.m_7495_();
        }
        return false;
    }

    public boolean angleVine(WorldGenLevel world, BlockPos origin, Direction8 dir, RandomSource random) {
        int eightWayOffset = random.m_188499_() ? 1 : -1;
        return this.buildVine(world, origin, dir, random) || this.buildVine(world, origin, this.getEightWayClockwiseRotation(dir, eightWayOffset), random) || this.buildVine(world, origin, this.getEightWayClockwiseRotation(dir, -eightWayOffset), random);
    }

    public boolean buildVine(WorldGenLevel world, BlockPos origin, Direction8 dir, RandomSource random) {
        ChunkPos chunkOrigin = new ChunkPos(origin);
        BlockPos.MutableBlockPos terminus = origin.m_122032_();
        terminus.m_122184_(5 * dir.m_235697_(), 0, 5 * dir.m_235698_());
        while (chunkOrigin.m_45594_(new ChunkPos((BlockPos)terminus)) < 2) {
            if (world.m_8055_((BlockPos)terminus).m_60734_() == Blocks.f_50134_) {
                return UmbralVineFeature.modifiedLine(world, CinderscapesBlocks.TWILIGHT_VINE_BLOCK.m_49966_(), (BlockPos)terminus, origin, random);
            }
            terminus.m_122184_(dir.m_235697_(), 0, dir.m_235698_());
        }
        return false;
    }

    public static boolean modifiedLine(WorldGenLevel world, BlockState state, BlockPos to, BlockPos from, RandomSource random) {
        BlockPos pos;
        int dx = to.m_123341_() - from.m_123341_();
        int dy = to.m_123342_() - from.m_123342_();
        int dz = to.m_123343_() - from.m_123343_();
        int dt = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        int randomDroop = -(random.m_188503_(dt / 2) + 1);
        dt = Math.round(MathHelper.max(Math.abs(dx), Math.abs(dy), Math.abs(dz), Math.abs(randomDroop)));
        float t = 0.0f;
        while (t < (float)dt) {
            pos = BlockPos.m_274561_((double)((float)from.m_123341_() + (float)dx / (float)dt * t), (double)((float)from.m_123342_() + (float)dy / (float)dt * t + MathHelper.map(t * t - (float)dt * t, (float)(-dt * dt) / 4.0f, 0.0f, randomDroop, 0.0f)), (double)((float)from.m_123343_() + (float)dz / (float)dt * t));
            if (!world.m_46859_(pos) && world.m_8055_(pos).m_60734_() != Blocks.f_50134_) {
                return false;
            }
            t = (float)((double)t + 0.25);
        }
        t = 0.0f;
        while (t < (float)dt) {
            pos = BlockPos.m_274561_((double)((float)from.m_123341_() + (float)dx / (float)dt * t), (double)((float)from.m_123342_() + (float)dy / (float)dt * t + MathHelper.map(t * t - (float)dt * t, (float)(-dt * dt) / 4.0f, 0.0f, randomDroop, 0.0f)), (double)((float)from.m_123343_() + (float)dz / (float)dt * t));
            world.m_7731_(pos, state, 0);
            if (random.m_188501_() > 0.8f) {
                int i;
                int ectoHeight = random.m_188503_(3) + 1;
                boolean clear = true;
                for (i = 1; i <= ectoHeight; ++i) {
                    if (world.m_46859_(pos.m_6625_(i))) continue;
                    clear = false;
                }
                if (clear) {
                    for (i = 1; i <= ectoHeight; ++i) {
                        if (!world.m_46859_(pos.m_6625_(i))) continue;
                        BlockState ectoState = ((GhastlyEctoplasmBlock)CinderscapesBlocks.GHASTLY_ECTOPLASM).typeOf(GhastlyEctoplasmBlock.Type.MIDDLE);
                        if (i == ectoHeight) {
                            ectoState = ((GhastlyEctoplasmBlock)CinderscapesBlocks.GHASTLY_ECTOPLASM).typeOf(GhastlyEctoplasmBlock.Type.BOTTOM);
                        }
                        if (i == 1 && ectoHeight >= 3) {
                            ectoState = ((GhastlyEctoplasmBlock)CinderscapesBlocks.GHASTLY_ECTOPLASM).typeOf(GhastlyEctoplasmBlock.Type.TOP);
                        }
                        world.m_7731_(pos.m_6625_(i), ectoState, 0);
                    }
                }
            }
            t = (float)((double)t + 0.25);
        }
        return true;
    }

    private Direction8 getEightWayClockwiseRotation(Direction8 direction, int increment) {
        assert (increment >= -8);
        return Direction8.values()[(direction.ordinal() + increment + 8) % 8];
    }
}

