/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.feature;

import com.terraformersmc.cinderscapes.init.CinderscapesBlocks;
import com.terraformersmc.terraform.shapes.api.Filler;
import com.terraformersmc.terraform.shapes.api.Position;
import com.terraformersmc.terraform.shapes.api.Quaternion;
import com.terraformersmc.terraform.shapes.api.Shape;
import com.terraformersmc.terraform.shapes.api.layer.Layer;
import com.terraformersmc.terraform.shapes.impl.Shapes;
import com.terraformersmc.terraform.shapes.impl.filler.SimpleFiller;
import com.terraformersmc.terraform.shapes.impl.layer.pathfinder.AddLayer;
import com.terraformersmc.terraform.shapes.impl.layer.transform.RotateLayer;
import com.terraformersmc.terraform.shapes.impl.layer.transform.TranslateLayer;
import com.terraformersmc.terraform.shapes.impl.validator.SafelistValidator;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DeadTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public DeadTreeFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource random = context.m_225041_();
        BlockPos pos = context.m_159777_();
        WorldGenLevel world = context.m_159774_();
        if (world.m_8055_(pos.m_7495_()).m_60734_() == CinderscapesBlocks.ASH) {
            pos = pos.m_7495_();
        }
        if (!Block.m_49918_((VoxelShape)world.m_8055_(pos.m_7495_()).m_60812_((BlockGetter)world, pos.m_7495_()), (Direction)Direction.UP)) {
            return false;
        }
        if (world.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50450_ || world.m_8055_(pos.m_7495_()).m_60734_() == CinderscapesBlocks.SCORCHED_STEM) {
            return false;
        }
        int trunkHeight = random.m_188503_(4) + 4;
        Shape trunkShape = DeadTreeFeature.verticalLine(trunkHeight, Quaternion.of((double)1.0, (double)0.0, (double)0.0, (double)0.0)).applyLayer((Layer)new TranslateLayer(Position.of((BlockPos)pos)));
        Shape topperShape = DeadTreeFeature.recursiveTreeTopper(random, 2, 4, 15, 45, 2, 5, 3, 3).applyLayer((Layer)new TranslateLayer(Position.of((double)0.0, (double)trunkHeight, (double)0.0))).applyLayer((Layer)new TranslateLayer(Position.of((BlockPos)pos)));
        SafelistValidator safelistValidator = new SafelistValidator((LevelSimulatedReader)world, Arrays.asList(Blocks.f_50016_.m_49966_(), CinderscapesBlocks.ASH.m_49966_()));
        boolean trunkSafe = safelistValidator.validate(trunkShape);
        boolean topperSafe = safelistValidator.validate(topperShape);
        if (trunkSafe && topperSafe) {
            trunkShape.fill((Filler)new SimpleFiller((LevelWriter)world, CinderscapesBlocks.SCORCHED_STEM.m_49966_()));
            topperShape.fill((Filler)new SimpleFiller((LevelWriter)world, CinderscapesBlocks.SCORCHED_HYPHAE.m_49966_()));
            return true;
        }
        return false;
    }

    private static Shape recursiveTreeTopper(RandomSource random, int minLength, int maxLength, int minSpread, int maxSpread, int minChildren, int maxChildren, int totalRecursionLevel, int recursionCounter) {
        Shape shape = Shapes.rectanglarPrism((double)1.0, (double)1.0, (double)1.0);
        if (recursionCounter == 0) {
            return shape;
        }
        int children = random.m_188503_(maxChildren - minChildren) + minChildren;
        for (int i = 0; i < children; ++i) {
            float recursionRatio = (float)recursionCounter / (float)totalRecursionLevel;
            int length = random.m_188503_(maxLength - minLength) + minLength;
            shape = shape.applyLayer((Layer)new AddLayer(Shapes.rectanglarPrism((double)1.0, (double)length, (double)1.0).applyLayer((Layer)new TranslateLayer(Position.of((double)0.0, (double)((float)length / 2.0f), (double)0.0))).applyLayer((Layer)new AddLayer(DeadTreeFeature.recursiveTreeTopper(random, minLength, (int)((float)(maxLength - minLength) * recursionRatio) + minLength, (int)((float)minSpread * recursionRatio), (int)((float)maxSpread * recursionRatio), (int)((float)minChildren * recursionRatio), (int)((float)maxChildren * recursionRatio), totalRecursionLevel, recursionCounter - 1).applyLayer((Layer)new TranslateLayer(Position.of((double)0.0, (double)length, (double)0.0))))).applyLayer((Layer)new RotateLayer(Quaternion.of((double)0.0, (double)(random.m_188501_() * 360.0f), (double)(random.m_188501_() * (float)(maxSpread - minSpread) + (float)minSpread), (boolean)true)))));
        }
        return shape;
    }

    private static Shape verticalLine(int height, Quaternion rotation) {
        return Shape.of(pos -> true, (Position)Position.of((double)1.0, (double)height, (double)1.0), (Position)Position.of((double)0.0, (double)0.0, (double)0.0)).applyLayer((Layer)new RotateLayer(rotation));
    }
}

