/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.feature;

import com.terraformersmc.cinderscapes.feature.config.CanopiedHugeFungusFeatureConfig;
import com.terraformersmc.terraform.shapes.api.Filler;
import com.terraformersmc.terraform.shapes.api.Position;
import com.terraformersmc.terraform.shapes.api.Shape;
import com.terraformersmc.terraform.shapes.api.layer.Layer;
import com.terraformersmc.terraform.shapes.impl.Shapes;
import com.terraformersmc.terraform.shapes.impl.filler.RandomSimpleFiller;
import com.terraformersmc.terraform.shapes.impl.filler.SimpleFiller;
import com.terraformersmc.terraform.shapes.impl.layer.pathfinder.AddLayer;
import com.terraformersmc.terraform.shapes.impl.layer.pathfinder.SubtractLayer;
import com.terraformersmc.terraform.shapes.impl.layer.transform.TranslateLayer;
import com.terraformersmc.terraform.shapes.impl.validator.AirValidator;
import com.terraformersmc.terraform.shapes.impl.validator.SafelistValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CanopiedHugeFungusFeature
extends Feature<CanopiedHugeFungusFeatureConfig> {
    private static final Random localRandom = new Random();

    public CanopiedHugeFungusFeature() {
        super(CanopiedHugeFungusFeatureConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<CanopiedHugeFungusFeatureConfig> context) {
        CanopiedHugeFungusFeatureConfig config = (CanopiedHugeFungusFeatureConfig)context.m_159778_();
        WorldGenLevel world = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource random = context.m_225041_();
        ArrayList<BlockState> baseSafeList = new ArrayList<BlockState>(List.of(config.soilBlock(), Blocks.f_50016_.m_49966_(), Blocks.f_50134_.m_49966_()));
        if (config.planted()) {
            if (world.m_8055_(pos.m_7495_()) != config.soilBlock()) {
                return false;
            }
            boolean solidGround = Shape.of(ipos -> true, (Position)Position.of((double)2.0, (double)0.0, (double)2.0), (Position)Position.of((double)-1.0, (double)-1.0, (double)-1.0)).applyLayer((Layer)TranslateLayer.of((Position)Position.of((BlockPos)pos))).stream().map(Position::toBlockPos).allMatch(ipos -> !world.m_46859_(ipos) && Block.m_49918_((VoxelShape)world.m_8055_(ipos).m_60812_((BlockGetter)world, pos.m_7495_()), (Direction)Direction.UP));
            if (!solidGround) {
                return false;
            }
            BlockState groundZero = world.m_8055_(pos);
            if (groundZero.m_60734_() instanceof FungusBlock) {
                baseSafeList.add(groundZero);
            }
        }
        int stemHeight = random.m_188503_(20) + 6;
        Shape stem = Shapes.ellipticalPrism((double)1.4, (double)1.4, (double)(0.8 * (double)stemHeight)).applyLayer((Layer)new TranslateLayer(Position.of((double)0.0, (double)(0.6 * (double)(stemHeight - 1)), (double)0.0))).applyLayer((Layer)new TranslateLayer(Position.of((BlockPos)pos)));
        Shape base = Shapes.rectanglarPrism((double)3.0, (double)(0.2 * (double)stemHeight), (double)3.0).applyLayer((Layer)new TranslateLayer(Position.of((double)0.0, (double)(0.1 * (double)(stemHeight - 1)), (double)0.0))).applyLayer((Layer)new TranslateLayer(Position.of((BlockPos)pos)));
        int canopyRadius = random.m_188503_(3) + 6;
        int canopyHeight = random.m_188503_(5) + 5;
        Position canopyPos = Position.of((BlockPos)pos.m_6630_(stemHeight - canopyHeight + 2));
        Shape canopy = Shapes.hemiEllipsoid((double)canopyRadius, (double)canopyRadius, (double)canopyHeight).applyLayer((Layer)new SubtractLayer(Shapes.hemiEllipsoid((double)(canopyRadius - 1), (double)(canopyRadius - 1), (double)(canopyHeight - 1)))).applyLayer((Layer)new AddLayer(Shapes.ellipticalPrism((double)canopyRadius, (double)canopyRadius, (double)1.0).applyLayer((Layer)new SubtractLayer(Shapes.ellipticalPrism((double)(canopyRadius - 1), (double)(canopyRadius - 1), (double)1.0))))).applyLayer((Layer)new TranslateLayer(canopyPos));
        Shape flesh = Shapes.hemiEllipsoid((double)(canopyRadius - 1), (double)(canopyRadius - 1), (double)(canopyHeight - 1)).applyLayer((Layer)new SubtractLayer(Shapes.hemiEllipsoid((double)(canopyRadius - 2), (double)(canopyRadius - 2), (double)(canopyHeight - 2)))).applyLayer((Layer)new TranslateLayer(canopyPos));
        Shape detailBlocks = Shapes.hemiEllipsoid((double)(canopyRadius - 2), (double)(canopyRadius - 2), (double)(canopyHeight - 2)).applyLayer((Layer)new SubtractLayer(Shapes.hemiEllipsoid((double)(canopyRadius - 3), (double)(canopyRadius - 3), (double)(canopyHeight - 3)))).applyLayer((Layer)new TranslateLayer(canopyPos));
        Shape fleshDripping = Shapes.ellipticalPrism((double)(canopyRadius - 1), (double)(canopyRadius - 1), (double)1.0).applyLayer((Layer)new SubtractLayer(Shapes.ellipticalPrism((double)(canopyRadius - 2), (double)(canopyRadius - 2), (double)1.0))).applyLayer((Layer)new TranslateLayer(canopyPos));
        Shape canopyDripping = Shapes.ellipticalPrism((double)canopyRadius, (double)canopyRadius, (double)1.0).applyLayer((Layer)new SubtractLayer(Shapes.ellipticalPrism((double)(canopyRadius - 1), (double)(canopyRadius - 1), (double)1.0))).applyLayer((Layer)new TranslateLayer(Position.of((BlockPos)canopyPos.toBlockPos().m_7495_())));
        boolean baseClear = SafelistValidator.of((LevelSimulatedReader)world, baseSafeList).validate(base);
        boolean stemClear = AirValidator.of((LevelSimulatedReader)world).validate(stem);
        boolean canopyClear = Stream.of(canopy, flesh, detailBlocks, fleshDripping, canopyDripping).allMatch(shape -> AirValidator.of((LevelSimulatedReader)world).validate(shape));
        if (baseClear && stemClear && canopyClear) {
            canopy.fill((Filler)new SimpleFiller((LevelWriter)world, config.canopyBlock()));
            canopyDripping.fill((Filler)new RandomSimpleFiller((LevelWriter)world, config.canopyBlock(), localRandom, 0.5f));
            flesh.fill((Filler)new SimpleFiller((LevelWriter)world, config.fleshBlock()));
            fleshDripping.fill((Filler)new RandomSimpleFiller((LevelWriter)world, config.fleshBlock(), localRandom, 0.5f));
            detailBlocks.fill((Filler)new RandomSimpleFiller((LevelWriter)world, config.decorationBlock(), localRandom, 0.2f));
            stem.fill((Filler)new SimpleFiller((LevelWriter)world, config.stemBlock()));
            base.fill((Filler)new SimpleFiller((LevelWriter)world, config.hyphaeBlock()));
            if (!config.planted()) {
                this.makePlatform(world, config, pos);
            }
            return true;
        }
        return false;
    }

    private void makePlatform(WorldGenLevel world, CanopiedHugeFungusFeatureConfig config, BlockPos origin) {
        for (BlockPos pos : Shapes.rectanglarPrism((double)3.0, (double)1.0, (double)3.0).applyLayer((Layer)new TranslateLayer(Position.of((BlockPos)origin))).stream().map(Position::toBlockPos).toList()) {
            for (int i = 1; i < 5; ++i) {
                if (!world.m_8055_(pos.m_6625_(i)).m_60796_((BlockGetter)world, pos.m_6625_(i))) continue;
                while (i > 1) {
                    world.m_7731_(pos.m_6625_(i), Blocks.f_50134_.m_49966_(), 3);
                    --i;
                }
                break;
            }
            world.m_7731_(pos.m_7495_(), config.soilBlock(), 3);
        }
    }
}

