/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.feature;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BlackstoneWeepingVinesFeature
extends Feature<NoneFeatureConfiguration> {
    public BlackstoneWeepingVinesFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource random = context.m_225041_();
        BlockPos pos = context.m_159777_();
        WorldGenLevel world = context.m_159774_();
        if (!world.m_46859_(pos)) {
            return false;
        }
        Block block = world.m_8055_(pos.m_7494_()).m_60734_();
        if (block != Blocks.f_50730_ && block != Blocks.f_50451_) {
            return false;
        }
        this.generateNetherWartBlocksInArea(world, random, pos);
        this.generateVinesInArea(world, random, pos);
        return true;
    }

    private void generateNetherWartBlocksInArea(WorldGenLevel world, RandomSource random, BlockPos pos) {
        world.m_7731_(pos, Blocks.f_50451_.m_49966_(), 2);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 200; ++i) {
            mutable.m_122154_((Vec3i)pos, random.m_188503_(6) - random.m_188503_(6), random.m_188503_(2) - random.m_188503_(5), random.m_188503_(6) - random.m_188503_(6));
            if (!world.m_46859_((BlockPos)mutable)) continue;
            int j = 0;
            for (Direction direction : Direction.values()) {
                Block block = world.m_8055_((BlockPos)mutable2.m_122159_((Vec3i)mutable, direction)).m_60734_();
                if (block == Blocks.f_50730_ || block == Blocks.f_50451_) {
                    ++j;
                }
                if (j > 1) break;
            }
            if (j != true) continue;
            world.m_7731_((BlockPos)mutable, Blocks.f_50451_.m_49966_(), 2);
        }
    }

    private void generateVinesInArea(WorldGenLevel world, RandomSource random, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 100; ++i) {
            Block block;
            mutable.m_122154_((Vec3i)pos, random.m_188503_(8) - random.m_188503_(8), random.m_188503_(2) - random.m_188503_(7), random.m_188503_(8) - random.m_188503_(8));
            if (!world.m_46859_((BlockPos)mutable) || (block = world.m_8055_(mutable.m_7494_()).m_60734_()) != Blocks.f_50730_ && block != Blocks.f_50451_) continue;
            int j = Mth.m_216271_((RandomSource)random, (int)1, (int)8);
            if (random.m_188503_(6) == 0) {
                j *= 2;
            }
            if (random.m_188503_(5) == 0) {
                j = 1;
            }
            BlackstoneWeepingVinesFeature.generateVineColumn(world, random, mutable, j, 17, 25);
        }
    }

    public static void generateVineColumn(WorldGenLevel world, RandomSource random, BlockPos.MutableBlockPos pos, int length, int minAge, int maxAge) {
        for (int i = 0; i <= length; ++i) {
            if (world.m_46859_((BlockPos)pos)) {
                if (i == length || !world.m_46859_(pos.m_7495_())) {
                    world.m_7731_((BlockPos)pos, (BlockState)Blocks.f_50702_.m_49966_().m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(Mth.m_216271_((RandomSource)random, (int)minAge, (int)maxAge))), 2);
                    break;
                }
                world.m_7731_((BlockPos)pos, Blocks.f_50703_.m_49966_(), 2);
            }
            pos.m_122173_(Direction.DOWN);
        }
    }
}

