/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.block;

import com.terraformersmc.cinderscapes.config.CinderscapesConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PolypiteQuartzBlock
extends Block {
    public static final EnumProperty<Direction> DIRECTION = EnumProperty.m_61587_((String)"direction", Direction.class);
    private static final Map<Direction, VoxelShape> DIRECTION_TO_SHAPE = new HashMap<Direction, VoxelShape>();

    public PolypiteQuartzBlock(BlockBehaviour.Properties settings) {
        super(settings.m_60953_(state -> CinderscapesConfig.INSTANCE.polypiteLuminance));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DIRECTION});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        Direction placementSide = (Direction)state.m_61143_(DIRECTION);
        if (!Block.m_49918_((VoxelShape)world.m_8055_(pos.m_121945_(placementSide)).m_60812_((BlockGetter)world, pos.m_121945_(placementSide)), (Direction)placementSide.m_122424_())) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction placeSide = context.m_43719_();
        BlockPos placeOnPos = context.m_8083_().m_121945_(placeSide.m_122424_());
        BlockState placeOnState = context.m_43725_().m_8055_(placeOnPos);
        return Block.m_49918_((VoxelShape)placeOnState.m_60812_((BlockGetter)context.m_43725_(), placeOnPos), (Direction)placeSide) ? (BlockState)this.m_49966_().m_61124_(DIRECTION, (Comparable)placeSide.m_122424_()) : Blocks.f_50016_.m_49966_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return DIRECTION_TO_SHAPE.get(state.m_61143_(DIRECTION));
    }

    public BlockState stateOf(Direction dir) {
        return (BlockState)this.m_49966_().m_61124_(DIRECTION, (Comparable)dir);
    }

    static {
        DIRECTION_TO_SHAPE.put(Direction.DOWN, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0));
        DIRECTION_TO_SHAPE.put(Direction.UP, Block.m_49796_((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        DIRECTION_TO_SHAPE.put(Direction.SOUTH, Block.m_49796_((double)3.0, (double)5.0, (double)6.0, (double)13.0, (double)13.0, (double)16.0));
        DIRECTION_TO_SHAPE.put(Direction.NORTH, Block.m_49796_((double)3.0, (double)5.0, (double)0.0, (double)13.0, (double)13.0, (double)10.0));
        DIRECTION_TO_SHAPE.put(Direction.EAST, Block.m_49796_((double)6.0, (double)5.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
        DIRECTION_TO_SHAPE.put(Direction.WEST, Block.m_49796_((double)0.0, (double)5.0, (double)3.0, (double)10.0, (double)13.0, (double)13.0));
    }
}

