/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.biome;

import com.terraformersmc.cinderscapes.init.CinderscapesPlacedFeatures;
import com.terraformersmc.cinderscapes.init.CinderscapesSoundEvents;
import com.terraformersmc.cinderscapes.mixin.OverworldBiomeCreatorAccessor;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.NetherPlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class LuminousGroveBiome {
    public static final Climate.ParameterPoint NOISE_POINT = Climate.m_186788_((float)0.35f, (float)0.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.225f);

    public static Biome create(FabricDynamicRegistryProvider.Entries entries) {
        return new Biome.BiomeBuilder().m_47601_(LuminousGroveBiome.createGenerationSettings(entries)).m_47605_(LuminousGroveBiome.createSpawnSettings()).m_264558_(false).m_47609_(2.0f).m_47611_(0.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48040_(OverworldBiomeCreatorAccessor.cinderscapes$callGetSkyColor(2.0f)).m_48034_(4159204).m_48037_(329011).m_48019_(2297392).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123785_, 0.01428f)).m_48023_((Holder)SoundEvents.f_12431_).m_48027_(new AmbientMoodSettings((Holder)SoundEvents.f_12484_, 6000, 8, 2.0)).m_48025_(new AmbientAdditionsSettings((Holder)SoundEvents.f_12378_, 0.0111)).m_48021_(Musics.m_263184_((Holder)BuiltInRegistries.f_256894_.m_263177_((Object)CinderscapesSoundEvents.LUMINOUS_GROVE_MUSIC))).m_48018_()).m_47592_();
    }

    private static BiomeGenerationSettings createGenerationSettings(FabricDynamicRegistryProvider.Entries entries) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(entries.placedFeatures(), entries.configuredCarvers());
        builder.m_255308_(GenerationStep.Carving.AIR, Carvers.f_126853_);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195284_);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195285_);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, OrePlacements.f_195315_);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195294_);
        BiomeDefaultFeatures.m_126773_((BiomeGenerationSettings.Builder)builder);
        builder.m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, entries.ref(CinderscapesPlacedFeatures.CANOPIED_HUGE_FUNGUS));
        builder.m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, entries.ref(CinderscapesPlacedFeatures.SHROOMLIGHT_BUSHES));
        builder.m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, entries.ref(CinderscapesPlacedFeatures.LUMINOUS_VEGETATION));
        builder.m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, entries.ref(CinderscapesPlacedFeatures.LUMINOUS_PODS));
        builder.m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, entries.ref(CinderscapesPlacedFeatures.TALL_PHOTOFERNS));
        builder.m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, entries.ref(CinderscapesPlacedFeatures.UMBRAL_VINES));
        return builder.m_255380_();
    }

    private static MobSpawnSettings createSpawnSettings() {
        MobSpawnSettings.Builder builder = new MobSpawnSettings.Builder();
        builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20482_, 60, 1, 2));
        return builder.m_48381_();
    }
}

