/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes;

import com.terraformersmc.cinderscapes.config.CinderscapesConfig;
import com.terraformersmc.cinderscapes.init.CinderscapesBiomes;
import com.terraformersmc.cinderscapes.init.CinderscapesBlocks;
import com.terraformersmc.cinderscapes.init.CinderscapesConfiguredFeatures;
import com.terraformersmc.cinderscapes.init.CinderscapesFeatures;
import com.terraformersmc.cinderscapes.init.CinderscapesItems;
import com.terraformersmc.cinderscapes.init.CinderscapesPlacedFeatures;
import com.terraformersmc.cinderscapes.init.CinderscapesPlacementModifierTypes;
import com.terraformersmc.cinderscapes.init.CinderscapesSoundEvents;
import com.terraformersmc.cinderscapes.init.CinderscapesTrades;
import com.terraformersmc.cinderscapes.item.CinderscapesItemGroups;
import java.util.ArrayList;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Cinderscapes
implements ModInitializer {
    public static final String NAMESPACE = "cinderscapes";
    public static final Logger LOGGER = LogManager.getLogger((String)StringUtils.capitalize((String)"cinderscapes"));
    private static Boolean initialized = false;
    private static final ArrayList<Runnable> runnables = new ArrayList(1);

    public void onInitialize() {
        try {
            SpawnPlacements.m_21754_((EntityType)EntityType.f_20500_, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
            SpawnPlacements.m_21754_((EntityType)EntityType.f_20531_, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CinderscapesConfig.init();
        CinderscapesBlocks.init();
        CinderscapesItems.init();
        CinderscapesPlacementModifierTypes.init();
        CinderscapesFeatures.init();
        CinderscapesConfiguredFeatures.init();
        CinderscapesPlacedFeatures.init();
        CinderscapesSoundEvents.init();
        CinderscapesBiomes.init();
        CinderscapesTrades.init();
        CinderscapesItemGroups.init();
        if (!FabricLoader.getInstance().isModLoaded("cinderscapes-worldgen")) {
            LOGGER.info("No Cinderscapes worldgen module present; Cinderscapes biomes will not generate.");
        }
        initialized = true;
        for (Runnable callback : runnables) {
            callback.run();
        }
    }

    public static void callbackWhenInitialized(Runnable callback) {
        if (initialized.booleanValue()) {
            callback.run();
        } else {
            runnables.add(callback);
        }
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(NAMESPACE, path);
    }
}

