/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.abridged.worldgen.structure;

import dev.worldgen.abridged.Abridged;
import dev.worldgen.abridged.registry.AbridgedRegistries;
import dev.worldgen.abridged.worldgen.structure.BridgeConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.common.world.PieceBeardifierModifier;

public class BridgePiece
extends TemplateStructurePiece
implements PieceBeardifierModifier {
    public static final ResourceLocation BEARD_BASE = Abridged.id("beard_base");
    public final ResourceLocation configId;
    public final ResourceLocation processorId;

    public BridgePiece(StructureTemplateManager manager, ResourceLocation id, BlockPos pos, Rotation rotation, Holder<BridgeConfig> config) {
        this(manager, id, pos, rotation, Mirror.NONE, config);
    }

    public BridgePiece(StructureTemplateManager manager, ResourceLocation id, BlockPos pos, Rotation rotation, Mirror mirror, Holder<BridgeConfig> config) {
        super(AbridgedRegistries.BRIDGE_PIECE, 0, manager, id, id.toString(), new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror), pos);
        this.configId = ((ResourceKey)config.m_203543_().get()).m_135782_();
        this.processorId = ((BridgeConfig)config.m_203334_()).getProcessorId();
    }

    public BridgePiece(StructureTemplateManager manager, CompoundTag nbt) {
        super(AbridgedRegistries.BRIDGE_PIECE, nbt, manager, id -> new StructurePlaceSettings().m_74379_(Rotation.valueOf((String)Abridged.getString(nbt, "rotation"))).m_74377_(Mirror.valueOf((String)Abridged.getString(nbt, "mirror"))));
        this.configId = ResourceLocation.m_135820_((String)Abridged.getString(nbt, "config"));
        this.processorId = ResourceLocation.m_135820_((String)Abridged.getString(nbt, "processor"));
    }

    public String templateName() {
        return this.f_163658_;
    }

    protected void m_183620_(StructurePieceSerializationContext p_230209_, CompoundTag nbt) {
        super.m_183620_(p_230209_, nbt);
        nbt.m_128359_("rotation", this.f_73657_.m_74404_().name());
        nbt.m_128359_("mirror", this.f_73657_.m_74401_().name());
        nbt.m_128359_("config", this.configId.toString());
        nbt.m_128359_("processor", this.processorId.toString());
    }

    public void m_213694_(WorldGenLevel p_228705_, StructureManager p_228706_, ChunkGenerator p_228707_, RandomSource p_228708_, BoundingBox p_228709_, ChunkPos p_228710_, BlockPos pivot) {
        Optional<StructureProcessorList> processorList = Abridged.getProcessor(p_228706_.m_220521_(), this.processorId);
        if (processorList.isPresent()) {
            for (StructureProcessor processor : processorList.get().m_74425_()) {
                this.f_73657_.m_74383_(processor);
            }
        }
        this.f_73657_.m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        super.m_213694_(p_228705_, p_228706_, p_228707_, p_228708_, p_228709_, p_228710_, pivot);
    }

    protected void m_213704_(String p_230214_, BlockPos p_230215_, ServerLevelAccessor p_230216_, RandomSource p_230217_, BoundingBox boundingBox) {
    }

    public BoundingBox getBeardifierBox() {
        return this.f_73383_;
    }

    public TerrainAdjustment getTerrainAdjustment() {
        return this.f_163658_.equals(BEARD_BASE.toString()) ? TerrainAdjustment.BEARD_THIN : TerrainAdjustment.NONE;
    }

    public int getGroundLevelDelta() {
        return 0;
    }
}

