/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.simplyswordsoverhaul.mixin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.jrdemiurge.simplyswordsoverhaul.Config;
import net.jrdemiurge.simplyswordsoverhaul.scheduler.Scheduler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.sweenus.simplyswords.api.SimplySwordsAPI;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.custom.WhisperwindSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WhisperwindSwordItem.class})
public abstract class MixinWhisperwindSword
extends UniqueSwordItem {
    @Unique
    private static final String WHISPERWIND_DASHING = "SimplySwordsWhisperwindDashing";
    @Unique
    private static final String WHISPERWIND_MOB_KILLED = "SimplySwordsWhisperwindMobKilled";
    @Unique
    private static final Map<UUID, Set<UUID>> DASH_HIT_MAP = new HashMap<UUID, Set<UUID>>();

    public MixinWhisperwindSword(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Inject(method={"hurtEnemy"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyHurtEnemyMethod(ItemStack stack, LivingEntity target, LivingEntity attacker, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.enableWhisperwindChanges) {
            return;
        }
        if (!attacker.m_9236_().m_5776_() && target.m_21223_() == 0.0f) {
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.3f, 1.8f);
            Player player = (Player)attacker;
            player.m_36335_().m_41524_((Item)((WhisperwindSwordItem)this), 0);
        }
        cir.setReturnValue((Object)super.m_7579_(stack, target, attacker));
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyUseMethod(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!Config.enableWhisperwindChanges) {
            return;
        }
        if (!user.m_9236_().m_5776_()) {
            boolean isOffHandItemNotOnCooldown;
            ItemStack offHandItem = user.m_21120_(InteractionHand.OFF_HAND);
            boolean isMainHandUse = hand == InteractionHand.MAIN_HAND;
            boolean bl = isOffHandItemNotOnCooldown = !user.m_36335_().m_41519_(offHandItem.m_41720_());
            if (isMainHandUse && isOffHandItemNotOnCooldown) {
                user.m_36335_().m_41524_(offHandItem.m_41720_(), 4);
            }
            int cooldown = Config.whisperwindCooldownTicks;
            double scale = (double)Config.whisperwindDashDistance / 11.0;
            boolean isDashing = user.getPersistentData().m_128471_(WHISPERWIND_DASHING);
            if (isDashing) {
                user.getPersistentData().m_128473_(WHISPERWIND_DASHING);
                user.m_20256_(Vec3.f_82478_);
                user.m_20242_(false);
                user.f_19864_ = true;
                ((ServerPlayer)user).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)user));
                if (!user.getPersistentData().m_128471_(WHISPERWIND_MOB_KILLED)) {
                    user.m_36335_().m_41524_((Item)((WhisperwindSwordItem)this), cooldown);
                } else {
                    user.getPersistentData().m_128473_(WHISPERWIND_MOB_KILLED);
                }
                DASH_HIT_MAP.remove(user.m_20148_());
                cir.setReturnValue((Object)super.m_7203_(world, user, hand));
                return;
            }
            user.getPersistentData().m_128379_(WHISPERWIND_DASHING, true);
            user.m_36335_().m_41524_((Item)((WhisperwindSwordItem)this), 2);
            world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_01.get(), user.m_5720_(), 0.6f, 1.0f);
            Vec3 look = user.m_20154_().m_82541_();
            Vec3 finalLook = look = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82541_().m_82490_(scale);
            user.f_19802_ = 20;
            user.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20, 4, false, false));
            int dashDuration = 7;
            user.m_20242_(true);
            user.f_19864_ = true;
            for (int i = 0; i < dashDuration; ++i) {
                int delay = i * 2;
                Scheduler.schedule(() -> {
                    if (!user.getPersistentData().m_128471_(WHISPERWIND_DASHING)) {
                        return;
                    }
                    user.m_20256_(finalLook);
                    ((ServerPlayer)user).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)user));
                    UUID playerId = user.m_20148_();
                    Set hitMobs = DASH_HIT_MAP.computeIfAbsent(playerId, k -> new HashSet());
                    AABB area = user.m_20191_().m_82400_(2.0);
                    List nearbyMobs = world.m_6443_(LivingEntity.class, area, entity -> entity != user);
                    for (LivingEntity mob : nearbyMobs) {
                        if (!HelperMethods.checkFriendlyFire((LivingEntity)mob, (LivingEntity)user) || hitMobs.contains(mob.m_20148_())) continue;
                        mob.m_6469_(user.m_269291_().m_269075_(user), MixinWhisperwindSword.calculateDamage(user, (Entity)mob));
                        hitMobs.add(mob.m_20148_());
                        if (mob.m_21223_() != 0.0f) continue;
                        user.m_9236_().m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), user.m_5720_(), 0.3f, 1.8f);
                        user.getPersistentData().m_128379_(WHISPERWIND_MOB_KILLED, true);
                    }
                    int particleRadius = 1;
                    double xpos = user.m_20185_() - (double)(particleRadius + 1);
                    double ypos = user.m_20186_();
                    double zpos = user.m_20189_() - (double)(particleRadius + 1);
                    for (int b = particleRadius * 2; b > 0; --b) {
                        for (int j = particleRadius * 2; j > 0; --j) {
                            float choose = (float)(Math.random() * 1.0);
                            HelperMethods.spawnParticle((Level)world, (ParticleOptions)ParticleTypes.f_175830_, (double)(xpos + (double)b + (double)choose), (double)(ypos + 0.4), (double)(zpos + (double)j + (double)choose), (double)0.0, (double)0.1, (double)0.0);
                            HelperMethods.spawnParticle((Level)world, (ParticleOptions)ParticleTypes.f_123796_, (double)(xpos + (double)b + (double)choose), (double)(ypos + 0.1), (double)(zpos + (double)j + (double)choose), (double)0.0, (double)0.0, (double)0.0);
                            HelperMethods.spawnParticle((Level)world, (ParticleOptions)ParticleTypes.f_123785_, (double)(xpos + (double)b + (double)choose), (double)ypos, (double)(zpos + (double)j + (double)choose), (double)0.0, (double)0.1, (double)0.0);
                        }
                    }
                }, delay, 0);
            }
            Scheduler.schedule(() -> {
                if (!user.getPersistentData().m_128471_(WHISPERWIND_DASHING)) {
                    return;
                }
                user.getPersistentData().m_128473_(WHISPERWIND_DASHING);
                user.m_20256_(Vec3.f_82478_);
                user.m_20242_(false);
                user.f_19864_ = true;
                ((ServerPlayer)user).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)user));
                if (!user.getPersistentData().m_128471_(WHISPERWIND_MOB_KILLED)) {
                    user.m_36335_().m_41524_((Item)((WhisperwindSwordItem)this), cooldown);
                } else {
                    user.getPersistentData().m_128473_(WHISPERWIND_MOB_KILLED);
                }
                DASH_HIT_MAP.remove(user.m_20148_());
            }, dashDuration * 2, 0);
        }
        cir.setReturnValue((Object)super.m_7203_(world, user, hand));
    }

    private static float calculateDamage(Player player, Entity target) {
        boolean flag2;
        float enchantmentBonus;
        float baseDamage = (float)player.m_21133_(Attributes.f_22281_);
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            enchantmentBonus = EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)livingTarget.m_6336_());
        } else {
            enchantmentBonus = EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)MobType.f_21640_);
        }
        CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)player, (Entity)target, (boolean)true, (float)1.5f);
        boolean bl = flag2 = hitResult != null;
        if (flag2) {
            baseDamage *= hitResult.getDamageModifier();
        }
        return baseDamage + enchantmentBonus;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext, CallbackInfo ci) {
        if (!Config.enableWhisperwindChanges) {
            return;
        }
        ci.cancel();
        int dashDistance = Config.whisperwindDashDistance;
        String translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.whisperwinditem", (Object[])new Object[]{dashDistance}).getString();
        for (String line : translatedText.split("\n")) {
            tooltip.add((Component)Component.m_237113_((String)line));
        }
        int cooldown = Config.whisperwindCooldownTicks;
        float floatCooldown = (float)cooldown / 20.0f;
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.simply_swords_overhaul.whisperwinditem_1").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
        } else {
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
            SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
            if (!tooltip.get(tooltip.size() - 1).getString().equals(Component.m_237115_((String)"item.simplyswords.common.showtooltip").getString())) {
                tooltip.add((Component)Component.m_237113_((String)""));
            }
            tooltip.add((Component)Component.m_237115_((String)"tooltip.simply_swords_overhaul.shift"));
        }
    }
}

