/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.simplyswordsoverhaul.mixin;

import java.util.List;
import net.jrdemiurge.simplyswordsoverhaul.Config;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sweenus.simplyswords.api.SimplySwordsAPI;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.custom.WatcherSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WatcherSwordItem.class})
public abstract class MixinWatcherSword
extends UniqueSwordItem {
    public MixinWatcherSword(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Inject(method={"hurtEnemy"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyHurtEnemyMethod(ItemStack stack, LivingEntity target, LivingEntity attacker, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.enableWatcherChanges) {
            return;
        }
        if (!attacker.m_9236_().m_5776_()) {
            double hitHealAmount = Config.watcherHitHealAmount;
            double killHealPercent = Config.watcherKillHealPercent;
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            attacker.m_5634_((float)hitHealAmount);
            if (target.m_21223_() == 0.0f) {
                float healAmount = target.m_21233_() * (float)killHealPercent;
                attacker.m_5634_(healAmount);
                world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_03.get(), target.m_5720_(), 0.7f, 1.2f);
            }
        }
        cir.setReturnValue((Object)super.m_7579_(stack, target, attacker));
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext, CallbackInfo ci) {
        if (!Config.enableWatcherChanges) {
            return;
        }
        ci.cancel();
        double hitHealAmount = Config.watcherHitHealAmount;
        double killHealPercent = Config.watcherKillHealPercent;
        String translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.watchersworditem", (Object[])new Object[]{killHealPercent * 100.0, hitHealAmount}).getString();
        for (String line : translatedText.split("\n")) {
            tooltip.add((Component)Component.m_237113_((String)line));
        }
        SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
    }
}

