/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.simplyswordsoverhaul.mixin;

import java.util.List;
import net.jrdemiurge.simplyswordsoverhaul.Config;
import net.jrdemiurge.simplyswordsoverhaul.scheduler.Scheduler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sweenus.simplyswords.api.SimplySwordsAPI;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.custom.StormsEdgeSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StormsEdgeSwordItem.class})
public abstract class MixinStormsEdgeSword
extends UniqueSwordItem {
    public MixinStormsEdgeSword(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Inject(method={"hurtEnemy"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyHurtEnemyMethod(ItemStack stack, LivingEntity target, LivingEntity attacker, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.enableStormsEdgeChanges) {
            return;
        }
        if (!attacker.m_9236_().m_5776_()) {
            int cooldownReduction = Config.stormsEdgeHitCooldownReduction;
            Player player = (Player)attacker;
            this.reduceCooldown(player, (Item)((StormsEdgeSwordItem)this), cooldownReduction);
        }
        cir.setReturnValue((Object)super.m_7579_(stack, target, attacker));
    }

    private void reduceCooldown(Player player, Item item, int reductionTicks) {
        CompoundTag playerData = player.getPersistentData();
        String cooldownKey = "storms_edge_last_cooldown";
        int lastCooldown = playerData.m_128451_(cooldownKey);
        float cooldownPercent = player.m_36335_().m_41521_(item, 0.0f);
        int remainingTicks = Math.round((float)lastCooldown * cooldownPercent);
        int newCooldown = Math.max(0, remainingTicks - reductionTicks);
        playerData.m_128405_(cooldownKey, newCooldown);
        player.m_36335_().m_41524_(item, newCooldown);
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyUseMethod(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!Config.enableStormsEdgeChanges) {
            return;
        }
        if (!user.m_9236_().m_5776_()) {
            double angleY;
            boolean isOffHandItemNotOnCooldown;
            ItemStack offHandItem = user.m_21120_(InteractionHand.OFF_HAND);
            boolean isMainHandUse = hand == InteractionHand.MAIN_HAND;
            boolean bl = isOffHandItemNotOnCooldown = !user.m_36335_().m_41519_(offHandItem.m_41720_());
            if (isMainHandUse && isOffHandItemNotOnCooldown) {
                user.m_36335_().m_41524_(offHandItem.m_41720_(), 4);
            }
            int cooldownReduction = Config.stormsEdgeHitCooldownReduction;
            int cooldown = Config.stormsEdgeCooldownTicks;
            double scale = Config.stormsEdgeDashDistance / 6.0;
            int effectDuration = Config.stormsEdgeEffectDuration;
            int maxHasteLevel = Config.stormsEdgeMaxHasteLevel;
            CompoundTag playerData = user.getPersistentData();
            String cooldownKey = "storms_edge_last_cooldown";
            playerData.m_128405_(cooldownKey, cooldown);
            world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_BOW_CHARGE_SHORT_VERSION.get(), user.m_5720_(), 0.4f, 1.2f);
            Vec3 look = user.m_20154_().m_82541_();
            if (user.m_6144_()) {
                look = look.m_82490_(-1.0);
            }
            if (Math.abs(angleY = Math.toDegrees(Math.asin(look.f_82480_))) <= 10.0 || user.m_20096_() & angleY < 0.0) {
                look = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82541_();
            }
            Vec3 dashVelocity = look.m_82490_(scale);
            user.f_19802_ = 15;
            user.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 15, 4, false, false));
            int dashDuration = 4;
            user.m_20242_(true);
            for (int i = 0; i < dashDuration; ++i) {
                int delay = i * 2;
                Scheduler.schedule(() -> {
                    user.m_20256_(dashVelocity);
                    ((ServerPlayer)user).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)user));
                    AABB area = user.m_20191_().m_82400_(1.5);
                    List nearbyMobs = world.m_6443_(LivingEntity.class, area, entity -> entity != user);
                    for (LivingEntity mob : nearbyMobs) {
                        if (!HelperMethods.checkFriendlyFire((LivingEntity)mob, (LivingEntity)user)) continue;
                        if (mob.f_19802_ == 0) {
                            this.reduceCooldown(user, (Item)((StormsEdgeSwordItem)this), cooldownReduction);
                        }
                        mob.m_6469_(user.m_269291_().m_269075_(user), MixinStormsEdgeSword.calculateDamage(user, (Entity)mob));
                    }
                    int particleRadius = 1;
                    double xpos = user.m_20185_() - (double)(particleRadius + 1);
                    double ypos = user.m_20186_();
                    double zpos = user.m_20189_() - (double)(particleRadius + 1);
                    for (int b = particleRadius * 2; b > 0; --b) {
                        for (int j = particleRadius * 2; j > 0; --j) {
                            float choose = (float)(Math.random() * 1.0);
                            HelperMethods.spawnParticle((Level)world, (ParticleOptions)ParticleTypes.f_175830_, (double)(xpos + (double)b + (double)choose), (double)(ypos + 0.4), (double)(zpos + (double)j + (double)choose), (double)0.0, (double)0.1, (double)0.0);
                            HelperMethods.spawnParticle((Level)world, (ParticleOptions)ParticleTypes.f_123796_, (double)(xpos + (double)b + (double)choose), (double)(ypos + 0.1), (double)(zpos + (double)j + (double)choose), (double)0.0, (double)0.0, (double)0.0);
                            HelperMethods.spawnParticle((Level)world, (ParticleOptions)ParticleTypes.f_123785_, (double)(xpos + (double)b + (double)choose), (double)ypos, (double)(zpos + (double)j + (double)choose), (double)0.0, (double)0.1, (double)0.0);
                        }
                    }
                }, delay, 0);
            }
            boolean[] shouldDisableGravity = new boolean[]{false};
            Scheduler.schedule(() -> {
                user.m_20256_(Vec3.f_82478_);
                if (!user.m_20096_()) {
                    shouldDisableGravity[0] = true;
                } else {
                    user.m_20242_(false);
                    user.f_19864_ = true;
                }
                ((ServerPlayer)user).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)user));
            }, dashDuration * 2, 0);
            Scheduler.schedule(() -> {
                if (shouldDisableGravity[0]) {
                    user.m_20242_(false);
                    user.f_19864_ = true;
                }
            }, dashDuration * 2 + 6, 0);
            if (user.m_21023_(MobEffects.f_19598_)) {
                int effectLevel = user.m_21124_(MobEffects.f_19598_).m_19564_();
                if (effectLevel > maxHasteLevel - 2) {
                    effectLevel = maxHasteLevel - 2;
                }
                user.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 20 * effectDuration, effectLevel + 1, false, true));
            } else {
                user.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 20 * effectDuration, 0, false, true));
            }
            user.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 20 * effectDuration, 0, false, true));
            user.m_36335_().m_41524_((Item)((StormsEdgeSwordItem)this), cooldown);
        }
        cir.setReturnValue((Object)super.m_7203_(world, user, hand));
    }

    private static float calculateDamage(Player player, Entity target) {
        float enchantmentBonus;
        float baseDamage = (float)player.m_21133_(Attributes.f_22281_);
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            enchantmentBonus = EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)livingTarget.m_6336_());
        } else {
            enchantmentBonus = EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)MobType.f_21640_);
        }
        return baseDamage + enchantmentBonus;
    }

    @Inject(method={"onUseTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyOnUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks, CallbackInfo ci) {
        if (!Config.enableStormsEdgeChanges) {
            return;
        }
        ci.cancel();
    }

    @Inject(method={"releaseUsing"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyReleaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, CallbackInfo ci) {
        if (!Config.enableStormsEdgeChanges) {
            return;
        }
        ci.cancel();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext, CallbackInfo ci) {
        if (!Config.enableStormsEdgeChanges) {
            return;
        }
        ci.cancel();
        float cooldownReduction = (float)Config.stormsEdgeHitCooldownReduction / 20.0f;
        int cooldown = Config.stormsEdgeCooldownTicks;
        double dashDistance = Config.stormsEdgeDashDistance;
        int maxHasteLevel = Config.stormsEdgeMaxHasteLevel;
        float floatCooldown = (float)cooldown / 20.0f;
        if (Screen.m_96639_()) {
            String translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.stormsedgeitem_1", (Object[])new Object[]{Float.valueOf(cooldownReduction)}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.stormsedgeitem_2", (Object[])new Object[]{dashDistance}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
            SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
        } else if (Screen.m_96638_()) {
            String translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.stormsedgeitem_1", (Object[])new Object[]{Float.valueOf(cooldownReduction)}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.stormsedgeitem_shift_1").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line).m_130940_(ChatFormatting.GRAY));
            }
            translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.stormsedgeitem_2", (Object[])new Object[]{dashDistance}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.stormsedgeitem_shift_2", (Object[])new Object[]{maxHasteLevel}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line).m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
        } else {
            String translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.stormsedgeitem_1", (Object[])new Object[]{Float.valueOf(cooldownReduction)}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.stormsedgeitem_2", (Object[])new Object[]{dashDistance}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
            SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
            if (!tooltip.get(tooltip.size() - 1).getString().equals(Component.m_237115_((String)"item.simplyswords.common.showtooltip").getString())) {
                tooltip.add((Component)Component.m_237113_((String)""));
            }
            tooltip.add((Component)Component.m_237115_((String)"tooltip.simply_swords_overhaul.shift"));
        }
    }
}

