/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.simplyswordsoverhaul.mixin;

import java.util.List;
import net.jrdemiurge.simplyswordsoverhaul.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sweenus.simplyswords.api.SimplySwordsAPI;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.custom.SoulPyreSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SoulPyreSwordItem.class})
public abstract class MixinSoulPyreSword
extends UniqueSwordItem {
    @Unique
    private static int simply_Swords_Overhaul_1_20_1$stepMod = 0;

    public MixinSoulPyreSword(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Inject(method={"hurtEnemy"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyHurtEnemyMethod(ItemStack stack, LivingEntity target, LivingEntity attacker, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.enableSoulPyreChanges) {
            return;
        }
        if (!attacker.m_9236_().m_5776_()) {
            int witherDuration = Config.soulPyreWitherDuration;
            int witherLevel = Config.soulPyreWitherLevel;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 20 * witherDuration, witherLevel - 1));
        }
        cir.setReturnValue((Object)super.m_7579_(stack, target, attacker));
    }

    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyInventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected, CallbackInfo ci) {
        if (!Config.enableSoulPyreChanges) {
            return;
        }
        if (simply_Swords_Overhaul_1_20_1$stepMod > 0) {
            --simply_Swords_Overhaul_1_20_1$stepMod;
        }
        if (simply_Swords_Overhaul_1_20_1$stepMod <= 0) {
            simply_Swords_Overhaul_1_20_1$stepMod = 7;
        }
        HelperMethods.createFootfalls((Entity)entity, (ItemStack)stack, (Level)world, (int)simply_Swords_Overhaul_1_20_1$stepMod, (SimpleParticleType)ParticleTypes.f_123745_, (SimpleParticleType)ParticleTypes.f_123745_, (SimpleParticleType)ParticleTypes.f_123757_, (boolean)true);
        HelperMethods.createFootfalls((Entity)entity, (ItemStack)stack, (Level)world, (int)simply_Swords_Overhaul_1_20_1$stepMod, (SimpleParticleType)ParticleTypes.f_175834_, (SimpleParticleType)ParticleTypes.f_175834_, (SimpleParticleType)ParticleTypes.f_123757_, (boolean)false);
        super.m_6883_(stack, world, entity, slot, selected);
        ci.cancel();
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyUseMethod(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!Config.enableSoulPyreChanges) {
            return;
        }
        if (!user.m_9236_().m_5776_()) {
            Vec3 end;
            boolean isOffHandItemNotOnCooldown;
            ItemStack offHandItem = user.m_21120_(InteractionHand.OFF_HAND);
            boolean isMainHandUse = hand == InteractionHand.MAIN_HAND;
            boolean bl = isOffHandItemNotOnCooldown = !user.m_36335_().m_41519_(offHandItem.m_41720_());
            if (isMainHandUse && isOffHandItemNotOnCooldown) {
                user.m_36335_().m_41524_(offHandItem.m_41720_(), 4);
            }
            double maxAbilityDistance = Config.soulPyreMaxAbilityDistance;
            double teleportDistance = Config.soulPyreTeleportDistance;
            int cooldown = Config.soulPyreCooldownTicks;
            Vec3 lookVec = user.m_20154_().m_82541_();
            Vec3 start = user.m_20182_().m_82520_(0.0, (double)user.m_20192_(), 0.0);
            EntityHitResult hitResult = ProjectileUtil.m_37304_((Level)world, (Entity)user, (Vec3)start, (Vec3)(end = start.m_82549_(lookVec.m_82541_().m_82490_(maxAbilityDistance))), (AABB)user.m_20191_().m_82400_(32.0), e -> e instanceof LivingEntity && e != user);
            if (hitResult != null) {
                Entity target = hitResult.m_82443_();
                Vec3 horizontalLookVec = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_).m_82541_().m_82490_(teleportDistance);
                Vec3 teleportPos = user.m_20182_().m_82549_(horizontalLookVec);
                if (world.m_8055_(BlockPos.m_274446_((Position)teleportPos)).m_60812_((BlockGetter)world, BlockPos.m_274446_((Position)teleportPos)).m_83281_()) {
                    target.m_6021_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
                    world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_SCIFI_ATTACK_01.get(), user.m_5720_(), 0.3f, 1.0f);
                    user.m_36335_().m_41524_((Item)((SoulPyreSwordItem)this), cooldown);
                } else {
                    user.m_36335_().m_41524_((Item)((SoulPyreSwordItem)this), 5);
                }
            } else {
                user.m_36335_().m_41524_((Item)((SoulPyreSwordItem)this), 5);
            }
        }
        cir.setReturnValue((Object)super.m_7203_(world, user, hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext, CallbackInfo ci) {
        if (!Config.enableSoulPyreChanges) {
            return;
        }
        ci.cancel();
        int witherDuration = Config.soulPyreWitherDuration;
        int witherLevel = Config.soulPyreWitherLevel;
        double maxAbilityDistance = Config.soulPyreMaxAbilityDistance;
        int cooldown = Config.soulPyreCooldownTicks;
        float floatCooldown = (float)cooldown / 20.0f;
        String translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.solupyreitem", (Object[])new Object[]{witherLevel, witherDuration, maxAbilityDistance}).getString();
        for (String line : translatedText.split("\n")) {
            tooltip.add((Component)Component.m_237113_((String)line));
        }
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
        SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
    }
}

