/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.simplyswordsoverhaul.mixin;

import java.util.List;
import net.jrdemiurge.simplyswordsoverhaul.Config;
import net.jrdemiurge.simplyswordsoverhaul.scheduler.Scheduler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sweenus.simplyswords.api.SimplySwordsAPI;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.custom.EmberlashSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EmberlashSwordItem.class})
public abstract class MixinEmberlashSword
extends UniqueSwordItem {
    public MixinEmberlashSword(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Inject(method={"hurtEnemy"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyHurtEnemyMethod(ItemStack stack, LivingEntity target, LivingEntity attacker, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.enableEmberlashChanges) {
            return;
        }
        if (!attacker.m_9236_().m_5776_()) {
            int maxEffectLevel = Config.emberlashMaxSmoulderLevel - 2;
            float smoulderDamage = (float)Config.emberlashSmoulderDamageMultiplier;
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            DamageSource damageSource = world.m_269111_().m_269264_();
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                damageSource = attacker.m_269291_().m_269075_(player);
            }
            if (target.m_21023_((MobEffect)EffectRegistry.SMOULDERING.get())) {
                target.f_19802_ = 0;
                MobEffectInstance smoulderingEffect = target.m_21124_((MobEffect)EffectRegistry.SMOULDERING.get());
                if (smoulderingEffect != null) {
                    target.m_6469_(damageSource, smoulderDamage * (float)(smoulderingEffect.m_19564_() + 1));
                }
            }
            if (target.m_21023_((MobEffect)EffectRegistry.SMOULDERING.get())) {
                int effectLevel = target.m_21124_((MobEffect)EffectRegistry.SMOULDERING.get()).m_19564_();
                if (effectLevel > maxEffectLevel) {
                    effectLevel = maxEffectLevel;
                }
                target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.SMOULDERING.get(), 20 * (effectLevel + 3), 0, false, true));
                for (int i = 0; i <= effectLevel; ++i) {
                    target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.SMOULDERING.get(), 20 * (effectLevel - i + 2), i + 1, false, true));
                }
            } else {
                target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.SMOULDERING.get(), 40, 0, false, true));
            }
        }
        cir.setReturnValue((Object)super.m_7579_(stack, target, attacker));
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyUseMethod(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!Config.enableEmberlashChanges) {
            return;
        }
        if (!user.m_9236_().m_5776_()) {
            double angleY;
            boolean isOffHandItemNotOnCooldown;
            int cooldown = Config.emberlashCooldownTicks;
            float healPercentage = (float)Config.emberlashHealPercentage / 100.0f;
            double scale = (double)Config.emberlashDashDistance / 3.0;
            ItemStack mainHandItem = user.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offHandItem = user.m_21120_(InteractionHand.OFF_HAND);
            boolean hasTwoSwords = mainHandItem.m_150930_((Item)ItemsRegistry.EMBERLASH.get()) && offHandItem.m_150930_((Item)ItemsRegistry.EMBERLASH.get());
            boolean isFirstUse = !user.getPersistentData().m_128471_("EmberlashFirstDashUsed");
            boolean isMainHandUse = hand == InteractionHand.MAIN_HAND;
            boolean bl = isOffHandItemNotOnCooldown = !user.m_36335_().m_41519_(offHandItem.m_41720_());
            if (isMainHandUse && isOffHandItemNotOnCooldown) {
                user.m_36335_().m_41524_(offHandItem.m_41720_(), 4);
            }
            user.m_6674_(hand);
            world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.SPELL_FIRE.get(), user.m_5720_(), 0.5f, 1.0f);
            Vec3 look = user.m_20154_().m_82541_();
            if (user.m_6144_()) {
                look = look.m_82490_(-1.0);
            }
            if (Math.abs(angleY = Math.toDegrees(Math.asin(look.f_82480_))) <= 10.0 || Config.emberlashIgnoreDownwardAngleOnGround && user.m_20096_() && angleY < 0.0) {
                look = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82541_();
            }
            Vec3 dashVelocity = look.m_82490_(scale);
            user.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 10, 4, false, false));
            user.m_20256_(dashVelocity);
            ((ServerPlayer)user).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)user));
            Scheduler.schedule(() -> {
                user.m_20256_(dashVelocity);
                ((ServerPlayer)user).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)user));
            }, 2, 0);
            Scheduler.schedule(() -> {
                user.m_20256_(Vec3.f_82478_);
                ((ServerPlayer)user).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)user));
            }, 4, 0);
            boolean[] shouldDisableGravity = new boolean[]{false};
            Scheduler.schedule(() -> {
                if (!user.m_20096_()) {
                    user.m_20242_(true);
                    shouldDisableGravity[0] = true;
                    user.f_19864_ = true;
                }
            }, 4, 0);
            Scheduler.schedule(() -> {
                if (shouldDisableGravity[0]) {
                    user.m_20242_(false);
                    user.f_19864_ = true;
                }
            }, 10, 0);
            if (isFirstUse) {
                user.m_5634_(user.m_21233_() * healPercentage);
            }
            if (hasTwoSwords && isFirstUse) {
                user.m_36335_().m_41524_((Item)((EmberlashSwordItem)this), 8);
                user.getPersistentData().m_128379_("EmberlashFirstDashUsed", true);
            } else {
                user.m_36335_().m_41524_((Item)((EmberlashSwordItem)this), cooldown);
                user.getPersistentData().m_128379_("EmberlashFirstDashUsed", false);
            }
        }
        cir.setReturnValue((Object)super.m_7203_(world, user, hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext, CallbackInfo ci) {
        if (!Config.enableEmberlashChanges) {
            return;
        }
        ci.cancel();
        int cooldown = Config.emberlashCooldownTicks;
        float floatCooldown = (float)cooldown / 20.0f;
        int healPercentage = Config.emberlashHealPercentage;
        double distance = Config.emberlashDashDistance;
        float smoulderDamage = (float)Config.emberlashSmoulderDamageMultiplier;
        if (Screen.m_96639_()) {
            String translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.emberlashsworditem_1").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.emberlashsworditem_2", (Object[])new Object[]{distance, healPercentage}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
            SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
        } else if (Screen.m_96638_()) {
            String translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.emberlashsworditem_1").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.emberlashsworditem_shift_1", (Object[])new Object[]{Float.valueOf(smoulderDamage)}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line).m_130940_(ChatFormatting.GRAY));
            }
            translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.emberlashsworditem_2", (Object[])new Object[]{distance, healPercentage}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.emberlashsworditem_shift_2").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line).m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
        } else {
            String translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.emberlashsworditem_1").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.emberlashsworditem_2", (Object[])new Object[]{distance, healPercentage}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
            SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
            if (!tooltip.get(tooltip.size() - 1).getString().equals(Component.m_237115_((String)"item.simplyswords.common.showtooltip").getString())) {
                tooltip.add((Component)Component.m_237113_((String)""));
            }
            tooltip.add((Component)Component.m_237115_((String)"tooltip.simply_swords_overhaul.shift"));
        }
    }
}

