/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.SliceShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.creativecore.common.util.unsafe.CreativeHackery;
import team.creative.creativecore.mixin.VoxelShapeAccessor;

public class BoxesVoxelShape
extends SliceShape {
    public static final DiscreteVoxelShape DISCRETE_SHAPE = new DiscreteVoxelShape(1, 1, 1){

        public boolean m_6696_(int x, int y, int z) {
            return true;
        }

        public void m_142703_(int x, int y, int z) {
            throw new UnsupportedOperationException();
        }

        public int m_6538_(Direction.Axis axis) {
            return 0;
        }

        public int m_6536_(Direction.Axis axis) {
            return 1;
        }

        public boolean m_6224_() {
            return false;
        }
    };
    public List<ABB> boxes;

    public static BoxesVoxelShape create(List<ABB> boxes) {
        BoxesVoxelShape shape = CreativeHackery.allocateInstance(BoxesVoxelShape.class);
        shape.boxes = boxes;
        ((VoxelShapeAccessor)((Object)shape)).setShape(DISCRETE_SHAPE);
        return shape;
    }

    public static BoxesVoxelShape createVanilla(List<AABB> boxes) {
        ArrayList<ABB> converted = new ArrayList<ABB>(boxes.size());
        for (AABB bb : boxes) {
            converted.add(new ABB(bb));
        }
        return BoxesVoxelShape.create(converted);
    }

    public static BoxesVoxelShape create(ABB box) {
        return BoxesVoxelShape.create(new SingletonList<ABB>(box));
    }

    protected BoxesVoxelShape() {
        super(null, null, 0);
    }

    public VoxelShape m_83216_(double x, double y, double z) {
        ArrayList<ABB> boxes = new ArrayList<ABB>();
        for (ABB bb : this.boxes) {
            boxes.add(bb.moveCopy(x, y, z));
        }
        return BoxesVoxelShape.create(boxes);
    }

    protected DoubleList m_7700_(Direction.Axis axis) {
        DoubleArrayList list = new DoubleArrayList(this.boxes.size() * 2);
        for (ABB bb : this.boxes) {
            list.add(bb.min(axis));
            list.add(bb.max(axis));
        }
        list.sort(DoubleComparators.NATURAL_COMPARATOR);
        return list;
    }

    protected double m_83256_(Direction.Axis axis, int index) {
        throw new UnsupportedOperationException();
    }

    public double m_83288_(Direction.Axis axis) {
        double min = Double.POSITIVE_INFINITY;
        for (ABB bb : this.boxes) {
            min = Math.min(min, bb.min(axis));
        }
        return min;
    }

    public double m_83297_(Direction.Axis axis) {
        double max = Double.NEGATIVE_INFINITY;
        for (ABB bb : this.boxes) {
            max = Math.max(max, bb.max(axis));
        }
        return max;
    }

    public void m_83224_(Shapes.DoubleLineConsumer consumer) {
        for (ABB bb : this.boxes) {
            for (BoxFace face : BoxFace.values()) {
                this.forAllEdgesCorner(bb, face.corners[0], face.corners[1], consumer);
                this.forAllEdgesCorner(bb, face.corners[1], face.corners[2], consumer);
                this.forAllEdgesCorner(bb, face.corners[2], face.corners[3], consumer);
                this.forAllEdgesCorner(bb, face.corners[3], face.corners[0], consumer);
            }
        }
    }

    private void forAllEdgesCorner(ABB bb, BoxCorner corner1, BoxCorner corner2, Shapes.DoubleLineConsumer consumer) {
        consumer.m_83161_(bb.cornerX(corner1), bb.cornerY(corner1), bb.cornerZ(corner1), bb.cornerX(corner2), bb.cornerY(corner2), bb.cornerZ(corner2));
    }

    public void m_83286_(Shapes.DoubleLineConsumer consumer) {
        for (ABB bb : this.boxes) {
            consumer.m_83161_(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
        }
    }

    public List<AABB> m_83299_() {
        ArrayList<AABB> bbs = new ArrayList<AABB>(this.boxes.size());
        for (ABB bb : this.boxes) {
            bbs.add(bb.toVanilla());
        }
        return bbs;
    }

    public double m_166078_(Direction.Axis axis, double one, double two) {
        Axis axisOne = Axis.X;
        Axis axisTwo = Axis.Z;
        double min = Double.POSITIVE_INFINITY;
        for (ABB bb : this.boxes) {
            if (!bb.intersectsWithAxis(axisOne, axisTwo, one, two)) continue;
            min = Math.min(min, bb.min(axis));
        }
        return min;
    }

    public double m_83290_(Direction.Axis axis, double one, double two) {
        Axis axisOne = Axis.X;
        Axis axisTwo = Axis.Z;
        double max = Double.NEGATIVE_INFINITY;
        for (ABB bb : this.boxes) {
            if (!bb.intersectsWithAxis(axisOne, axisTwo, one, two)) continue;
            max = Math.max(max, bb.max(axis));
        }
        return max;
    }

    protected int m_6595_(Direction.Axis axis, double value) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public BlockHitResult m_83220_(Vec3 pos, Vec3 look, BlockPos block) {
        return ABB.clip(this.boxes, pos, look, block);
    }

    public Optional<Vec3> m_166067_(Vec3 vec) {
        Vec3 avec3 = null;
        for (ABB bb : this.boxes) {
            double d0 = Mth.m_14008_((double)vec.m_7096_(), (double)bb.minX, (double)bb.maxX);
            double d1 = Mth.m_14008_((double)vec.m_7098_(), (double)bb.minY, (double)bb.maxY);
            double d2 = Mth.m_14008_((double)vec.m_7094_(), (double)bb.minZ, (double)bb.maxZ);
            if (avec3 != null && !(vec.m_82531_(d0, d1, d2) < vec.m_82557_(avec3))) continue;
            avec3 = new Vec3(d0, d1, d2);
        }
        return Optional.of(avec3);
    }

    public VoxelShape m_83263_(Direction direction) {
        return this;
    }

    public boolean m_83281_() {
        return this.boxes.isEmpty();
    }

    public VoxelShape m_83296_() {
        return this;
    }

    public boolean intersectsWith(AABB bb) {
        for (ABB abb : this.boxes) {
            if (!abb.intersectsPrecise(bb)) continue;
            return true;
        }
        return false;
    }

    public boolean onlyKeepIntersecting(AABB bb) {
        this.boxes.removeIf(x -> x.intersectsPrecise(bb));
        return !this.boxes.isEmpty();
    }

    public double m_83259_(Direction.Axis axis, AABB other, double distance) {
        if (this.m_83281_()) {
            return distance;
        }
        if (Math.abs(distance) < 1.0E-7) {
            return 0.0;
        }
        Axis ltAxis = Axis.get(axis);
        Axis one = ltAxis.one();
        Axis two = ltAxis.two();
        for (ABB bb : this.boxes) {
            if (distance > 0.0) {
                distance = Math.min(distance, bb.calculateAxisOffset(ltAxis, one, two, other, distance));
                continue;
            }
            distance = Math.max(distance, bb.calculateAxisOffset(ltAxis, one, two, other, distance));
        }
        return distance;
    }

    protected double m_83245_(AxisCycle cycle, AABB other, double distance) {
        throw new UnsupportedOperationException();
    }

    public AABB m_83215_() {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (ABB bb : this.boxes) {
            minX = Math.min(minX, bb.minX);
            minY = Math.min(minY, bb.minY);
            minZ = Math.min(minZ, bb.minZ);
            maxX = Math.max(maxX, bb.maxX);
            maxY = Math.max(maxY, bb.maxY);
            maxZ = Math.max(maxZ, bb.maxZ);
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public String toString() {
        return "AABBListVoxelShape[" + this.boxes + "]";
    }
}

