/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.biomeremapper.impl.mixin;

import com.terraformersmc.terraform.biomeremapper.impl.BiomeRemapper;
import com.terraformersmc.terraform.biomeremapper.impl.fix.BiomeIdFixData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.fabricmc.fabric.impl.registry.sync.RegistryMapSerializer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelStorageSource.LevelStorageAccess.class})
public class MixinLevelStorageSession {
    @Shadow
    @Final
    LevelStorageSource.LevelDirectory f_230867_;

    @Unique
    private boolean terraformBiomeRemapper$readIdMapFile(File file) throws IOException {
        BiomeRemapper.LOGGER.debug("Reading registry data from " + file.toString());
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            CompoundTag nbt = NbtIo.m_128939_((InputStream)fileInputStream);
            fileInputStream.close();
            if (nbt != null) {
                BiomeIdFixData.applyFabricDynamicRegistryMap(RegistryMapSerializer.fromNbt((CompoundTag)nbt));
                return true;
            }
        }
        return false;
    }

    @Inject(method={"readLevelProperties"}, at={@At(value="HEAD")})
    public void terraformBiomeRemapper$readWorldProperties(CallbackInfoReturnable<WorldData> callbackInfo) {
        try {
            if (this.terraformBiomeRemapper$readIdMapFile(new File(new File(this.f_230867_.f_230850_().toFile(), "data"), "fabricDynamicRegistry.dat"))) {
                BiomeRemapper.LOGGER.info("[Registry Sync Fix] Loaded registry data");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            BiomeRemapper.LOGGER.warn("[Registry Sync Fix] Reading registry file failed!", (Throwable)e);
        }
    }
}

