/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.biomeremapper.impl;

import com.google.common.collect.ImmutableMap;
import com.terraformersmc.terraform.biomeremapper.api.BiomeRemapperApi;
import com.terraformersmc.terraform.biomeremapper.impl.BiomeRemapper;
import java.util.Hashtable;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class BiomeRemappings {
    public static final Hashtable<String, RemappingRecord> BIOME_REMAPPING_REGISTRY = new Hashtable(8);

    public static void invokeEndpoints() {
        FabricLoader.getInstance().getEntrypointContainers("terraform-biome-remapper", BiomeRemapperApi.class).forEach(entrypoint -> {
            ModMetadata metadata = entrypoint.getProvider().getMetadata();
            String modId = metadata.getId();
            try {
                ((BiomeRemapperApi)entrypoint.getEntrypoint()).init();
            }
            catch (Throwable e) {
                BiomeRemapper.LOGGER.error("Mod {} provides a broken implementation of BiomeRemapperApi", (Object)modId, (Object)e);
            }
        });
    }

    public static void register(String modId, int dataVersion, ImmutableMap<String, String> remapping) {
        String key = dataVersion + "_" + modId;
        if (BIOME_REMAPPING_REGISTRY.containsKey(key)) {
            BiomeRemapper.LOGGER.debug("Ignored duplicate remapping: " + key);
        } else {
            BiomeRemapper.LOGGER.debug("Added remapping: " + key);
            BIOME_REMAPPING_REGISTRY.put(key, new RemappingRecord(modId, dataVersion, remapping));
        }
    }

    public record RemappingRecord(String modId, int dataVersion, ImmutableMap<String, String> remapping) {
    }
}

