/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.impactful.mixin.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nameless.impactful.client.CameraEngine;
import com.nameless.impactful.client.IRenderItemBase;
import com.nameless.impactful.client.RadialBlurEngine;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;

@Mixin(value={RenderItemBase.class})
public class RenderItemBaseMixin
implements IRenderItemBase {
    private CameraEngine.ShakeEntry shakeEntry;
    private RadialBlurEngine.RadialBlur blurEntry;

    @Inject(method={"<init>(Lcom/google/gson/JsonElement;)V"}, at={@At(value="TAIL")}, cancellable=false, remap=false)
    private void onRenderItemBase(JsonElement jsonElement, CallbackInfo ci) {
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        this.shakeEntry = jsonObj.has("shake_entry") ? this.deserializeShakeEntry(jsonObj) : null;
        this.blurEntry = jsonObj.has("blur_entry") ? this.deserializeRadialBlur(jsonObj) : null;
    }

    private CameraEngine.ShakeEntry deserializeShakeEntry(JsonObject jsonObj) {
        JsonObject object = jsonObj.getAsJsonObject("shake_entry");
        double strength = GsonHelper.m_144784_((JsonObject)object, (String)"strength");
        int duration = GsonHelper.m_13927_((JsonObject)object, (String)"duration");
        int decay_time = object.has("decay_time") ? GsonHelper.m_13927_((JsonObject)object, (String)"decay_time") : Mth.m_14107_((double)(0.9 * (double)duration));
        return new CameraEngine.ShakeEntry(strength, duration, decay_time);
    }

    private RadialBlurEngine.RadialBlur deserializeRadialBlur(JsonObject jsonObj) {
        JsonObject object = jsonObj.getAsJsonObject("blur_entry");
        float strength = GsonHelper.m_13915_((JsonObject)object, (String)"strength");
        int duration = GsonHelper.m_13927_((JsonObject)object, (String)"duration");
        int decay_time = object.has("decay_time") ? GsonHelper.m_13927_((JsonObject)object, (String)"decay_time") : Mth.m_14107_((double)(0.9 * (double)duration));
        return new RadialBlurEngine.RadialBlur(duration, strength, decay_time);
    }

    @Override
    public CameraEngine.ShakeEntry getShakeEntry() {
        return this.shakeEntry;
    }

    @Override
    public RadialBlurEngine.RadialBlur getRadialBlur() {
        return this.blurEntry;
    }
}

