/*
 * Decompiled with CFR 0.152.
 */
package toni.foolproof;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import toni.foolproof.ClientEvents;
import toni.foolproof.features.VoidGraveReminder;
import toni.foolproof.foundation.FoolproofPersistentData;
import toni.foolproof.foundation.config.AllConfigs;

@Mod(value="foolproof")
public class Foolproof {
    public static final String MODNAME = "Foolproof";
    public static final String ID = "foolproof";
    public static final Logger LOGGER = LogManager.getLogger((String)"Foolproof");
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static final AtomicLong serverStartTime = new AtomicLong(0L);
    public static FoolproofPersistentData DATA;

    public Foolproof() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        AllConfigs.register((type, spec) -> ModLoadingContext.get().registerConfig(type, (IConfigSpec)spec));
    }

    public static boolean hasSeenWarning(String warning) {
        return Foolproof.DATA.seenWarnings.contains(warning);
    }

    public void onInitialize() {
        VoidGraveReminder.init();
    }

    public void onInitializeClient() {
        DATA = FoolproofPersistentData.load();
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarted);
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            if (DATA != null) {
                DATA.save();
            }
        });
        ClientEvents.init();
    }

    private void onServerStarted(MinecraftServer server) {
        serverStartTime.set(System.currentTimeMillis());
        scheduler.schedule(() -> System.out.println("[SERVER] The server is fully started and ready to join!"), 5L, TimeUnit.SECONDS);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        this.onInitialize();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        this.onInitializeClient();
    }
}

