/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome;

import com.mojang.datafixers.util.Pair;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.config.BiolithState;
import com.terraformersmc.terraform.noise.OpenSimplexNoise2;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7871;

public class EndBiomePlacement
extends DimensionBiomePlacement {
    private final class_6544.class_4762 noiseSmallEndIslands = new class_6544.class_4762(DEFAULT_PARAMETER, DEFAULT_PARAMETER, DEFAULT_PARAMETER, class_6544.class_6546.method_38121((float)-1.0f, (float)-0.21875f), DEFAULT_PARAMETER, DEFAULT_PARAMETER, 0L);
    private final class_6544.class_4762 noiseEndBarrens = new class_6544.class_4762(DEFAULT_PARAMETER, DEFAULT_PARAMETER, DEFAULT_PARAMETER, class_6544.class_6546.method_38121((float)-0.21875f, (float)-0.0625f), DEFAULT_PARAMETER, DEFAULT_PARAMETER, 0L);
    private final class_6544.class_4762 noiseEndMidlands = new class_6544.class_4762(DEFAULT_PARAMETER, DEFAULT_PARAMETER, DEFAULT_PARAMETER, class_6544.class_6546.method_38121((float)-0.0625f, (float)0.25f), DEFAULT_PARAMETER, DEFAULT_PARAMETER, 0L);
    private final class_6544.class_4762 noiseEndHighlands = new class_6544.class_4762(DEFAULT_PARAMETER, DEFAULT_PARAMETER, DEFAULT_PARAMETER, class_6544.class_6546.method_38121((float)0.25f, (float)1.0f), DEFAULT_PARAMETER, DEFAULT_PARAMETER, 0L);
    public class_6544.class_6548.class_6549<class_6880<class_1959>> nodeSmallEndIslands;
    public class_6544.class_6548.class_6549<class_6880<class_1959>> nodeEndBarrens;
    public class_6544.class_6548.class_6549<class_6880<class_1959>> nodeEndMidlands;
    public class_6544.class_6548.class_6549<class_6880<class_1959>> nodeEndHighlands;
    public OpenSimplexNoise2 humidityNoise;
    public OpenSimplexNoise2 temperatureNoise;
    public OpenSimplexNoise2 weirdnessNoise;

    @Override
    protected void serverReplaced(BiolithState state, long seed) {
        super.serverReplaced(state, seed);
        class_7871<class_1959> biomeEntryGetter = BiomeCoordinator.getBiomeLookupOrThrow();
        this.nodeSmallEndIslands = new class_6544.class_6548.class_6549(this.noiseSmallEndIslands, (Object)biomeEntryGetter.method_46747(class_1972.field_9457));
        this.nodeEndBarrens = new class_6544.class_6548.class_6549(this.noiseEndBarrens, (Object)biomeEntryGetter.method_46747(class_1972.field_9465));
        this.nodeEndMidlands = new class_6544.class_6548.class_6549(this.noiseEndMidlands, (Object)biomeEntryGetter.method_46747(class_1972.field_9447));
        this.nodeEndHighlands = new class_6544.class_6548.class_6549(this.noiseEndHighlands, (Object)biomeEntryGetter.method_46747(class_1972.field_9442));
        this.humidityNoise = new OpenSimplexNoise2((long)this.seedlets[7]);
        this.temperatureNoise = new OpenSimplexNoise2((long)this.seedlets[5]);
        this.weirdnessNoise = new OpenSimplexNoise2((long)this.seedlets[3]);
    }

    @Override
    protected double getLocalNoise(int x, int y, int z) {
        double localNoise = this.replacementNoise.sample((double)(x + this.seedlets[0]) / 256.0, (double)(z + this.seedlets[1]) / 256.0);
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[2]) / 64.0, (double)(z + this.seedlets[3]) / 64.0) / 4.0;
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[4]) / 16.0, (double)(z + this.seedlets[5]) / 16.0) / 16.0;
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[6]) / 4.0, (double)(z + this.seedlets[7]) / 4.0) / 32.0;
        localNoise = this.normalize(localNoise / 1.3125);
        return localNoise;
    }

    @Override
    public void writeBiomeEntries(Consumer<Pair<class_6544.class_4762, class_6880<class_1959>>> parameters) {
        this.biomesInjected = true;
        class_7871<class_1959> biomeEntryGetter = BiomeCoordinator.getBiomeLookupOrThrow();
        this.placementRequests.forEach(pair -> parameters.accept(pair.mapSecond(arg_0 -> ((class_7871)biomeEntryGetter).method_46747(arg_0))));
        this.replacementRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.ReplacementRequest::biome).distinct().forEach(biome -> {
            if (!biome.equals(VANILLA_PLACEHOLDER)) {
                parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biomeEntryGetter.method_46747(biome)));
            }
        });
        this.subBiomeRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.SubBiomeRequest::biome).distinct().forEach(biome -> parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biomeEntryGetter.method_46747(biome))));
    }

    @Override
    public void writeBiomeParameters(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters) {
        this.biomesInjected = true;
        this.placementRequests.forEach(parameters);
        this.replacementRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.ReplacementRequest::biome).distinct().forEach(biome -> {
            if (!biome.equals(VANILLA_PLACEHOLDER)) {
                parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biome));
            }
        });
        this.subBiomeRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.SubBiomeRequest::biome).distinct().forEach(biome -> parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biome)));
    }
}

