/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome;

import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.biome.EndBiomePlacement;
import com.terraformersmc.biolith.impl.biome.NetherBiomePlacement;
import com.terraformersmc.biolith.impl.biome.OverworldBiomePlacement;
import com.terraformersmc.biolith.impl.config.BiolithState;
import com.terraformersmc.biolith.impl.surface.SurfaceRuleCollector;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_6686;
import net.minecraft.class_7134;
import net.minecraft.class_7225;
import net.minecraft.class_7659;
import net.minecraft.class_7780;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import terrablender.api.SurfaceRuleManager;

public class BiomeCoordinator {
    public static final DimensionBiomePlacement END = new EndBiomePlacement();
    public static final DimensionBiomePlacement NETHER = new NetherBiomePlacement();
    public static final DimensionBiomePlacement OVERWORLD = new OverworldBiomePlacement();
    private static boolean registeredWithTerrablender = false;
    private static BiolithState END_STATE;
    private static BiolithState NETHER_STATE;
    private static BiolithState OVERWORLD_STATE;
    private static boolean serverStarted;
    protected static class_5455.class_6890 registryManager;

    public static void setRegistryManager(class_7780<class_7659> combinedDynamicRegistries) {
        registryManager = combinedDynamicRegistries.method_45926();
    }

    @Nullable
    public static class_5455.class_6890 getRegistryManager() {
        return registryManager;
    }

    public static Optional<class_7225.class_7226<class_1959>> getBiomeLookup() {
        class_5455.class_6890 registryManager = BiomeCoordinator.getRegistryManager();
        if (registryManager == null) {
            return Optional.empty();
        }
        return registryManager.method_46759(class_7924.field_41236);
    }

    public static class_7871<class_1959> getBiomeLookupOrThrow() {
        return (class_7871)BiomeCoordinator.getBiomeLookup().orElseThrow();
    }

    public static void handleServerStarting(MinecraftServer server) {
        if (registryManager == null) {
            registryManager = server.method_46221().method_45926();
        }
        if (Biolith.COMPAT_TERRABLENDER) {
            BiomeCoordinator.registerWithTerrablender();
        }
        if (serverStarted) {
            Biolith.LOGGER.warn("Received notification of server start-up but it should already be running!  O.o");
        } else {
            serverStarted = true;
        }
    }

    public static void handleWorldStarting(class_3218 world) {
        if (!serverStarted) {
            Biolith.LOGGER.error("New world '{}' created when server is not running!", (Object)world.method_27983().method_29177());
        }
        if (class_7134.field_37668.equals(world.method_44013())) {
            END_STATE = new BiolithState(world, "end");
            END.serverReplaced(END_STATE, world.method_8412());
        } else if (class_7134.field_37667.equals(world.method_44013())) {
            NETHER_STATE = new BiolithState(world, "nether");
            NETHER.serverReplaced(NETHER_STATE, world.method_8412());
        } else if (class_7134.field_37666.equals(world.method_44013())) {
            OVERWORLD_STATE = new BiolithState(world, "overworld");
            OVERWORLD.serverReplaced(OVERWORLD_STATE, world.method_8412());
        } else {
            Biolith.LOGGER.info("Ignoring world '{}'; unknown dimension type: {}", (Object)world.method_27983().method_29177(), (Object)world.method_44013().method_29177());
        }
    }

    public static void handleServerStopped(MinecraftServer server) {
        serverStarted = false;
        registryManager = null;
        END_STATE = null;
        NETHER_STATE = null;
        OVERWORLD_STATE = null;
    }

    private static void registerWithTerrablender() {
        if (!registeredWithTerrablender) {
            Map.of(SurfaceRuleCollector.OVERWORLD, SurfaceRuleManager.RuleCategory.OVERWORLD, SurfaceRuleCollector.NETHER, SurfaceRuleManager.RuleCategory.NETHER).forEach((biolithRules, terrablenderRuleCategory) -> {
                if (biolithRules.getRuleCount() > 0) {
                    for (class_2960 ruleOwner : biolithRules.getRuleOwners()) {
                        if (biolithRules.getRuleCount(ruleOwner) <= 0) continue;
                        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)terrablenderRuleCategory, (String)ruleOwner.method_12836(), (class_6686.class_6708)biolithRules.get(ruleOwner));
                    }
                }
            });
            registeredWithTerrablender = true;
        }
    }

    static {
        serverStarted = false;
    }
}

