/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.api.biome;

import com.terraformersmc.biolith.impl.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.biome.SubBiomeMatcherImpl;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2fc;

public abstract class SubBiomeMatcher {
    public static final Criterion NEAR_BORDER = Criterion.ofMax(CriterionTargets.EDGE, CriterionTypes.RATIO, 0.2f);
    public static final Criterion NEAR_INTERIOR = Criterion.ofMax(CriterionTargets.CENTER, CriterionTypes.RATIO, 0.2f);
    public static final SubBiomeMatcher BEACHSIDE = SubBiomeMatcher.of(NEAR_BORDER, Criterion.ofBiome(CriterionTargets.NEIGHBOR, (class_6862<class_1959>)class_6908.field_36510, false));
    public static final SubBiomeMatcher OCEANSIDE = SubBiomeMatcher.of(NEAR_BORDER, Criterion.ofBiome(CriterionTargets.NEIGHBOR, (class_6862<class_1959>)class_6908.field_36509, false));
    public static final SubBiomeMatcher RIVERSIDE = SubBiomeMatcher.of(NEAR_BORDER, Criterion.ofBiome(CriterionTargets.NEIGHBOR, (class_6862<class_1959>)class_6908.field_36511, false));

    public static SubBiomeMatcher of(Criterion ... criteria) {
        return SubBiomeMatcherImpl.of(criteria);
    }

    public abstract SubBiomeMatcher addCriterion(Criterion var1);

    public abstract void sort();

    public abstract boolean matches(BiolithFittestNodes<class_6880<class_1959>> var1, DimensionBiomePlacement var2, class_6544.class_6553 var3, @Nullable Vector2fc var4, float var5);

    public static interface Criterion {
        public CriterionTargets target();

        public CriterionTypes type();

        public static Criterion ofRange(CriterionTargets target, CriterionTypes type, float min, float max, boolean invert) {
            return new SubBiomeMatcherImpl.Criterion(target, type, null, null, null, min, max, invert);
        }

        public static Criterion ofMin(CriterionTargets target, CriterionTypes type, float min) {
            return new SubBiomeMatcherImpl.Criterion(target, type, null, null, null, min, Float.MAX_VALUE, false);
        }

        public static Criterion ofMax(CriterionTargets target, CriterionTypes type, float max) {
            return new SubBiomeMatcherImpl.Criterion(target, type, null, null, null, Float.MIN_VALUE, max, false);
        }

        public static Criterion ofBiome(CriterionTargets target, class_5321<class_1959> biome, boolean invert) {
            return new SubBiomeMatcherImpl.Criterion(target, CriterionTypes.BIOME, biome, null, null, Float.MIN_VALUE, Float.MAX_VALUE, invert);
        }

        public static Criterion ofBiome(CriterionTargets target, class_6862<class_1959> biomeTag, boolean invert) {
            return new SubBiomeMatcherImpl.Criterion(target, CriterionTypes.BIOME, null, null, biomeTag, Float.MIN_VALUE, Float.MAX_VALUE, invert);
        }

        public static Criterion ofAlternate(CriterionTargets target, class_5321<class_1959> biome, class_5321<class_1959> alternateBiome, boolean invert) {
            return new SubBiomeMatcherImpl.Criterion(target, CriterionTypes.BIOME, biome, alternateBiome, null, Float.MIN_VALUE, Float.MAX_VALUE, invert);
        }

        public boolean checkBiome(CriterionTargets var1, BiolithFittestNodes<class_6880<class_1959>> var2, DimensionBiomePlacement var3, float var4);

        public boolean checkRange(CriterionTypes var1, class_6544.class_6546 var2, long var3);

        public boolean checkReplacement(CriterionTargets var1, BiolithFittestNodes<class_6880<class_1959>> var2, class_6544.class_6553 var3, @Nullable Vector2fc var4, float var5);
    }

    public static enum CriterionTargets {
        CONTINENTALNESS,
        DEPTH,
        EROSION,
        HUMIDITY,
        TEMPERATURE,
        WEIRDNESS,
        ALTERNATE,
        ORIGINAL,
        NEIGHBOR,
        PEAKS_VALLEYS,
        CENTER,
        EDGE;

    }

    public static enum CriterionTypes {
        BIOME,
        DISTANCE,
        RATIO,
        VALUE;

    }

    public static enum ParameterListIndex {
        TEMPERATURE,
        HUMIDITY,
        CONTINENTALNESS,
        EROSION,
        DEPTH,
        WEIRDNESS,
        OFFSET;

    }
}

