/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget.container;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.navigation.NavigationDirection;
import dev.lambdaurora.spruceui.navigation.NavigationUtils;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceParentWidget;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSpruceParentWidget<E extends SpruceWidget>
extends AbstractSpruceWidget
implements SpruceParentWidget<E> {
    private final Class<E> childClass;
    @Nullable
    private E focused;

    public AbstractSpruceParentWidget(Position position, Class<E> childClass) {
        super(position);
        this.childClass = childClass;
    }

    @Override
    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (!focused) {
            this.setFocused(null);
        }
    }

    @Override
    @Nullable
    public E getFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(@Nullable E focused) {
        if (this.focused == focused) {
            return;
        }
        if (this.focused != null) {
            this.focused.method_25365(false);
        }
        if (focused == null) {
            this.focused = null;
        } else if (this.childClass.isInstance(focused)) {
            this.focused = focused;
            this.focused.method_25365(true);
        }
    }

    protected void setOwnerShip(E child) {
        child.getPosition().setAnchor(this);
    }

    @Override
    public boolean onNavigation(NavigationDirection direction, boolean tab) {
        if (this.requiresCursor()) {
            return false;
        }
        boolean result = NavigationUtils.tryNavigate(direction, tab, this.children(), this.focused, this::setFocused, false);
        if (result) {
            this.method_25365(true);
        }
        return result;
    }

    @Override
    protected boolean onMouseClick(double mouseX, double mouseY, int button) {
        SpruceWidget element;
        Iterator it = this.iterator();
        do {
            if (it.hasNext()) continue;
            return false;
        } while (!(element = (SpruceWidget)it.next()).method_25402(mouseX, mouseY, button));
        this.setFocused(element);
        if (button == 0) {
            this.setDragging(true);
        }
        return true;
    }

    @Override
    protected boolean onMouseRelease(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        return this.hoveredElement(mouseX, mouseY).filter(element -> element.method_25406(mouseX, mouseY, button)).isPresent();
    }

    @Override
    protected boolean onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    protected boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        return this.hoveredElement(mouseX, mouseY).filter(element -> element.method_25401(mouseX, mouseY, amount)).isPresent();
    }

    @Override
    protected boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        return this.getFocused() != null && this.getFocused().method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    protected boolean onKeyRelease(int keyCode, int scanCode, int modifiers) {
        return this.getFocused() != null && this.getFocused().method_16803(keyCode, scanCode, modifiers);
    }

    @Override
    protected boolean onCharTyped(char chr, int keyCode) {
        return this.getFocused() != null && this.getFocused().method_25400(chr, keyCode);
    }
}

