/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.api;

import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.ClientConfig;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.entity.TreeEntity;
import me.pandamods.fallingtrees.exceptions.TreeException;
import me.pandamods.fallingtrees.registry.EntityRegistry;
import me.pandamods.fallingtrees.registry.TreeRegistry;
import me.pandamods.pandalib.utils.RunUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class TreeHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<UUID, TreeSpeed> TREE_SPEED_CACHES = new ConcurrentHashMap<UUID, TreeSpeed>();

    public static boolean destroyTree(Level level, BlockPos blockPos, Player player) {
        if (level.m_5776_()) {
            return false;
        }
        BlockState blockState = level.m_8055_(blockPos);
        TreeType tree = TreeRegistry.getTree(blockState);
        if (tree == null) {
            return false;
        }
        TreeData data = TreeHandler.tryGatherTreeData(tree, blockPos, level, player, false);
        if (data == null) {
            return false;
        }
        List<BlockPos> blocks = data.blocks();
        TreeEntity entity = new TreeEntity((EntityType)EntityRegistry.TREE.get(), level);
        entity.m_6034_((double)blockPos.m_123341_() + 0.5, blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
        entity.setData((Entity)player, tree, blockPos, blocks, data.drops());
        player.m_36399_(FallingTreesConfig.getCommonConfig().disableExtraFoodExhaustion ? 1.0f : data.foodExhaustionModifier().getExhaustion(0.005f));
        if (player.m_21205_().m_41763_()) {
            player.m_21205_().m_41622_(FallingTreesConfig.getCommonConfig().disableExtraToolDamage ? 1 : data.toolDamage(), (LivingEntity)player, player1 -> player1.m_21166_(EquipmentSlot.MAINHAND));
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)player.m_21205_().m_41720_()));
        data.awardedStats().forEach(awardedStat -> player.m_6278_(awardedStat.stat(), awardedStat.amount()));
        HashMap<BlockPos, BlockState> blockStates = new HashMap<BlockPos, BlockState>();
        BlockState air = Blocks.f_50016_.m_49966_();
        for (BlockPos pos2 : blocks) {
            BlockState oldState2 = level.m_8055_(pos2);
            level.m_7731_(pos2, air, 16);
            level.m_6550_(pos2, oldState2, level.m_8055_(pos2));
            blockStates.put(pos2, oldState2);
        }
        blockStates.forEach((pos, oldState) -> {
            BlockState newState = level.m_8055_(pos);
            level.m_7260_(pos, oldState, newState, 3);
            level.m_7260_(pos, oldState, newState, 3);
            level.m_6289_(pos, newState.m_60734_());
            newState.m_60758_((LevelAccessor)level, pos, 511);
            oldState.m_60701_((LevelAccessor)level, pos, 511);
            oldState.m_60758_((LevelAccessor)level, pos, 511);
            level.m_6559_(pos, oldState, newState);
        });
        level.m_7967_((Entity)entity);
        return true;
    }

    public static TreeData tryGatherTreeData(TreeType treeType, BlockPos blockPos, Level level, Player player, boolean ignoreExceptions) {
        block4: {
            try {
                return treeType.gatherTreeData(blockPos, level, player);
            }
            catch (TreeException e) {
                if (!ignoreExceptions) {
                    LOGGER.warn(e.getMessage());
                }
            }
            catch (Exception e) {
                if (ignoreExceptions) break block4;
                LOGGER.error("An error occurred when trying to gather tree data", (Throwable)e);
                player.m_5661_((Component)Component.m_237113_((String)("Error: " + String.valueOf(e))).m_130948_(Style.f_131099_.m_178520_(Color.red.getRGB())), false);
                player.m_5661_((Component)Component.m_237115_((String)"text.fallingtrees.tree_handler.exception.1").m_130948_(Style.f_131099_.m_178520_(Color.red.getRGB())), false);
                player.m_5661_((Component)Component.m_237115_((String)"text.fallingtrees.tree_handler.exception.2").m_130948_(Style.f_131099_.m_178520_(Color.red.getRGB())), false);
            }
        }
        return null;
    }

    public static boolean canPlayerChopTree(Player player) {
        ClientConfig clientConfig = FallingTreesConfig.getClientConfig(player);
        if (clientConfig == null) {
            RunUtil.runOnce((String)("falling_trees_player_client_config_missing_" + String.valueOf(player.m_20148_())), () -> LOGGER.warn("Couldn't find client config for player: {} [{}]", (Object)player.m_5446_().getString(), (Object)player.m_20148_()));
            return false;
        }
        boolean invertCrouchMining = clientConfig.invertCrouchMining;
        return FallingTreesConfig.getCommonConfig().disableCrouchMining || player.m_6047_() == invertCrouchMining;
    }

    public static Optional<Float> getMiningSpeed(Player player, BlockPos blockPos, float baseSpeed) {
        TreeSpeed treeSpeed = TREE_SPEED_CACHES.compute(player.m_20148_(), (uuid, speed) -> {
            if (speed == null || !speed.isValid(blockPos, baseSpeed)) {
                BlockState blockState = player.m_9236_().m_8055_(blockPos);
                TreeType tree = TreeRegistry.getTree(blockState);
                if (tree == null) {
                    return null;
                }
                TreeData data = TreeHandler.tryGatherTreeData(tree, blockPos, player.m_9236_(), player, true);
                if (data == null) {
                    return null;
                }
                return new TreeSpeed(baseSpeed, data.miningSpeedModifier().getMiningSpeed(baseSpeed), blockPos.m_7949_());
            }
            return speed;
        });
        return Optional.ofNullable(treeSpeed).map(TreeSpeed::getMiningSpeed);
    }

    public static final class TreeSpeed {
        private final float baseMiningSpeed;
        private final float miningSpeed;
        private final BlockPos blockPos;

        public TreeSpeed(float baseMiningSpeed, float miningSpeed, BlockPos blockPos) {
            this.baseMiningSpeed = baseMiningSpeed;
            this.miningSpeed = miningSpeed;
            this.blockPos = blockPos;
        }

        public float getMiningSpeed() {
            return this.miningSpeed;
        }

        public boolean isValid(BlockPos blockPos, float baseSpeed) {
            return Objects.equals(this.blockPos, blockPos) && this.baseMiningSpeed == baseSpeed;
        }
    }
}

