/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stat;
import net.minecraft.world.item.ItemStack;

public record TreeData(List<BlockPos> blocks, List<ItemStack> drops, List<AwardedStat> awardedStats, int toolDamage, MiningSpeedModifier miningSpeedModifier, FoodExhaustionModifier foodExhaustionModifier) {
    public static Builder builder() {
        return new Builder();
    }

    public static interface MiningSpeedModifier {
        public float getMiningSpeed(float var1);
    }

    public static interface FoodExhaustionModifier {
        public float getExhaustion(float var1);
    }

    public static class Builder {
        private final List<BlockPos> blocks = new ArrayList<BlockPos>();
        private final List<BlockPos> viewBlocks = Collections.unmodifiableList(this.blocks);
        private final List<ItemStack> drops = new ArrayList<ItemStack>();
        private final List<ItemStack> viewDrops = Collections.unmodifiableList(this.drops);
        private final Map<Stat<?>, Integer> awardedStats = new HashMap();
        private int toolDamage = 0;
        private MiningSpeedModifier miningSpeedModifier = originalMiningSpeed -> originalMiningSpeed;
        private FoodExhaustionModifier foodExhaustionModifier = originalExhaustion -> originalExhaustion;

        private Builder() {
        }

        public Builder addBlock(BlockPos blockPos) {
            this.blocks.add(blockPos);
            return this;
        }

        public Builder addBlocks(BlockPos blockPos, BlockPos ... otherBlocks) {
            this.blocks.add(blockPos);
            this.blocks.addAll(Arrays.asList(otherBlocks));
            return this;
        }

        public Builder addBlocks(Collection<BlockPos> blocks) {
            this.blocks.addAll(blocks);
            return this;
        }

        public Builder addDrop(ItemStack drop) {
            this.drops.add(drop);
            return this;
        }

        public Builder addDrops(ItemStack drop, ItemStack ... otherDrops) {
            this.drops.add(drop);
            this.drops.addAll(Arrays.asList(otherDrops));
            return this;
        }

        public Builder addDrops(Collection<ItemStack> drops) {
            this.drops.addAll(drops);
            return this;
        }

        public Builder addAwardedStat(Stat<?> stat) {
            return this.addAwardedStat(stat, 1);
        }

        public Builder addAwardedStat(Stat<?> stat, int amount) {
            this.awardedStats.compute(stat, (stat1, oldAmount) -> oldAmount == null ? amount : oldAmount + amount);
            return this;
        }

        public <T> Builder addAwardedStats(Collection<Stat<T>> stats) {
            stats.forEach(this::addAwardedStat);
            return this;
        }

        public Builder addAwardedStatsMap(Map<Stat<?>, Integer> stats) {
            this.awardedStats.putAll(stats);
            return this;
        }

        public Builder setToolDamage(int toolDamage) {
            this.toolDamage = toolDamage;
            return this;
        }

        public Builder setMiningSpeedModifier(MiningSpeedModifier miningSpeedModifier) {
            this.miningSpeedModifier = miningSpeedModifier;
            return this;
        }

        public Builder setFoodExhaustionModifier(FoodExhaustionModifier foodExhaustionModifier) {
            this.foodExhaustionModifier = foodExhaustionModifier;
            return this;
        }

        public TreeData build() {
            return new TreeData(this.viewBlocks, this.viewDrops, this.awardedStats.entrySet().stream().map(entry -> new AwardedStat((Stat)entry.getKey(), (Integer)entry.getValue())).toList(), this.toolDamage, this.miningSpeedModifier, this.foodExhaustionModifier);
        }
    }

    public record AwardedStat(Stat<?> stat, int amount) {
    }
}

