/*
 * Decompiled with CFR 0.152.
 */
package elocindev.customitemattributes.builder;

import com.google.common.collect.Multimap;
import elocindev.customitemattributes.CustomItemAttributes;
import elocindev.customitemattributes.api.GenericAttribute;
import elocindev.customitemattributes.api.ItemProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public class AttributeBuilderCallback {
    public static void register() {
        ModifyItemAttributeModifiersCallback.EVENT.register((stack, slot, builder) -> {
            for (ItemProperty item : CustomItemAttributes.CONFIG.items) {
                if (item.getItem() != stack.m_41720_()) continue;
                CompoundTag nbt = stack.m_41783_();
                if (nbt != null && (item.unbreakable || item.shouldForceUnbreakable())) {
                    nbt.m_128379_("Unbreakable", item.unbreakable);
                    stack.m_41739_(nbt);
                }
                for (String id : item.getSlotNames()) {
                    if (slot != EquipmentSlot.m_20747_((String)id)) continue;
                    AttributeBuilderCallback.applyModifiers(stack, item, item.attribute_overrides, (Multimap<Attribute, AttributeModifier>)builder);
                }
            }
        });
    }

    public static void applyModifiers(ItemStack stack, ItemProperty property, List<GenericAttribute<String, ?>> attributes, Multimap<Attribute, AttributeModifier> builder) {
        for (GenericAttribute<String, ?> generic_attribute : attributes) {
            try {
                Attribute attribute = generic_attribute.getAttribute();
                ArrayList<AttributeModifier> newModifiers = new ArrayList<AttributeModifier>();
                newModifiers.add(new AttributeModifier(UUID.nameUUIDFromBytes((stack.toString() + generic_attribute.toString()).getBytes()), "Custom Item Attributes Modifier", generic_attribute.getDouble(), generic_attribute.getOperation()));
                if (builder.containsValue((Object)attribute)) {
                    builder.replaceValues((Object)attribute, newModifiers);
                    continue;
                }
                builder.putAll((Object)attribute, newModifiers);
            }
            catch (Exception e) {
                CustomItemAttributes.LOGGER.error("Error adding attribute modifier: " + e.getMessage());
            }
        }
    }
}

