/*
 * Decompiled with CFR 0.152.
 */
package elocindev.customitemattributes.api;

import elocindev.customitemattributes.api.InvalidAttributeException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class GenericAttribute<A, V> {
    private A attribute;
    private V value;
    private String operation;

    public GenericAttribute(A attribute, V value, String operation) {
        this.attribute = attribute;
        this.value = value;
        this.operation = operation.toUpperCase() == "ADDITION" || operation.toUpperCase() == "MULTIPLY_BASE" || operation.toUpperCase() == "MULTIPLY_TOTAL" ? operation.toUpperCase() : "ADDITION";
    }

    public Attribute getAttribute() throws InvalidAttributeException {
        String attributeId;
        Attribute entAttribute;
        A a = this.attribute;
        if (a instanceof String && (entAttribute = (Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation(attributeId = (String)a))) != null) {
            return entAttribute;
        }
        throw new InvalidAttributeException("Attribute not found: " + String.valueOf(this.attribute));
    }

    public String getString() throws InvalidAttributeException {
        if (this.attribute instanceof String) {
            return (String)this.attribute;
        }
        throw new InvalidAttributeException("Invalid Type: " + String.valueOf(this.attribute) + " must be String");
    }

    public AttributeModifier.Operation getOperation() {
        switch (this.operation) {
            case "ADDITION": {
                return AttributeModifier.Operation.ADDITION;
            }
            case "MULTIPLY_BASE": {
                return AttributeModifier.Operation.MULTIPLY_BASE;
            }
            case "MULTIPLY_TOTAL": {
                return AttributeModifier.Operation.MULTIPLY_TOTAL;
            }
        }
        return AttributeModifier.Operation.ADDITION;
    }

    public double getDouble() throws InvalidAttributeException {
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        throw new InvalidAttributeException("Invalid Type: " + String.valueOf(this.value) + " must be Double");
    }

    public V getValue() {
        return this.value;
    }
}

