/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.cataclysm_dimension;

import com.github.L_Ender.cataclysm.init.ModItems;
import com.mojang.logging.LogUtils;
import com.p1nero.cataclysm_dimension.CataclysmDimensionModConfig;
import com.p1nero.cataclysm_dimension.worldgen.CataclysmDimensions;
import com.p1nero.cataclysm_dimension.worldgen.placements.CDPlacementTypes;
import com.p1nero.cataclysm_dimension.worldgen.portal.CDNetherTeleporter;
import com.p1nero.cataclysm_dimension.worldgen.portal.CDTeleporter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="cataclysm_dimension")
public class CataclysmDimensionMod {
    public static final String MOD_ID = "cataclysm_dimension";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static Map<Item, DimensionTeleportInfo> TELEPORT_MAP;
    public static final Map<ResourceLocation, Boolean> RESOURCE_KEY_BOOLEAN_MAP;
    public static final Map<ResourceLocation, Integer> RESOURCE_LOCATION_INTEGER_MAP;
    public static final int DELAY = 200;

    public CataclysmDimensionMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.addListener(this::onItemUse);
        MinecraftForge.EVENT_BUS.addListener(this::onToolTip);
        MinecraftForge.EVENT_BUS.addListener(this::onServerLevelTick);
        CataclysmDimensionModConfig.loadConfig();
        bus.addListener(this::onDatapackLoad);
        CDPlacementTypes.STRUCTURE_PLACEMENT_TYPES.register(bus);
    }

    private void initMap() {
        TELEPORT_MAP = Map.of((Item)ModItems.ABYSS_EYE.get(), new DimensionTeleportInfo(CataclysmDimensions.CATACLYSM_ABYSSAL_DEPTHS_LEVEL_KEY, new CDTeleporter(new BlockPos(0, 200, 0))), (Item)ModItems.MECH_EYE.get(), new DimensionTeleportInfo(CataclysmDimensions.CATACLYSM_FORGE_OF_AEONS_LEVEL_KEY, new CDTeleporter(new BlockPos(0, 150, 0))), (Item)ModItems.FLAME_EYE.get(), new DimensionTeleportInfo(CataclysmDimensions.CATACLYSM_INFERNOS_MAW_LEVEL_KEY, new CDNetherTeleporter(new BlockPos(0, 64, 0))), (Item)ModItems.VOID_EYE.get(), new DimensionTeleportInfo(CataclysmDimensions.CATACLYSM_BASTION_LOST_LEVEL_KEY, new CDTeleporter(new BlockPos(0, 150, 0))), (Item)ModItems.MONSTROUS_EYE.get(), new DimensionTeleportInfo(CataclysmDimensions.CATACLYSM_SOULS_ANVIL_LEVEL_KEY, new CDNetherTeleporter(new BlockPos(0, 64, 0))), (Item)ModItems.DESERT_EYE.get(), new DimensionTeleportInfo(CataclysmDimensions.CATACLYSM_PHARAOHS_BANE_LEVEL_KEY, new CDTeleporter(new BlockPos(0, 200, 0), 400)), (Item)ModItems.CURSED_EYE.get(), new DimensionTeleportInfo(CataclysmDimensions.CATACLYSM_ETERNAL_FROSTHOLD_LEVEL_KEY, new CDTeleporter(new BlockPos(0, 200, 0), 400)), (Item)ModItems.STORM_EYE.get(), new DimensionTeleportInfo(CataclysmDimensions.CATACLYSM_SANCTUM_FALLEN_LEVEL_KEY, new CDTeleporter(new BlockPos(0, 200, 0))));
    }

    private void onItemUse(LivingEntityUseItemEvent event) {
        if (!CataclysmDimensionModConfig.ENABLE_TELEPORT_EYE) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().f_46443_) {
            return;
        }
        if (entity.m_6144_()) {
            ServerLevel level;
            DimensionTeleportInfo info;
            Player player;
            ItemStack itemStack = event.getItem();
            MinecraftServer minecraftServer = entity.m_9236_().m_7654_();
            if (minecraftServer == null) {
                return;
            }
            if (entity instanceof Player && (player = (Player)entity).m_36335_().m_41519_(itemStack.m_41720_())) {
                return;
            }
            if (TELEPORT_MAP == null) {
                this.initMap();
            }
            if ((info = TELEPORT_MAP.get(itemStack.m_41720_())) != null && (level = minecraftServer.m_129880_(info.dimensionKey())) != null) {
                entity.changeDimension(level, info.teleporter());
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player2 = (ServerPlayer)entity;
                    player2.m_36335_().m_41524_(itemStack.m_41720_(), 600);
                    player2.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_12287_), SoundSource.PLAYERS, player2.m_20185_(), player2.m_20186_(), player2.m_20189_(), 1.0f, 1.0f, (long)player2.m_217043_().m_188502_()));
                }
            }
        }
    }

    private void onServerLevelTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = event.getServer();
        for (ResourceKey<Level> levelResourceKey : CataclysmDimensions.LEVELS) {
            int current;
            ServerLevel serverLevel = server.m_129880_(levelResourceKey);
            if (serverLevel == null || !CataclysmDimensions.LEVELS.contains(serverLevel.m_46472_())) continue;
            ResourceLocation resourceLocation = serverLevel.m_46472_().m_135782_();
            if (!serverLevel.m_6907_().isEmpty()) {
                RESOURCE_KEY_BOOLEAN_MAP.put(resourceLocation, false);
            }
            if (!serverLevel.m_6907_().isEmpty() || !CataclysmDimensionModConfig.RESET_DIMENSION_IF_NO_PLAYER) continue;
            if (!RESOURCE_KEY_BOOLEAN_MAP.getOrDefault(resourceLocation, false).booleanValue()) {
                try {
                    LOGGER.info("[Cataclysm Dimension]: No player inside. trying to reset dimension {}.", (Object)resourceLocation);
                    IOWorker ioWorker = (IOWorker)serverLevel.m_7726_().m_196555_();
                    serverLevel.f_8564_ = false;
                    serverLevel.m_8643_(null, true, true);
                    ioWorker.f_63518_.f_63699_.clear();
                    RESOURCE_LOCATION_INTEGER_MAP.put(resourceLocation, 200);
                    RESOURCE_KEY_BOOLEAN_MAP.put(resourceLocation, true);
                    ArrayList newList = new ArrayList();
                    serverLevel.m_8583_().forEach(newList::add);
                    for (Entity entity : newList) {
                        entity.m_146870_();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("[Cataclysm Dimension]: Failed to reset dimension {}.", (Object)resourceLocation, (Object)e);
                    RESOURCE_KEY_BOOLEAN_MAP.put(resourceLocation, true);
                }
            }
            if ((current = RESOURCE_LOCATION_INTEGER_MAP.getOrDefault(resourceLocation, 0).intValue()) <= 0) continue;
            RESOURCE_LOCATION_INTEGER_MAP.put(resourceLocation, current - 1);
            if (current % 20 == 0) {
                LOGGER.info("[Cataclysm Dimension]: Dimension {} will be reset after {} second.", (Object)resourceLocation, (Object)(current / 20));
            }
            if (current != 1) continue;
            IOWorker ioWorker = (IOWorker)serverLevel.m_7726_().m_196555_();
            try {
                if (Files.exists(ioWorker.f_63518_.f_63700_, new LinkOption[0])) {
                    ioWorker.f_63518_.f_63699_.clear();
                    this.deleteFile(ioWorker.f_63518_.f_63700_, resourceLocation);
                    this.deleteFile(ioWorker.f_63518_.f_63700_.getParent().resolve("entities"), resourceLocation);
                    this.deleteFile(ioWorker.f_63518_.f_63700_.getParent().resolve("poi"), resourceLocation);
                    continue;
                }
                LOGGER.info("[Cataclysm Dimension]: No region files in {}. Skipped.", (Object)resourceLocation);
            }
            catch (IOException e) {
                LOGGER.error("[Cataclysm Dimension]: Failed to reset dimension {}.", (Object)resourceLocation, (Object)e);
            }
        }
    }

    private void deleteFile(Path folder, final ResourceLocation dimId) throws IOException {
        Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                if (Files.deleteIfExists(file)) {
                    LOGGER.info("[Cataclysm Dimension]: {} cache Deleted -> {}", (Object)dimId, (Object)file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void onToolTip(ItemTooltipEvent event) {
        if (!CataclysmDimensionModConfig.ENABLE_TELEPORT_EYE) {
            return;
        }
        if (List.of((Item)ModItems.ABYSS_EYE.get(), (Item)ModItems.STORM_EYE.get(), (Item)ModItems.CURSED_EYE.get(), (Item)ModItems.MECH_EYE.get(), (Item)ModItems.FLAME_EYE.get(), (Item)ModItems.DESERT_EYE.get(), (Item)ModItems.MONSTROUS_EYE.get(), (Item)ModItems.VOID_EYE.get()).contains(event.getItemStack().m_41720_())) {
            event.getToolTip().add(Component.m_237115_((String)"tip.cataclysm_dimension.enter").m_130940_(ChatFormatting.GRAY));
        }
    }

    private void onDatapackLoad(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            this.addNewDatapack(event, CataclysmDimensionModConfig.KEEP_STRUCTURES_IN_ORIGINAL_DIMENSIONS ? "keep_original" : "not_keep_original");
            if (CataclysmDimensionModConfig.RANDOM_SPREAD_IN_DIMENSION) {
                this.addNewDatapack(event, CataclysmDimensionModConfig.KEEP_STRUCTURES_IN_ORIGINAL_DIMENSIONS ? "random_spread_dim" : "random_spread");
            }
        }
    }

    private void addNewDatapack(AddPackFindersEvent event, String name) {
        Path resourcePath = ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"packs/" + name});
        Pack pack = Pack.m_245429_((String)name, (Component)Component.m_237113_((String)name), (boolean)true, path -> new PathPackResources(path, resourcePath, false), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10529_);
        event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
    }

    static {
        RESOURCE_KEY_BOOLEAN_MAP = new HashMap<ResourceLocation, Boolean>();
        RESOURCE_LOCATION_INTEGER_MAP = new HashMap<ResourceLocation, Integer>();
    }

    public record DimensionTeleportInfo(ResourceKey<Level> dimensionKey, ITeleporter teleporter) {
    }
}

