/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.network;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.capabilities.storedhorse.StoredHorse;
import tschipp.callablehorses.common.helper.HorseHelper;

public class HorseCapSyncPacket {
    private int entityID = 0;
    private CompoundTag horseNBT = null;

    public HorseCapSyncPacket() {
    }

    public HorseCapSyncPacket(int entityID, IStoredHorse horse) {
        this.entityID = entityID;
        this.horseNBT = StoredHorse.writeNBT(horse);
    }

    public HorseCapSyncPacket(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.horseNBT = buf.m_130260_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.m_130079_(this.horseNBT);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            Level world;
            Entity e;
            if (ctx.getDirection().getReceptionSide().isClient() && (e = (world = CallableHorses.proxy.getWorld()).m_6815_(this.entityID)) != null) {
                IStoredHorse horse = HorseHelper.getHorseCap(e);
                StoredHorse.readNBT(horse, this.horseNBT);
            }
        });
        ctx.setPacketHandled(true);
    }
}

