/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.worlddata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class StoredHorsesWorldData
extends SavedData {
    private static String name = "callablehorses_stored_horses";
    private Map<String, Integer> entries = new HashMap<String, Integer>();
    private List<String> killedHorses = new ArrayList<String>();
    private List<String> disbandedHorses = new ArrayList<String>();
    private Map<String, CompoundTag> offlineSavedHorses = new HashMap<String, CompoundTag>();
    private int i = 0;

    public static StoredHorsesWorldData load(CompoundTag nbt) {
        StoredHorsesWorldData data = new StoredHorsesWorldData();
        int i = 0;
        while (nbt.m_128441_("" + i)) {
            CompoundTag subTag = nbt.m_128469_("" + i);
            String storageID = subTag.m_128461_("id");
            int num = subTag.m_128451_("num");
            data.entries.put(storageID, num);
            ++i;
        }
        i = 0;
        CompoundTag killed = nbt.m_128469_("killed");
        while (killed.m_128441_("" + i)) {
            data.killedHorses.add(killed.m_128469_("" + i).m_128461_("id"));
            ++i;
        }
        i = 0;
        CompoundTag disbanded = nbt.m_128469_("disbanded");
        while (disbanded.m_128441_("" + i)) {
            data.disbandedHorses.add(disbanded.m_128469_("" + i).m_128461_("id"));
            ++i;
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        CompoundTag tag = new CompoundTag();
        this.entries.forEach((storageID, num) -> {
            CompoundTag subTag = new CompoundTag();
            subTag.m_128359_("id", storageID);
            subTag.m_128405_("num", num.intValue());
            tag.m_128365_("" + this.i, (Tag)subTag);
            ++this.i;
        });
        this.i = 0;
        CompoundTag killed = new CompoundTag();
        for (int k = 0; k < this.killedHorses.size(); ++k) {
            CompoundTag subTag = new CompoundTag();
            subTag.m_128359_("id", this.killedHorses.get(k));
            killed.m_128365_("" + k, (Tag)subTag);
        }
        tag.m_128365_("killed", (Tag)killed);
        CompoundTag disbanded = new CompoundTag();
        for (int k = 0; k < this.disbandedHorses.size(); ++k) {
            CompoundTag subTag = new CompoundTag();
            subTag.m_128359_("id", this.disbandedHorses.get(k));
            disbanded.m_128365_("" + k, (Tag)subTag);
        }
        tag.m_128365_("disbanded", (Tag)disbanded);
        return tag;
    }

    public void addHorseNum(String id, int num) {
        this.entries.put(id, num);
        this.m_77762_();
    }

    public int getHorseNum(String id) {
        Integer i = this.entries.get(id);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public void disbandHorse(String id) {
        this.disbandedHorses.add(id);
        this.m_77762_();
    }

    public boolean isDisbanded(String id) {
        return this.disbandedHorses.contains(id);
    }

    public void clearDisbanded(String id) {
        this.disbandedHorses.remove(id);
        this.m_77762_();
    }

    public void markKilled(String id) {
        this.killedHorses.add(id);
        this.m_77762_();
    }

    public boolean wasKilled(String id) {
        return this.killedHorses.contains(id);
    }

    public void clearKilled(String id) {
        this.killedHorses.remove(id);
        this.m_77762_();
    }

    public void addOfflineSavedHorse(String id, CompoundTag nbt) {
        this.offlineSavedHorses.put(id, nbt);
        this.m_77762_();
    }

    public boolean wasOfflineSaved(String id) {
        return this.offlineSavedHorses.containsKey(id);
    }

    public CompoundTag getOfflineSavedHorse(String id) {
        return this.offlineSavedHorses.get(id);
    }

    public void clearOfflineSavedHorse(String id) {
        this.offlineSavedHorses.remove(id);
        this.m_77762_();
    }

    public static StoredHorsesWorldData getInstance(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        DimensionDataStorage storage = ((ServerLevel)level).m_8895_();
        return (StoredHorsesWorldData)storage.m_164861_(StoredHorsesWorldData::load, StoredHorsesWorldData::new, name);
    }
}

