/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.loot;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.helper.HorseHelper;

public class HorseDropModifier
extends LootModifier {
    public static final Supplier<Codec<HorseDropModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> HorseDropModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, HorseDropModifier::new)));
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"callablehorses");
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> HORSE_DROP = GLM.register("horse_drop", CODEC);
    private LootItemCondition[] conditions;

    protected HorseDropModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
        this.conditions = conditionsIn;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        IStoredHorse horse;
        Entity entity;
        if (context.m_78936_(LootContextParams.f_81455_) && (entity = (Entity)context.m_78953_(LootContextParams.f_81455_)) instanceof AbstractHorse && (horse = HorseHelper.getHorseCap(entity)) != null && horse.isOwned()) {
            generatedLoot.clear();
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CODEC.get();
    }
}

