/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.capabilities.CapabilityHandler;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.worlddata.StoredHorsesWorldData;
import tschipp.callablehorses.network.HorseCapSyncPacket;

public class HorseHelper {
    private static Map<Entity, LazyOptional<IStoredHorse>> cachedHorses = new HashMap<Entity, LazyOptional<IStoredHorse>>();

    public static IHorseOwner getOwnerCap(Player player) {
        LazyOptional cap = player.getCapability(CapabilityHandler.OWNER_CAPABILITY, null);
        if (cap.isPresent()) {
            return (IHorseOwner)cap.resolve().get();
        }
        return null;
    }

    public static IStoredHorse getHorseCap(Entity horse) {
        LazyOptional cap = cachedHorses.get(horse);
        if (cap == null) {
            cap = horse.getCapability(CapabilityHandler.HORSE_CAPABILITY, null);
            cachedHorses.put(horse, (LazyOptional<IStoredHorse>)cap);
            cap.addListener(optional -> cachedHorses.remove(horse));
        }
        if (cap.isPresent()) {
            return (IStoredHorse)cap.resolve().get();
        }
        return null;
    }

    public static void sendHorseUpdateInRange(Entity horse) {
        IStoredHorse storedHorse = HorseHelper.getHorseCap(horse);
        CallableHorses.network.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(horse.m_20185_(), horse.m_20189_(), horse.m_20189_(), 32.0, horse.m_9236_().m_46472_())), (Object)new HorseCapSyncPacket(horse.m_19879_(), storedHorse));
    }

    public static void sendHorseUpdateToClient(Entity horse, Player player) {
        IStoredHorse storedHorse = HorseHelper.getHorseCap(horse);
        CallableHorses.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new HorseCapSyncPacket(horse.m_19879_(), storedHorse));
    }

    @Nullable
    public static Player getPlayerFromUUID(String uuid, Level world) {
        MinecraftServer server = world.m_7654_();
        ServerPlayer owner = server.m_6846_().m_11259_(UUID.fromString(uuid));
        return owner;
    }

    public static void setHorseNum(ServerLevel world, String storageid, int num) {
        world.m_7654_().m_129785_().forEach(serverworld -> {
            StoredHorsesWorldData storedHorses = StoredHorsesWorldData.getInstance((Level)serverworld);
            storedHorses.addHorseNum(storageid, num);
        });
    }

    public static int getHorseNum(ServerLevel world, String storageid) {
        StoredHorsesWorldData storedHorses = StoredHorsesWorldData.getInstance((Level)world);
        return storedHorses.getHorseNum(storageid);
    }

    public static void setHorseLastSeen(Player player) {
        IHorseOwner owner = HorseHelper.getOwnerCap(player);
        owner.setLastSeenPosition(player.m_20182_());
        owner.setLastSeenDim((ResourceKey<Level>)player.m_9236_().m_46472_());
    }

    public static StoredHorsesWorldData getWorldData(ServerLevel world) {
        return StoredHorsesWorldData.getInstance((Level)world);
    }
}

