/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.capabilities.horseowner;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.capabilities.CapabilityHandler;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;

public class HorseOwner
implements IHorseOwner,
ICapabilitySerializable<CompoundTag>,
ICapabilityProvider {
    private int horseNum = 0;
    private CompoundTag horseNBT = new CompoundTag();
    private String storageUUID = "";
    private ResourceKey<Level> lastSeenDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("overworld"));
    private Vec3 lastSeenPos = Vec3.f_82478_;

    @Override
    public AbstractHorse createHorseEntity(Level world) {
        Optional type = EntityType.m_20637_((CompoundTag)this.horseNBT);
        if (type.isPresent()) {
            Entity entity = ((EntityType)type.get()).m_20615_(world);
            if (entity instanceof AbstractHorse) {
                entity.m_20258_(this.horseNBT);
                ++this.horseNum;
                LazyOptional cap = entity.getCapability(CapabilityHandler.HORSE_CAPABILITY, null);
                if (cap.isPresent()) {
                    ((IStoredHorse)cap.resolve().get()).setHorseNum(this.horseNum);
                    entity.m_20084_(UUID.randomUUID());
                    entity.m_20095_();
                    ((AbstractHorse)entity).f_20916_ = 0;
                }
                return (AbstractHorse)entity;
            }
            CallableHorses.LOGGER.error("The entity with NBT " + this.horseNBT.toString() + " wasn't a horse somehow?...");
        }
        return null;
    }

    @Override
    public CompoundTag getHorseNBT() {
        return this.horseNBT;
    }

    @Override
    public void setHorse(AbstractHorse horse, Player player) {
        this.storageUUID = UUID.randomUUID().toString();
        LazyOptional cap = horse.getCapability(CapabilityHandler.HORSE_CAPABILITY, null);
        cap.ifPresent(storedHorse -> {
            CompoundTag tag;
            storedHorse.setHorseNum(this.horseNum);
            storedHorse.setOwned(true);
            storedHorse.setOwnerUUID(player.m_36316_().getId().toString());
            storedHorse.setStorageUUID(this.storageUUID);
            this.horseNBT = tag = horse.serializeNBT();
        });
    }

    @Override
    public void clearHorse() {
        this.horseNum = 0;
        this.horseNBT = new CompoundTag();
        this.storageUUID = "";
        this.lastSeenDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("overworld"));
        this.lastSeenPos = Vec3.f_82478_;
    }

    @Override
    public int getHorseNum() {
        return this.horseNum;
    }

    @Override
    public void setHorseNum(int num) {
        this.horseNum = num;
    }

    @Override
    public String getStorageUUID() {
        return this.storageUUID;
    }

    @Override
    public void setStorageUUID(String id) {
        this.storageUUID = id;
    }

    @Override
    public void setHorseNBT(CompoundTag nbt) {
        this.horseNBT = nbt;
    }

    @Override
    public void setLastSeenPosition(Vec3 pos) {
        this.lastSeenPos = pos;
    }

    @Override
    public Vec3 getLastSeenPosition() {
        return this.lastSeenPos;
    }

    @Override
    public ResourceKey<Level> getLastSeenDim() {
        return this.lastSeenDim;
    }

    @Override
    public void setLastSeenDim(ResourceKey<Level> dim) {
        this.lastSeenDim = dim;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CapabilityHandler.OWNER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public CompoundTag serializeNBT() {
        return HorseOwner.writeNBT(this);
    }

    public void deserializeNBT(CompoundTag tag) {
        HorseOwner.readNBT(this, tag);
    }

    public static CompoundTag writeNBT(IHorseOwner instance) {
        if (instance == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        Vec3 lastSeen = instance.getLastSeenPosition();
        tag.m_128365_("horse", (Tag)instance.getHorseNBT());
        tag.m_128405_("horseNum", instance.getHorseNum());
        tag.m_128359_("uuid", instance.getStorageUUID());
        tag.m_128365_("lastSeenPos", (Tag)NbtUtils.m_129224_((BlockPos)new BlockPos((int)lastSeen.f_82479_, (int)lastSeen.f_82480_, (int)lastSeen.f_82481_)));
        tag.m_128359_("lastSeenDim", instance.getLastSeenDim().m_135782_().toString());
        return tag;
    }

    public static void readNBT(IHorseOwner instance, CompoundTag tag) {
        instance.setHorseNBT(tag.m_128469_("horse"));
        instance.setHorseNum(tag.m_128451_("horseNum"));
        instance.setStorageUUID(tag.m_128461_("uuid"));
        BlockPos temp = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("lastSeenPos"));
        instance.setLastSeenPosition(new Vec3((double)temp.m_123341_(), (double)temp.m_123342_(), (double)temp.m_123343_()));
        instance.setLastSeenDim((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("lastSeenDim"))));
    }
}

