/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.WhistleSounds;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.config.Configs;
import tschipp.callablehorses.common.helper.HorseHelper;
import tschipp.callablehorses.common.worlddata.StoredHorsesWorldData;
import tschipp.callablehorses.network.OwnerSyncShowStatsPacket;
import tschipp.callablehorses.network.PlayWhistlePacket;

public class HorseManager {
    public static boolean callHorse(Player player) {
        IHorseOwner horseOwner;
        if (player != null && (horseOwner = HorseHelper.getOwnerCap(player)) != null) {
            IStoredHorse horse;
            if (horseOwner.getHorseNBT().m_128456_()) {
                player.m_5661_((Component)Component.m_237115_((String)"callablehorses.error.nohorse").m_130940_(ChatFormatting.RED), true);
                return false;
            }
            if (!HorseManager.canCallHorse(player)) {
                return false;
            }
            Random rand = new Random();
            player.m_9236_().m_5594_(player, player.m_20183_(), (SoundEvent)WhistleSounds.WHISTLE.get(), SoundSource.PLAYERS, 1.0f, (float)(1.4 + rand.nextGaussian() / 3.0));
            CallableHorses.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PlayWhistlePacket());
            AbstractHorse e = HorseManager.findHorseWithStorageID(horseOwner.getStorageUUID(), player.m_9236_());
            if (e != null && (horse = HorseHelper.getHorseCap((Entity)e)).getStorageUUID().equals(horseOwner.getStorageUUID())) {
                if (e.m_9236_().m_6042_() == player.m_9236_().m_6042_()) {
                    e.m_20153_();
                    if (e.m_20182_().m_82554_(player.m_20182_()) <= (Double)Configs.SERVER.horseWalkRange.get()) {
                        e.m_21051_(Attributes.f_22277_).m_22100_(((Double)Configs.SERVER.horseWalkRange.get()).doubleValue());
                        e.m_21573_().m_5624_((Entity)player, ((Double)Configs.SERVER.horseWalkSpeed.get()).doubleValue());
                    } else {
                        e.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                        e.m_21573_().m_5624_((Entity)player, ((Double)Configs.SERVER.horseWalkSpeed.get()).doubleValue());
                    }
                    HorseHelper.setHorseLastSeen(player);
                    HorseHelper.sendHorseUpdateInRange((Entity)e);
                    return true;
                }
                HorseManager.saveHorse((Entity)e);
                e.m_6034_(e.m_20185_(), -200.0, e.m_20189_());
                e.m_146870_();
            }
            AbstractHorse newHorse = horseOwner.createHorseEntity(player.m_9236_());
            newHorse.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            player.m_9236_().m_7967_((Entity)newHorse);
            IStoredHorse h = HorseHelper.getHorseCap((Entity)newHorse);
            HorseHelper.setHorseNum((ServerLevel)newHorse.m_9236_(), h.getStorageUUID(), h.getHorseNum());
            HorseHelper.sendHorseUpdateInRange((Entity)newHorse);
            HorseHelper.setHorseLastSeen(player);
            return true;
        }
        return false;
    }

    public static void setHorse(Player player) {
        if (player != null) {
            if (player.m_20202_() == null) {
                player.m_5661_((Component)Component.m_237115_((String)"callablehorses.error.notriding").m_130940_(ChatFormatting.RED), true);
                return;
            }
            Entity e = player.m_20202_();
            if (e instanceof AbstractHorse) {
                if (!HorseManager.canSetHorse(player, e)) {
                    return;
                }
                IStoredHorse storedHorse = HorseHelper.getHorseCap(e);
                String owner = storedHorse.getOwnerUUID();
                String playerID = player.m_36316_().getId().toString();
                boolean owned = storedHorse.isOwned();
                if (owned && !owner.equals(playerID)) {
                    player.m_5661_((Component)Component.m_237115_((String)"callablehorses.error.alreadyowned").m_130940_(ChatFormatting.RED), true);
                    return;
                }
                if (owned && owner.equals(playerID)) {
                    player.m_5661_((Component)Component.m_237115_((String)"callablehorses.error.alreadypersonal").m_130940_(ChatFormatting.RED), true);
                    return;
                }
                IHorseOwner horseOwner = HorseHelper.getOwnerCap(player);
                String ownedID = horseOwner.getStorageUUID();
                if (!ownedID.isEmpty()) {
                    AbstractHorse ent = HorseManager.findHorseWithStorageID(horseOwner.getStorageUUID(), player.m_9236_());
                    if (ent != null) {
                        HorseManager.clearHorse(HorseHelper.getHorseCap((Entity)ent));
                    } else {
                        player.m_9236_().m_7654_().m_129785_().forEach(serverworld -> {
                            StoredHorsesWorldData data = HorseHelper.getWorldData(serverworld);
                            data.disbandHorse(ownedID);
                        });
                    }
                }
                horseOwner.clearHorse();
                horseOwner.setHorse((AbstractHorse)e, player);
                HorseHelper.setHorseLastSeen(player);
                HorseHelper.setHorseNum((ServerLevel)e.m_9236_(), storedHorse.getStorageUUID(), storedHorse.getHorseNum());
                player.m_5661_((Component)Component.m_237115_((String)"callablehorses.success"), true);
                HorseHelper.sendHorseUpdateInRange(e);
            }
        }
    }

    public static void showHorseStats(ServerPlayer player) {
        IHorseOwner owner = HorseHelper.getOwnerCap((Player)player);
        if (owner.getHorseNBT().m_128456_()) {
            player.m_5661_((Component)Component.m_237115_((String)"callablehorses.error.nohorse").m_130940_(ChatFormatting.RED), true);
            return;
        }
        AbstractHorse e = HorseManager.findHorseWithStorageID(owner.getStorageUUID(), player.m_9236_());
        if (e != null) {
            HorseManager.saveHorse((Entity)e);
        }
        CallableHorses.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OwnerSyncShowStatsPacket(owner));
    }

    public static void clearHorse(IStoredHorse horse) {
        horse.setOwned(false);
        horse.setHorseNum(0);
        horse.setOwnerUUID("");
        horse.setStorageUUID("");
    }

    @Nullable
    public static AbstractHorse findHorseWithStorageID(String id, Level world) {
        MinecraftServer server = world.m_7654_();
        ArrayList entities = new ArrayList();
        for (ServerLevel w : server.m_129785_()) {
            entities.addAll(ImmutableList.copyOf((Iterable)w.m_8583_()));
        }
        for (Entity e : entities) {
            IStoredHorse horse;
            if (!(e instanceof AbstractHorse) || !(horse = HorseHelper.getHorseCap(e)).getStorageUUID().equals(id)) continue;
            return (AbstractHorse)e;
        }
        return null;
    }

    public static void prepDeadHorseForRespawning(Entity e) {
        LazyOptional cap = e.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        cap.ifPresent(itemHandler -> {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                itemHandler.extractItem(i, 64, false);
            }
        });
        if (e instanceof AbstractChestedHorse) {
            ((AbstractChestedHorse)e).m_30504_(false);
        }
        e.m_20095_();
        ((LivingEntity)e).m_21153_(((LivingEntity)e).m_21233_());
    }

    public static boolean canCallHorse(Player player) {
        if (HorseManager.isAreaProtected(player, null)) {
            player.m_5661_((Component)Component.m_237115_((String)"callablehorses.error.area").m_130940_(ChatFormatting.RED), true);
            return false;
        }
        if (player.m_20202_() != null) {
            player.m_5661_((Component)Component.m_237115_((String)"callablehorses.error.riding").m_130940_(ChatFormatting.RED), true);
            return false;
        }
        if (((Boolean)Configs.SERVER.checkForSpace.get()).booleanValue()) {
            double startX = player.m_20185_() - 1.0;
            double startY = player.m_20186_();
            double startZ = player.m_20189_() - 1.0;
            double endX = player.m_20185_() + 1.0;
            double endY = player.m_20186_() + 2.0;
            double endZ = player.m_20189_() + 1.0;
            Level world = player.m_9236_();
            for (double x = startX; x <= endX; x += 1.0) {
                for (double y = startY; y <= endY; y += 1.0) {
                    for (double z = startZ; z <= endZ; z += 1.0) {
                        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
                        BlockState state = world.m_8055_(pos);
                        if (state.m_60734_().m_5939_(state, (BlockGetter)world, pos, null) == Shapes.m_83040_()) continue;
                        player.m_5661_((Component)Component.m_237115_((String)"callablehorses.error.nospace").m_130940_(ChatFormatting.RED), true);
                        return false;
                    }
                }
            }
        }
        if (!((Boolean)Configs.SERVER.callableInEveryDimension.get()).booleanValue()) {
            List allowedDims = (List)Configs.SERVER.callableDimsWhitelist.get();
            ResourceKey playerDim = player.m_9236_().m_46472_();
            for (int i = 0; i < allowedDims.size(); ++i) {
                if (!((String)allowedDims.get(i)).equals(playerDim.m_135782_().toString())) continue;
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)"callablehorses.error.dim").m_130940_(ChatFormatting.RED), true);
            return false;
        }
        int maxDistance = (Integer)Configs.SERVER.maxCallingDistance.get();
        if (maxDistance != -1) {
            double movementFactorOwner;
            double movementFactorHorse;
            IHorseOwner owner = HorseHelper.getOwnerCap(player);
            Vec3 lastSeenPos = owner.getLastSeenPosition();
            ResourceKey lastSeenDim = owner.getLastSeenDim();
            if (lastSeenPos.equals((Object)Vec3.f_82478_)) {
                return true;
            }
            MinecraftServer server = player.m_9236_().m_7654_();
            AbstractHorse livingHorse = HorseManager.findHorseWithStorageID(owner.getStorageUUID(), player.m_9236_());
            if (livingHorse != null) {
                lastSeenPos = livingHorse.m_20182_();
                lastSeenDim = livingHorse.m_9236_().m_46472_();
            }
            double movementFactorTotal = (movementFactorHorse = server.m_129880_(lastSeenDim).m_6042_().f_63859_()) > (movementFactorOwner = player.m_9236_().m_6042_().f_63859_()) ? movementFactorHorse / movementFactorOwner : movementFactorOwner / movementFactorHorse;
            double distance = lastSeenPos.m_82554_(player.m_20182_()) / movementFactorTotal;
            if (distance <= (double)maxDistance) {
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)"callablehorses.error.range").m_130940_(ChatFormatting.RED), true);
            return false;
        }
        return true;
    }

    public static boolean canSetHorse(Player player, Entity entity) {
        if (HorseManager.isAreaProtected(player, entity)) {
            player.m_5661_((Component)Component.m_237115_((String)"callablehorses.error.setarea").m_130940_(ChatFormatting.RED), true);
            return false;
        }
        return true;
    }

    public static void saveHorse(Entity e) {
        if (e instanceof AbstractHorse) {
            AbstractHorse abstractHorse = (AbstractHorse)e;
            if (abstractHorse.m_21224_()) {
                return;
            }
            Level world = e.m_9236_();
            IStoredHorse horse = HorseHelper.getHorseCap(e);
            if (horse != null && horse.isOwned()) {
                String ownerid = horse.getOwnerUUID();
                Player owner = HorseHelper.getPlayerFromUUID(ownerid, world);
                if (owner != null) {
                    IHorseOwner horseOwner = HorseHelper.getOwnerCap(owner);
                    if (horseOwner != null) {
                        CompoundTag nbt = e.serializeNBT();
                        horseOwner.setHorseNBT(nbt);
                        horseOwner.setLastSeenDim((ResourceKey<Level>)e.m_9236_().m_46472_());
                        horseOwner.setLastSeenPosition(e.m_20182_());
                    } else {
                        world.m_7654_().m_129785_().forEach(serverworld -> {
                            StoredHorsesWorldData data = HorseHelper.getWorldData(serverworld);
                            data.addOfflineSavedHorse(horse.getStorageUUID(), e.serializeNBT());
                        });
                    }
                } else {
                    StoredHorsesWorldData data = HorseHelper.getWorldData((ServerLevel)world);
                    data.addOfflineSavedHorse(horse.getStorageUUID(), e.serializeNBT());
                }
            }
        }
    }

    private static boolean isAreaProtected(Player player, @Nullable Entity fakeHorse) {
        IHorseOwner owner = HorseHelper.getOwnerCap(player);
        if (fakeHorse == null) {
            fakeHorse = owner.createHorseEntity(player.m_9236_());
        }
        fakeHorse.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        PlayerInteractEvent.EntityInteract interactEvent = new PlayerInteractEvent.EntityInteract(player, InteractionHand.MAIN_HAND, fakeHorse);
        AttackEntityEvent attackEvent = new AttackEntityEvent(player, fakeHorse);
        MinecraftForge.EVENT_BUS.post((Event)interactEvent);
        MinecraftForge.EVENT_BUS.post((Event)attackEvent);
        return interactEvent.isCanceled() || attackEvent.isCanceled();
    }
}

