/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.experimental.module.EnchantmentsBegoneModule;
import org.violetmoon.quark.content.tools.module.AncientTomesModule;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;

public class AncientTomeItem
extends ZetaItem
implements CreativeTabManager.AppendsUniquely {
    public AncientTomeItem(ZetaModule module) {
        super("ancient_tome", module, new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON));
        CreativeTabManager.addToCreativeTab((ResourceKey)CreativeModeTabs.f_256968_, (ItemLike)this);
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTableZeta(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public static ItemStack getEnchantedItemStack(Enchantment ench) {
        ItemStack newStack = new ItemStack((ItemLike)AncientTomesModule.ancient_tome);
        EnchantedBookItem.m_41153_((ItemStack)newStack, (EnchantmentInstance)new EnchantmentInstance(ench, ench.m_6586_()));
        return newStack;
    }

    public static Component getFullTooltipText(Enchantment ench) {
        return Component.m_237110_((String)"quark.misc.ancient_tome_tooltip", (Object[])new Object[]{Component.m_237115_((String)ench.m_44704_()), Component.m_237115_((String)("enchantment.level." + (ench.m_6586_() + 1)))}).m_130940_(ChatFormatting.GRAY);
    }

    public void m_7373_(@NotNull ItemStack stack, Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        Enchantment ench = AncientTomesModule.getTomeEnchantment(stack);
        if (ench != null) {
            tooltip.add(AncientTomeItem.getFullTooltipText(ench));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"quark.misc.ancient_tome_tooltip_any").m_130940_(ChatFormatting.GRAY));
        }
        if (AncientTomesModule.curseGear) {
            tooltip.add((Component)Component.m_237115_((String)"quark.misc.ancient_tome_tooltip_curse").m_130940_(ChatFormatting.RED));
        }
    }

    public List<ItemStack> appendItemsToCreativeTab() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        BuiltInRegistries.f_256876_.forEach(ench -> {
            if (!(EnchantmentsBegoneModule.shouldBegone(ench) || AncientTomesModule.sanityCheck && ench.m_6586_() == 1 || AncientTomesModule.isInitialized() && !AncientTomesModule.validEnchants.contains(ench))) {
                items.add(AncientTomeItem.getEnchantedItemStack(ench));
            }
        });
        return items;
    }
}

