/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.util.BlockPropertyUtil;
import org.violetmoon.quark.content.building.module.HedgesModule;
import org.violetmoon.quark.content.world.block.BlossomLeavesBlock;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.block.ZetaFenceBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.registry.IZetaBlockColorProvider;
import org.violetmoon.zeta.registry.RenderLayerRegistry;

public class HedgeBlock
extends ZetaFenceBlock
implements IZetaBlock,
IZetaBlockColorProvider {
    private static final VoxelShape WOOD_SHAPE = HedgeBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0);
    private static final VoxelShape HEDGE_CENTER_SHAPE = HedgeBlock.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape NORTH_SHAPE = HedgeBlock.m_49796_((double)2.0, (double)1.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0);
    private static final VoxelShape SOUTH_SHAPE = HedgeBlock.m_49796_((double)2.0, (double)1.0, (double)14.0, (double)14.0, (double)16.0, (double)15.0);
    private static final VoxelShape EAST_SHAPE = HedgeBlock.m_49796_((double)14.0, (double)1.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape WEST_SHAPE = HedgeBlock.m_49796_((double)0.0, (double)1.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0);
    private static final VoxelShape EXTEND_SHAPE = HedgeBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    private final Object2IntMap<BlockState> hedgeStateToIndex = new Object2IntOpenHashMap();
    private final VoxelShape[] hedgeShapes;
    public final BlockState leafState;
    public static final BooleanProperty EXTEND = BooleanProperty.m_61465_((String)"extend");

    public HedgeBlock(String regname, @Nullable ZetaModule module, Block fence, Block leaf) {
        super(regname, module, BlockPropertyUtil.copyPropertySafe(fence));
        this.leafState = leaf.m_49966_();
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)EXTEND, (Comparable)Boolean.valueOf(false)));
        this.hedgeShapes = this.cacheHedgeShapes((ImmutableList<BlockState>)this.f_49792_.m_61056_());
        if (module == null) {
            return;
        }
        CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.f_256776_, (ItemLike)this, (ItemLike)leaf, (boolean)false);
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT);
    }

    @Deprecated(forRemoval=true)
    public HedgeBlock(@Nullable ZetaModule module, Block fence, Block leaf) {
        this(HedgeBlock.legacyComputeRegistryName(leaf), module, fence, leaf);
    }

    @Deprecated(forRemoval=true)
    private static String legacyComputeRegistryName(Block leaf) {
        ResourceLocation leafRes = Quark.ZETA.registry.getRegistryName((Object)leaf, (Registry)BuiltInRegistries.f_256975_);
        if (leaf instanceof BlossomLeavesBlock) {
            return leafRes.m_135815_().replaceAll("_blossom_leaves", "") + "_blossom_hedge";
        }
        return leafRes.m_135815_().replaceAll("_leaves", "_hedge");
    }

    public BlockState getLeaf() {
        return this.leafState;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.hedgeShapes[this.getHedgeAABBIndex(state)];
    }

    private VoxelShape[] cacheHedgeShapes(ImmutableList<BlockState> possibleStates) {
        VoxelShape[] shapes = new VoxelShape[possibleStates.size()];
        for (int i = 0; i < shapes.length; ++i) {
            BlockState state = (BlockState)possibleStates.get(i);
            int realIndex = this.getHedgeAABBIndex(state);
            VoxelShape finishedShape = Shapes.m_83110_((VoxelShape)((Boolean)state.m_61143_((Property)EXTEND) != false ? EXTEND_SHAPE : WOOD_SHAPE), (VoxelShape)HEDGE_CENTER_SHAPE);
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52309_)).booleanValue()) {
                finishedShape = Shapes.m_83110_((VoxelShape)finishedShape, (VoxelShape)NORTH_SHAPE);
            }
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52311_)).booleanValue()) {
                finishedShape = Shapes.m_83110_((VoxelShape)finishedShape, (VoxelShape)SOUTH_SHAPE);
            }
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52310_)).booleanValue()) {
                finishedShape = Shapes.m_83110_((VoxelShape)finishedShape, (VoxelShape)EAST_SHAPE);
            }
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52312_)).booleanValue()) {
                finishedShape = Shapes.m_83110_((VoxelShape)finishedShape, (VoxelShape)WEST_SHAPE);
            }
            shapes[realIndex] = finishedShape;
        }
        return shapes;
    }

    protected int getHedgeAABBIndex(BlockState curr) {
        return this.hedgeStateToIndex.computeIntIfAbsent((Object)curr, state -> {
            int i = 0;
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52309_)).booleanValue()) {
                i |= 1;
            }
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52311_)).booleanValue()) {
                i |= 2;
            }
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52310_)).booleanValue()) {
                i |= 4;
            }
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52312_)).booleanValue()) {
                i |= 8;
            }
            if (((Boolean)state.m_61143_((Property)EXTEND)).booleanValue()) {
                i |= 0x10;
            }
            return i;
        });
    }

    public boolean m_53329_(BlockState state, boolean isSideSolid, @NotNull Direction direction) {
        return state.m_204336_(HedgesModule.hedgesTag);
    }

    public boolean canSustainPlantZeta(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull Direction facing, @NotNull String plantabletype) {
        return facing == Direction.UP && (Boolean)state.m_61143_((Property)f_52313_) == false && "plains".equals(plantabletype);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockPos down = blockpos.m_7495_();
        BlockState downState = iblockreader.m_8055_(down);
        return (BlockState)super.m_5573_(context).m_61124_((Property)EXTEND, (Comparable)Boolean.valueOf(downState.m_60734_() instanceof HedgeBlock));
    }

    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)f_52313_)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.m_61124_((Property)EXTEND, (Comparable)Boolean.valueOf(facingState.m_60734_() instanceof HedgeBlock));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{EXTEND});
    }

    @Nullable
    public String getBlockColorProviderName() {
        return "hedge";
    }

    @Nullable
    public String getItemColorProviderName() {
        return "hedge";
    }
}

