/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;

public class PlacementBehaviour {
    public static final PlacementBehaviour NON_SOLID = new PlacementBehaviour((world, pos, rotation, rand) -> false);
    public static final PlacementBehaviour SOLID = new PlacementBehaviour((world, pos, rotation, rand) -> true);
    public static final PlacementBehaviour RANDOM_IF_SOLID_NEARBY = new PlacementBehaviour((world, pos, rotation, rand) -> {
        if (PlacementBehaviour.isSolid(world, pos.m_122012_()) || PlacementBehaviour.isSolid(world, pos.m_122029_()) || PlacementBehaviour.isSolid(world, pos.m_122019_()) || PlacementBehaviour.isSolid(world, pos.m_122024_())) {
            return rand.m_188501_() < 0.6f;
        }
        return false;
    });
    public static PlacementBehaviour STRIPES = new PlacementBehaviour((world, pos, rotation, rand) -> {
        if (rotation == Rotation.NONE || rotation == Rotation.CLOCKWISE_180) {
            return switch (pos.m_123343_() % 3) {
                case 0 -> {
                    if (rand.m_188501_() < 0.9f) {
                        yield true;
                    }
                    yield false;
                }
                case -1, 1 -> {
                    if (rand.m_188501_() < 0.5f) {
                        yield true;
                    }
                    yield false;
                }
                case -2, 2 -> {
                    if (rand.m_188501_() < 0.25f) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return switch (pos.m_123341_() % 3) {
            case 0 -> {
                if (rand.m_188501_() < 0.9f) {
                    yield true;
                }
                yield false;
            }
            case -1, 1 -> {
                if (rand.m_188501_() < 0.5f) {
                    yield true;
                }
                yield false;
            }
            case -2, 2 -> {
                if (rand.m_188501_() < 0.25f) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    });
    public static PlacementBehaviour SMALL_GRID = new PlacementBehaviour((world, pos, rotation, rand) -> rand.m_188501_() < 0.95f - (float)Math.abs(pos.m_123341_() % 3) * 0.2f - (float)Math.abs(pos.m_123343_() % 3) * 0.2f);
    public static PlacementBehaviour LARGE_GRID = new PlacementBehaviour((world, pos, rotation, rand) -> rand.m_188501_() < 1.0f - (float)Math.abs(pos.m_123341_() % 6) * 0.1f - (float)Math.abs(pos.m_123343_() % 6) * 0.1f);
    private final PlacementFunction function;
    @Nullable
    public final BiFunction<Theme, SecondaryTheme, BlockStateProvider> airBlock;

    public PlacementBehaviour(PlacementFunction function) {
        this(function, null);
    }

    public PlacementBehaviour(PlacementFunction function, BiFunction<Theme, SecondaryTheme, BlockStateProvider> airBlock) {
        this.function = function;
        this.airBlock = airBlock;
    }

    public PlacementBehaviour withAirBlock(BiFunction<Theme, SecondaryTheme, BlockStateProvider> airBlock) {
        return new PlacementBehaviour(this.function, airBlock);
    }

    public boolean isSolid(LevelAccessor world, BlockPos pos, Rotation pieceRotation, RandomSource rand) {
        return this.function.isSolid(world, pos, pieceRotation, rand);
    }

    private static boolean isSolid(LevelAccessor world, BlockPos pos) {
        if (world.m_7232_(pos.m_123341_() >> 4, pos.m_123343_() >> 4)) {
            return world.m_8055_(pos).m_60815_() || world.m_8055_(pos.m_7495_()).m_60815_();
        }
        return false;
    }

    public static interface PlacementFunction {
        public boolean isSolid(LevelAccessor var1, BlockPos var2, Rotation var3, RandomSource var4);
    }
}

