/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blocks;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SleepingBagBlock
extends BedBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    public static final BooleanProperty CAN_DROP = BlockStateProperties.f_61428_;
    protected static final VoxelShape SLEEPING_BAG = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape SLEEPING_BAG_NORTH = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)2.5, (double)8.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SLEEPING_BAG_EAST = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)8.0, (double)2.0, (double)0.0, (double)16.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SLEEPING_BAG_SOUTH = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)2.0, (double)8.0, (double)16.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SLEEPING_BAG_WEST = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)8.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public SleepingBagBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(color, properties.m_280606_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)BedPart.FOOT)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.FALSE)).m_61124_((Property)CAN_DROP, (Comparable)Boolean.TRUE));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((BedPart)state.m_61143_(PART)) {
            default -> throw new IncompatibleClassChangeError();
            case BedPart.FOOT -> SLEEPING_BAG;
            case BedPart.HEAD -> {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case EAST: {
                        yield SLEEPING_BAG_EAST;
                    }
                    case SOUTH: {
                        yield SLEEPING_BAG_SOUTH;
                    }
                    case WEST: {
                        yield SLEEPING_BAG_WEST;
                    }
                }
                yield SLEEPING_BAG_NORTH;
            }
        };
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand hand, BlockHitResult hit) {
        if (pLevel.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (pState.m_61143_(PART) != BedPart.HEAD && !(pState = pLevel.m_8055_(pPos = pPos.m_121945_((Direction)pState.m_61143_((Property)f_54117_)))).m_60713_((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!SleepingBagBlock.m_49488_((Level)pLevel)) {
            BlockEntity blockEntity;
            pLevel.m_7471_(pPos, false);
            BlockPos blockpos = pPos.m_121945_(((Direction)pState.m_61143_((Property)f_54117_)).m_122424_());
            if (pLevel.m_8055_(blockpos).m_60713_((Block)this)) {
                pLevel.m_7471_(blockpos, false);
            }
            if ((blockEntity = pLevel.m_7702_(pPos.m_5484_(((Direction)pState.m_61143_((Property)f_54117_)).m_122424_(), pState.m_61143_(PART) == BedPart.FOOT ? 1 : 2))) instanceof BackpackBlockEntity) {
                BackpackBlockEntity blockEntity2 = (BackpackBlockEntity)blockEntity;
                blockEntity2.setSleepingBagDeployed(false);
            }
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)pState.m_61143_((Property)OCCUPIED)).booleanValue()) {
            if (!this.m_49490_(pLevel, pPos)) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.enableSleepingBagSpawnPoint.get()).booleanValue() && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            serverPlayer.m_9158_(pLevel.m_46472_(), pPos, serverPlayer.m_146908_(), true, true);
        }
        pPlayer.m_7720_(pPos).ifLeft(p_49477_ -> {
            if (p_49477_.m_36423_() != null) {
                pPlayer.m_5661_(p_49477_.m_36423_(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    private boolean m_49490_(Level level, BlockPos pos) {
        List var3 = level.m_6443_(Villager.class, new AABB(pos), LivingEntity::m_5803_);
        if (var3.isEmpty()) {
            return false;
        }
        ((Villager)var3.get(0)).m_5796_();
        return true;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float factor) {
        super.m_142072_(level, state, pos, entity, factor * 0.75f);
    }

    public void m_5548_(BlockGetter getter, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(getter, entity);
        } else {
            this.m_49456_(entity);
        }
    }

    private void m_49456_(Entity entity) {
        Vec3 var2 = entity.m_20184_();
        if (var2.f_82480_ < 0.0) {
            double var3 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(var2.f_82479_, -var2.f_82480_ * 0.3300000262260437 * var3, var2.f_82481_);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor accessor, BlockPos pos, BlockPos newPos) {
        if (direction == SleepingBagBlock.m_49533_((BedPart)state.m_61143_(PART), (Direction)state.m_61143_((Property)f_54117_))) {
            return newState.m_60713_((Block)this) && newState.m_61143_(PART) != state.m_61143_(PART) ? (BlockState)state.m_61124_((Property)OCCUPIED, (Comparable)((Boolean)newState.m_61143_((Property)OCCUPIED))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, newState, accessor, pos, newPos);
    }

    private static Direction m_49533_(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        boolean isFoot = state.m_61143_(PART) == BedPart.FOOT;
        BlockPos backpackPos = isFoot ? pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_()) : pos.m_5484_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_(), 2);
        BlockEntity blockEntity = level.m_7702_(backpackPos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity blockEntity2 = (BackpackBlockEntity)blockEntity;
            blockEntity2.setSleepingBagDeployed(false);
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        return context.m_43725_().m_8055_(blockpos1).m_60629_(context) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART, OCCUPIED, CAN_DROP});
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack itemstack) {
        super.m_6402_(level, pos, state, livingEntity, itemstack);
        if (!level.f_46443_) {
            BlockPos var6 = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
            level.m_7731_(var6, (BlockState)state.m_61124_(PART, (Comparable)BedPart.HEAD), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        BlockPos var3 = pos.m_5484_((Direction)state.m_61143_((Property)f_54117_), state.m_61143_(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.m_14130_((int)var3.m_123341_(), (int)pos.m_123342_(), (int)var3.m_123343_());
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        if (!((Boolean)pState.m_61143_((Property)CAN_DROP)).booleanValue()) {
            return List.of();
        }
        return super.m_49635_(pState, pParams);
    }

    public BlockEntity m_142194_(BlockPos p_152175_, BlockState p_152176_) {
        return null;
    }
}

