/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.world.entity.mobpatch;

import java.util.List;
import java.util.Random;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.joml.Vector3f;
import reascer.wom.animation.dodges.CancelableDodgeAnimation;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.animations.entitys.AnimsLupus;
import reascer.wom.world.entity.WOMEntities;
import reascer.wom.world.entity.ai.goals.DashAttackGoal;
import reascer.wom.world.entity.ai.goals.RunAroundTargetGoal;
import reascer.wom.world.entity.ai.goals.WOMRandomLookAroundGoal;
import reascer.wom.world.entity.mob.LupusRex;
import reascer.wom.world.entity.mobpatch.WomMobPatch;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.DodgeAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class LupusRexPatch
extends WomMobPatch<LupusRex> {
    public Player tempParent;
    public int playModTimer;
    public int OwnerSneakingTimeStamp;
    public float playerYRotStage;
    public int learningCooldown;
    public boolean hasLearnSomething;
    public float playerPrevYRot;
    public boolean side;
    public boolean isWet;
    public int ShakeWaterOffCountDown;
    public int Sleeping;
    public int SleepingCooldown;

    public LupusRexPatch() {
        super((Faction)Factions.NEUTRAL);
        this.dashAttackAnimation = AnimsLupus.LUPUS_REX_COUNTERATTACK;
        this.blackoutAnimation = AnimsLupus.LUPUS_REX_BLACKOUT;
        this.playModTimer = 0;
        this.tempParent = null;
        this.learningCooldown = 0;
        this.hasLearnSomething = false;
        this.playerYRotStage = 0.0f;
        this.playerPrevYRot = 0.0f;
        this.side = false;
        this.Sleeping = 0;
        this.SleepingCooldown = 1600;
    }

    public static void initAttributes(EntityAttributeModificationEvent event) {
        event.add((EntityType)WOMEntities.LUPUS_REX.get(), (Attribute)EpicFightAttributes.MAX_STRIKES.get(), 8.0);
        event.add((EntityType)WOMEntities.LUPUS_REX.get(), (Attribute)EpicFightAttributes.IMPACT.get(), 6.0);
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, AnimsLupus.LUPUS_REX_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, AnimsLupus.LUPUS_REX_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.RUN, AnimsLupus.LUPUS_REX_RUN);
        animator.addLivingAnimation((LivingMotion)LivingMotions.SNEAK, AnimsLupus.LUPUS_REX_SNEAK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.SPECTATE, AnimsLupus.LUPUS_REX_SNEAK_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.JUMP, AnimsLupus.LUPUS_REX_JUMP);
        animator.addLivingAnimation((LivingMotion)LivingMotions.DEATH, AnimsLupus.LUPUS_REX_DEATH);
        animator.addLivingAnimation((LivingMotion)LivingMotions.SLEEP, AnimsLupus.LUPUS_REX_SLEEP_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.SIT, AnimsLupus.LUPUS_REX_SIT);
        animator.addLivingAnimation((LivingMotion)LivingMotions.ADMIRE, AnimsLupus.LUPUS_REX_SIT_TILTED_HEAD);
        animator.addLivingAnimation((LivingMotion)LivingMotions.CREATIVE_IDLE, AnimsLupus.LUPUS_REX_PLAY_IDLE);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((LupusRex)this.original).m_21223_() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (this.state.inaction() && considerInaction) {
            this.currentLivingMotion = LivingMotions.INACTION;
        } else if ((Integer)((LupusRex)this.original).m_20088_().m_135370_(LupusRex.COMMAND) == 1 && ((LupusRex)this.original).m_5448_() == null && Math.sqrt(((LupusRex)this.original).m_20238_(((LupusRex)this.original).getOriginalSitPosition())) < 3.0) {
            this.currentLivingMotion = LivingMotions.SIT;
            if (((LupusRex)this.original).m_5803_()) {
                this.currentLivingMotion = LivingMotions.SLEEP;
            }
        } else {
            this.currentLivingMotion = (Integer)((LupusRex)this.original).m_20088_().m_135370_(LupusRex.COMMAND) == 4 && ((LupusRex)this.original).m_5448_() == null ? LivingMotions.ADMIRE : (((LupusRex)this.original).m_20202_() != null ? LivingMotions.MOUNT : (((LupusRex)this.original).m_5803_() ? LivingMotions.SLEEP : (((LupusRex)this.original).m_20184_().f_82480_ < (double)-0.55f || this.isAirborneState() ? LivingMotions.FALL : (((LupusRex)this.original).f_267362_.m_267731_() > 0.01f ? (this.tempParent != null && ((LupusRex)this.original).isPlayful() && this.tempParent.m_6047_() && ((LupusRex)this.original).m_20184_().m_165924_() < ((LupusRex)this.original).m_21133_(Attributes.f_22279_) * 0.75 ? LivingMotions.SPECTATE : (((LupusRex)this.original).m_20184_().m_165924_() > ((LupusRex)this.original).m_21133_(Attributes.f_22279_) * 0.75 ? LivingMotions.RUN : LivingMotions.WALK)) : (this.tempParent != null && ((LupusRex)this.original).isPlayful() && this.tempParent.m_6047_() ? LivingMotions.SNEAK : ((Integer)((LupusRex)this.original).m_20088_().m_135370_(LupusRex.COMMAND) == -2 ? LivingMotions.CREATIVE_IDLE : LivingMotions.IDLE))))));
        }
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    public void AttackPatern() {
        if (this.currentAnimation().equals(AnimsLupus.LUPUS_REX_STRONG_BITE) && this.getEntityState().canBasicAttack()) {
            if (this.lastAttackResultType == AttackResult.ResultType.SUCCESS) {
                if (new Random().nextBoolean()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_DODGE, 0.0f);
                } else {
                    this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_BOMBE_BITE, 0.0f);
                }
            } else {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_WEAK_BITE, 1.0f);
            }
        }
        if (this.currentAnimation().equals(AnimsLupus.LUPUS_REX_COUNTERATTACK) && this.getEntityState().canBasicAttack()) {
            if (this.getElapsedTime() > 2.0f) {
                if (new Random().nextBoolean()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_DASH_BITE, 0.0f);
                } else {
                    this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_WEAK_BITE, 0.0f);
                }
            } else {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_STRONG_BITE, 0.0f);
            }
        }
        if (this.currentAnimation().equals(AnimsLupus.LUPUS_REX_WEAK_BITE) && this.getEntityState().canBasicAttack()) {
            if (new Random().nextBoolean()) {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_DODGE, 0.0f);
            } else {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_TAIL_WIPE, 0.0f);
            }
        }
        if (this.currentAnimation().equals(AnimsLupus.LUPUS_REX_DODGE) && this.getEntityState().canBasicAttack()) {
            if (((LupusRex)this.getOriginal()).m_21223_() < ((LupusRex)this.getOriginal()).m_21233_() * 0.3f) {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_EXHAUSTED, 0.0f);
            } else if (new Random().nextBoolean()) {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_BOMBE_BITE, 0.0f);
            } else if (this.getTarget().m_20270_(this.original) < 3.0f) {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_COUNTERATTACK, 0.0f);
            } else {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_DASH_BITE, 0.0f);
            }
        }
        if (this.currentAnimation().equals(AnimsLupus.LUPUS_REX_TAIL_WIPE) && this.getEntityState().canBasicAttack()) {
            if (new Random().nextBoolean() && this.getTarget().m_20270_(this.original) < 5.0f) {
                if (new Random().nextBoolean()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_DODGE, 0.0f);
                }
            } else {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_DASH_BITE, 0.3f);
            }
        }
        if (this.currentAnimation().equals(AnimsLupus.LUPUS_REX_DASH_BITE) && this.getEntityState().canBasicAttack()) {
            this.rotateTo((Entity)((LupusRex)this.getOriginal()).m_5448_(), 360.0f, false);
            ((LupusRex)this.getOriginal()).m_7618_(EntityAnchorArgument.Anchor.FEET, ((LupusRex)this.getOriginal()).m_5448_().m_20182_());
            if (this.getTarget().m_20270_(this.original) < 4.0f) {
                if (new Random().nextBoolean()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_WEAK_BITE, 0.0f);
                } else {
                    this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_STRONG_BITE, 0.3f);
                }
            } else if (new Random().nextBoolean()) {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_TAIL_WIPE, this.lastAttackResultType == AttackResult.ResultType.SUCCESS ? 0.0f : 1.0f);
            } else {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_DASH_BITE, 0.0f);
            }
        }
        if (this.getTarget().m_20270_(this.original) < 3.0f && this.getEntityState().canBasicAttack()) {
            if (new Random().nextBoolean()) {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_DODGE, 0.0f);
            } else if (new Random().nextBoolean()) {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_WEAK_BITE, 0.0f);
            } else {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_COUNTERATTACK, 0.5f);
            }
        }
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        if (((LupusRex)this.original).m_6084_() && this.getTarget() != null && ((LupusRex)this.original).m_6779_(this.getTarget()) && !((LupusRex)this.original).m_9236_().m_5776_() && this.canAttack) {
            this.AttackPatern();
        }
        LupusRex lupusRex = (LupusRex)this.original;
        if (!this.isLogicalClient()) {
            if (this.getServerAnimator().animationPlayer.getAnimation().equals(AnimsLupus.LUPUS_REX_PET) && this.getServerAnimator().animationPlayer.getElapsedTime() < 0.5f) {
                AABB boxV = AABB.m_165882_((Vec3)lupusRex.m_20182_(), (double)20.0, (double)20.0, (double)20.0);
                List listV = lupusRex.m_9236_().m_45976_(Player.class, boxV);
                for (Player player : listV) {
                    ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, ServerPlayerPatch.class);
                    if (!serverPlayerPatch.getServerAnimator().animationPlayer.getAnimation().equals(WOMAnimations.BIPED_PET_LUPUS) || !lupusRex.m_21805_().equals(player.m_20148_())) continue;
                    float distance = 2.55f;
                    if (serverPlayerPatch != null && player.m_20270_((Entity)lupusRex) > distance) {
                        lupusRex.m_6478_(MoverType.SELF, player.m_20318_(0.0f).m_82546_(lupusRex.m_20318_(0.0f)).m_82490_((double)(0.1f * (player.m_20270_((Entity)lupusRex) / distance))));
                        continue;
                    }
                    if (serverPlayerPatch == null || !(player.m_20270_((Entity)lupusRex) < distance)) continue;
                    lupusRex.m_6478_(MoverType.SELF, player.m_20318_(0.0f).m_82546_(lupusRex.m_20318_(0.0f)).m_82490_((double)(-0.6f * (1.0f - player.m_20270_((Entity)lupusRex) / distance))));
                }
            }
            if (lupusRex.m_5448_() != null && this.SleepingCooldown == 0) {
                this.SleepingCooldown = 200;
                lupusRex.setSleeping(false);
            }
            if (this.SleepingCooldown > 0 && !lupusRex.m_5803_()) {
                if (!((LupusRex)this.original).m_30614_() || ((LupusRex)this.original).m_21223_() < ((LupusRex)this.original).m_21233_()) {
                    --this.SleepingCooldown;
                }
                if (lupusRex.m_269323_() != null && lupusRex.m_269323_().m_5803_() || this.tempParent != null && this.tempParent.m_5803_()) {
                    lupusRex.m_20088_().m_135381_(LupusRex.COMMAND, (Object)0);
                    lupusRex.setSleeping(true);
                    this.updateMotion(false);
                    if (this.Sleeping == 0) {
                        this.Sleeping = new Random().nextInt(100, 200);
                    }
                    this.SleepingCooldown = 0;
                    this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_SLEEP_START, 0.0f);
                }
            }
            if (!(lupusRex.m_5803_() || this.SleepingCooldown != 0 || this.getEntityState().inaction() || lupusRex.m_5448_() != null || (Integer)lupusRex.m_20088_().m_135370_(LupusRex.COMMAND) != 0 && (Integer)lupusRex.m_20088_().m_135370_(LupusRex.COMMAND) != 1)) {
                lupusRex.setSleeping(true);
                this.updateMotion(false);
                if (this.Sleeping == 0) {
                    this.Sleeping = 800;
                }
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_SLEEP_START, 0.0f);
            }
            if (this.Sleeping == 0 && lupusRex.m_5803_()) {
                this.Sleeping = new Random().nextInt(200, 400);
                this.SleepingCooldown = 0;
            }
            if (this.Sleeping > 0 && (this.SleepingCooldown > 0 || (Integer)lupusRex.m_20088_().m_135370_(LupusRex.COMMAND) != 0 && (Integer)lupusRex.m_20088_().m_135370_(LupusRex.COMMAND) != 1)) {
                lupusRex.setSleeping(false);
                this.Sleeping = 0;
            }
            if (this.Sleeping > 0 && this.SleepingCooldown == 0) {
                lupusRex.m_5634_(0.02f);
                --this.Sleeping;
                if (this.Sleeping == 0) {
                    this.SleepingCooldown = 1600 - new Random().nextInt(0, 200);
                    lupusRex.setSleeping(false);
                    this.updateMotion(false);
                    if (!this.isLogicalClient()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_SHAKE, 0.5f);
                    }
                } else if (lupusRex.m_5448_() != null || (Integer)lupusRex.m_20088_().m_135370_(LupusRex.COMMAND) != 0 && (Integer)lupusRex.m_20088_().m_135370_(LupusRex.COMMAND) != 1) {
                    this.SleepingCooldown = Math.max(1600 - this.Sleeping * 2 - new Random().nextInt(0, 200) - this.SleepingCooldown, 200);
                    this.Sleeping = 0;
                    lupusRex.setSleeping(false);
                    this.updateMotion(false);
                    if (!this.isLogicalClient()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_SHAKE, 0.5f);
                    }
                }
            }
        }
        if (lupusRex.m_20070_()) {
            this.isWet = true;
            this.ShakeWaterOffCountDown = 80;
        } else if (this.ShakeWaterOffCountDown > 0) {
            --this.ShakeWaterOffCountDown;
            if (this.ShakeWaterOffCountDown == 20 && !this.isLogicalClient()) {
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_SHAKE, 0.0f);
            }
            if (this.ShakeWaterOffCountDown == 0) {
                this.isWet = false;
            }
        }
        if (!this.isLogicalClient() && this.isWet) {
            ((ServerLevel)lupusRex.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123804_, lupusRex.m_20182_().f_82479_, lupusRex.m_20182_().f_82480_, lupusRex.m_20182_().f_82481_, 1, (double)(lupusRex.m_20205_() / 2.0f), (double)(lupusRex.m_20206_() / 2.0f), (double)(lupusRex.m_20205_() / 2.0f), 0.5);
        }
        if ((lupusRex.m_6162_() || !lupusRex.m_6162_() && ((LupusRex)this.original).m_30614_()) && this.tempParent == null) {
            List listPlayer = lupusRex.m_9236_().m_45976_(Player.class, lupusRex.m_20191_().m_82377_(8.0, 4.0, 8.0));
            double d0 = Double.MAX_VALUE;
            for (Player player : listPlayer) {
                double d1 = lupusRex.m_20280_((Entity)player);
                if (d1 > d0) continue;
                d0 = d1;
                this.tempParent = player;
                if (lupusRex.m_269323_() != null) continue;
                ((LupusRex)this.original).m_20088_().m_135381_(LupusRex.COMMAND, (Object)0);
            }
        }
        if (this.tempParent != null && this.tempParent == this.getTarget()) {
            lupusRex.m_21661_();
        }
        if (!this.isLogicalClient()) {
            if (lupusRex.m_6084_() && lupusRex.m_30614_() && lupusRex.isOrderedToFollow() && lupusRex.m_269323_() != null && this.getTarget() == null && !this.getEntityState().inaction()) {
                AABB box = AABB.m_165882_((Vec3)lupusRex.m_20182_(), (double)lupusRex.m_20205_(), (double)lupusRex.m_20206_(), (double)lupusRex.m_20205_());
                List list = lupusRex.m_9236_().m_45933_((Entity)lupusRex, box);
                for (Entity entity : list) {
                    if (entity instanceof Player || entity instanceof ExperienceOrb || entity instanceof ItemEntity) continue;
                    double power = 0.1;
                    double d1 = lupusRex.m_20182_().m_7096_() - entity.m_20185_();
                    double d2 = lupusRex.m_20182_().m_7098_() - entity.m_20186_();
                    double d0 = lupusRex.m_20182_().m_7094_() - entity.m_20189_();
                    while (d1 * d1 + d0 * d0 < 1.0E-4) {
                        d1 = (Math.random() - Math.random()) * 0.01;
                        d0 = (Math.random() - Math.random()) * 0.01;
                    }
                    entity.f_19812_ = true;
                    Vec3 vec3 = entity.m_20184_().m_82490_(0.5);
                    Vec3 vec31 = new Vec3(d1, d2, d0).m_82541_().m_82490_(power);
                    entity.m_6478_(MoverType.SELF, new Vec3(vec3.f_82479_ - vec31.f_82479_, vec3.f_82480_ - vec31.f_82480_, vec3.f_82481_ - vec31.f_82481_));
                }
                if (lupusRex.m_269323_().m_20159_() && lupusRex.m_269323_().m_20202_() != lupusRex && lupusRex.m_20270_((Entity)lupusRex.m_269323_()) > 1.0f && lupusRex.m_20270_((Entity)lupusRex.m_269323_()) < 5.0f) {
                    lupusRex.m_21573_().m_26573_();
                    this.setYRot(lupusRex.m_269323_().m_146908_());
                    Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(0.0f, lupusRex.m_269323_().m_146908_()));
                    float scale = 2.4f;
                    if (lupusRex.m_20270_((Entity)lupusRex.m_269323_()) > 3.0f) {
                        scale = 2.4f;
                    }
                    Vec3 jumpDir = OpenMatrix4f.transform((OpenMatrix4f)OpenMatrix4f.createRotatorDeg((float)0.0f, (Vec3f)Vec3f.Y_AXIS), (Vec3)forwardHorizontal.m_82490_(((LivingEntity)lupusRex.m_269323_().m_20202_()).m_21051_(Attributes.f_22279_).m_22135_() * (double)scale));
                    lupusRex.m_20334_(jumpDir.f_82479_, lupusRex.m_20184_().f_82480_, jumpDir.f_82481_);
                } else {
                    float closerDistance = 2.0f;
                    if (lupusRex.m_269323_().m_20159_()) {
                        closerDistance = 6.0f;
                    }
                    if ((lupusRex.m_269323_().m_20184_().m_165924_() > 0.1 || ((LupusRex)this.original).m_269323_() != null && ((LupusRex)this.original).isPlayful() && ((LupusRex)this.original).m_269323_().m_6047_() || lupusRex.m_20270_((Entity)lupusRex.m_269323_()) > 3.0f) && lupusRex.m_20270_((Entity)lupusRex.m_269323_()) > closerDistance && lupusRex.m_20270_((Entity)lupusRex.m_269323_()) < 12.0f) {
                        Vec3 frontZoneVec3 = new Vec3(lupusRex.m_269323_().m_20185_() + lupusRex.m_269323_().m_20184_().f_82479_ * 30.0, lupusRex.m_269323_().m_20186_() + (double)lupusRex.m_269323_().m_20192_(), lupusRex.m_269323_().m_20189_() + lupusRex.m_269323_().m_20184_().f_82481_ * 30.0);
                        lupusRex.m_21573_().m_26573_();
                        if (lupusRex.m_20270_((Entity)lupusRex.m_269323_()) > 3.0f) {
                            float power = 1.0f;
                            if (Math.sqrt(lupusRex.m_20238_(frontZoneVec3)) < 8.0 && lupusRex.m_269323_().m_20184_().m_165924_() != 0.0) {
                                this.rotateTo((Entity)lupusRex.m_269323_(), 2.0f, true);
                            } else {
                                if (lupusRex.m_269323_().m_20184_().m_165924_() == 0.0) {
                                    power = 2.0f;
                                }
                                this.rotateTo((Entity)lupusRex.m_269323_(), 5.0f * power, true);
                            }
                        } else {
                            this.setYRot(MathUtils.lerpBetween((float)lupusRex.m_269323_().f_20885_, (float)this.getYRot(), (float)0.9f));
                        }
                        if (Math.sqrt(lupusRex.m_20238_(frontZoneVec3)) < 8.0 && lupusRex.m_269323_().m_20184_().m_165924_() != 0.0) {
                            this.setYRot(MathUtils.lerpBetween((float)lupusRex.m_269323_().f_20885_, (float)this.getYRot(), (float)0.9f));
                        }
                        Vec3 deltaMove = lupusRex.m_20184_();
                        Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(0.0f, lupusRex.m_20270_((Entity)lupusRex.m_269323_()) > 3.0f ? lupusRex.m_5675_(0.0f) : this.getYRot()));
                        float impulsePower = (float)(lupusRex.m_269323_().m_20184_().m_165924_() * 2.0);
                        if (lupusRex.m_269323_().m_20184_().m_165924_() == 0.0) {
                            impulsePower = lupusRex.m_20270_((Entity)lupusRex.m_269323_()) * 0.1f;
                        }
                        Vec3 impulse = OpenMatrix4f.transform((OpenMatrix4f)OpenMatrix4f.createRotatorDeg((float)0.0f, (Vec3f)Vec3f.Y_AXIS), (Vec3)forwardHorizontal.m_82490_((double)impulsePower));
                        if (lupusRex.m_20270_((Entity)lupusRex.m_269323_()) > 3.0f) {
                            lupusRex.m_21563_().m_24964_(new Vec3(lupusRex.m_269323_().m_20185_() + lupusRex.m_269323_().m_20184_().f_82479_ * 30.0, lupusRex.m_269323_().m_20186_() + (double)lupusRex.m_269323_().m_20192_(), lupusRex.m_269323_().m_20189_() + lupusRex.m_269323_().m_20184_().f_82481_ * 30.0));
                            float power = 1.5f;
                            if (Math.sqrt(lupusRex.m_20238_(frontZoneVec3)) < 8.0) {
                                power = 0.8f;
                            }
                            lupusRex.m_20334_(MathUtils.lerpBetween((float)((float)lupusRex.m_269323_().m_20184_().f_82479_ * 2.2f), (float)((float)impulse.f_82479_ * power), (float)0.75f), deltaMove.f_82480_, MathUtils.lerpBetween((float)((float)lupusRex.m_269323_().m_20184_().f_82481_ * 2.2f), (float)((float)impulse.f_82481_ * power), (float)0.75f));
                        } else {
                            lupusRex.m_20334_(MathUtils.lerpBetween((float)((float)lupusRex.m_269323_().m_20184_().f_82479_ * 2.2f), (float)((float)impulse.f_82479_), (float)0.75f), deltaMove.f_82480_, MathUtils.lerpBetween((float)((float)lupusRex.m_269323_().m_20184_().f_82481_ * 2.2f), (float)((float)impulse.f_82481_), (float)0.75f));
                        }
                    } else {
                        Vec3 deltaMove = lupusRex.m_20184_();
                        lupusRex.m_20334_(MathUtils.lerpBetween((float)((float)deltaMove.f_82479_), (float)0.0f, (float)0.5f), deltaMove.f_82480_, MathUtils.lerpBetween((float)((float)deltaMove.f_82481_), (float)0.0f, (float)0.5f));
                    }
                }
            }
            if (lupusRex.m_6084_() && this.tempParent != null && lupusRex.m_6162_() && !lupusRex.playingMode && !((LupusRex)this.original).m_30614_()) {
                if (this.tempParent.m_20184_().m_165924_() > 0.1 && lupusRex.m_20270_((Entity)this.tempParent) > 1.0f && lupusRex.m_20270_((Entity)this.tempParent) < 10.0f) {
                    lupusRex.m_21573_().m_26573_();
                    Vec3 frontZoneVec3 = new Vec3(this.tempParent.m_20185_() + this.tempParent.m_20184_().f_82479_ * 30.0, this.tempParent.m_20186_() + (double)this.tempParent.m_20192_(), this.tempParent.m_20189_() + this.tempParent.m_20184_().f_82481_ * 30.0);
                    if (lupusRex.m_20270_((Entity)this.tempParent) > 3.0f) {
                        this.rotateTo((Entity)this.tempParent, 10.0f, true);
                    } else {
                        this.setYRot(MathUtils.lerpBetween((float)this.tempParent.f_20885_, (float)this.getYRot(), (float)0.9f));
                    }
                    Vec3 deltaMove = lupusRex.m_20184_();
                    Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(0.0f, lupusRex.m_20270_((Entity)this.tempParent) > 3.0f ? lupusRex.m_5675_(0.0f) : lupusRex.m_146908_()));
                    Vec3 impulse = OpenMatrix4f.transform((OpenMatrix4f)OpenMatrix4f.createRotatorDeg((float)0.0f, (Vec3f)Vec3f.Y_AXIS), (Vec3)forwardHorizontal.m_82490_(this.tempParent.m_20184_().m_165924_() * 2.0));
                    if (lupusRex.m_20270_((Entity)this.tempParent) > 3.0f) {
                        lupusRex.m_21563_().m_24964_(new Vec3(this.tempParent.m_20185_() + this.tempParent.m_20184_().f_82479_ * 30.0, this.tempParent.m_20186_() + (double)this.tempParent.m_20192_(), this.tempParent.m_20189_() + this.tempParent.m_20184_().f_82481_ * 30.0));
                        float power = 1.5f;
                        if (Math.sqrt(lupusRex.m_20238_(frontZoneVec3)) < 5.0) {
                            power = 0.8f;
                        }
                        lupusRex.m_20334_(MathUtils.lerpBetween((float)((float)this.tempParent.m_20184_().f_82479_ * 2.2f), (float)((float)impulse.f_82479_ * power), (float)0.75f), deltaMove.f_82480_, MathUtils.lerpBetween((float)((float)this.tempParent.m_20184_().f_82481_ * 2.2f), (float)((float)impulse.f_82481_ * power), (float)0.75f));
                    } else {
                        lupusRex.m_20334_(MathUtils.lerpBetween((float)((float)this.tempParent.m_20184_().f_82479_ * 2.2f), (float)((float)impulse.f_82479_), (float)0.75f), deltaMove.f_82480_, MathUtils.lerpBetween((float)((float)this.tempParent.m_20184_().f_82481_ * 2.2f), (float)((float)impulse.f_82481_), (float)0.75f));
                    }
                } else {
                    Vec3 deltaMove = lupusRex.m_20184_();
                    lupusRex.m_20334_(MathUtils.lerpBetween((float)((float)deltaMove.f_82479_), (float)0.0f, (float)0.5f), deltaMove.f_82480_, MathUtils.lerpBetween((float)((float)deltaMove.f_82481_), (float)0.0f, (float)0.5f));
                }
            }
        }
        if (!lupusRex.m_6162_() && !((LupusRex)this.original).m_30614_()) {
            this.tempParent = null;
        }
        if (((LupusRex)this.original).m_30614_() && lupusRex.m_269323_() != null) {
            this.tempParent = (Player)lupusRex.m_269323_();
        }
        if ((lupusRex.m_6162_() || lupusRex.isPlayful()) && !((LupusRex)this.original).m_5803_() && this.tempParent != null && lupusRex.m_20280_((Entity)this.tempParent) < 12.0 && this.tempParent.m_6047_() && this.tempParent.m_20184_().m_165924_() == 0.0 && (Integer)((LupusRex)this.original).m_20088_().m_135370_(LupusRex.COMMAND) != -2 && (Integer)((LupusRex)this.original).m_20088_().m_135370_(LupusRex.COMMAND) != 4 && (Integer)((LupusRex)this.original).m_20088_().m_135370_(LupusRex.COMMAND) != 3) {
            ++this.OwnerSneakingTimeStamp;
            lupusRex.m_21573_().m_26573_();
            if (this.OwnerSneakingTimeStamp > 40) {
                this.OwnerSneakingTimeStamp = 0;
                this.playModTimer = 3600;
                this.playerYRotStage = 0.0f;
                this.playerPrevYRot = this.tempParent.f_20885_;
                this.rotateTo((Entity)this.tempParent, 360.0f, false);
                lupusRex.m_21563_().m_148051_((Entity)this.tempParent);
                if (!this.isLogicalClient()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_PLAY_START, 0.0f);
                    ((LupusRex)this.original).m_20088_().m_135381_(LupusRex.COMMAND, (Object)-2);
                }
            }
        } else {
            this.OwnerSneakingTimeStamp = 0;
        }
        if (this.learningCooldown > 0) {
            --this.learningCooldown;
            if (this.learningCooldown == 0) {
                ((LupusRex)this.original).m_20088_().m_135381_(LupusRex.COMMAND, (Object)-2);
            }
        }
        if (this.playModTimer > 0 && this.tempParent != null) {
            --this.playModTimer;
            lupusRex.playingMode = true;
            if ((Integer)((LupusRex)this.original).m_20088_().m_135370_(LupusRex.COMMAND) != -1 && (Integer)((LupusRex)this.original).m_20088_().m_135370_(LupusRex.COMMAND) != -2 && (Integer)((LupusRex)this.original).m_20088_().m_135370_(LupusRex.COMMAND) != 4 && (Integer)((LupusRex)this.original).m_20088_().m_135370_(LupusRex.COMMAND) != 0) {
                if ((Integer)((LupusRex)this.original).m_20088_().m_135370_(LupusRex.COMMAND) == -4) {
                    ((LupusRex)this.original).m_20088_().m_135381_(LupusRex.COMMAND, (Object)0);
                }
                this.playModTimer = 0;
                lupusRex.playingMode = false;
                lupusRex.m_20088_().m_135381_(LupusRex.RUNNING_AROUND_TARGET, (Object)false);
                if (!this.isLogicalClient()) {
                    lupusRex.m_5496_(SoundEvents.f_12623_, 1.0f, lupusRex.m_6162_() ? 1.4f : 0.8f);
                    this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_SHAKE, 0.1f);
                }
            } else if ((Integer)((LupusRex)this.original).m_20088_().m_135370_(LupusRex.COMMAND) == 0) {
                ((LupusRex)this.original).m_20088_().m_135381_(LupusRex.COMMAND, (Object)-2);
            }
            if (!((LupusRex)this.original).m_20160_()) {
                lupusRex.m_21563_().m_148051_((Entity)this.tempParent);
            } else if (((Boolean)lupusRex.m_20088_().m_135370_(LupusRex.RUNNING_AROUND_TARGET)).booleanValue() && this.learningCooldown >= (int)(lupusRex.m_21172_(Attributes.f_22279_) * 160.0)) {
                this.learningCooldown = 0;
            }
            if (!this.isLogicalClient()) {
                if (!this.tempParent.m_6047_() && this.tempParent.m_20184_().f_82480_ > 0.1 && ((LupusRex)this.original).m_20096_() && this.learningCooldown == 0) {
                    if ((float)new Random().nextInt(0, 100) < 20.0f || lupusRex.learnJump) {
                        ((LupusRex)this.original).m_20088_().m_135381_(LupusRex.COMMAND, (Object)-2);
                        lupusRex.learnJump = true;
                        lupusRex.m_20334_(Math.max(Math.min(this.tempParent.m_20184_().f_82479_ * 3.0, (double)0.3f), (double)-0.3f), lupusRex.m_21172_(Attributes.f_22288_) * 0.75, Math.max(Math.min(this.tempParent.m_20184_().f_82481_ * 3.0, (double)0.3f), (double)-0.3f));
                        lupusRex.m_21563_().m_148051_((Entity)this.tempParent);
                        this.rotateTo((Entity)this.tempParent, 360.0f, true);
                        if (!this.isLogicalClient()) {
                            this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_JUMP, 0.0f);
                        }
                        ((ServerLevel)lupusRex.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, lupusRex.m_20208_(1.0), lupusRex.m_20187_() + 0.5, lupusRex.m_20262_(1.0), 20, (double)lupusRex.m_20205_(), (double)lupusRex.m_20206_(), (double)lupusRex.m_20205_(), 0.0);
                        this.learningCooldown = 20;
                    } else {
                        lupusRex.m_20088_().m_135381_(LupusRex.COMMAND, (Object)4);
                        lupusRex.m_20088_().m_135381_(LupusRex.SIT_LOCATION, (Object)new Vector3f());
                        lupusRex.m_21573_().m_26573_();
                        ((ServerLevel)lupusRex.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, lupusRex.m_20208_(1.0), lupusRex.m_20187_() + 0.5, lupusRex.m_20262_(1.0), 20, (double)lupusRex.m_20205_(), (double)lupusRex.m_20206_(), (double)lupusRex.m_20205_(), 0.0);
                        this.learningCooldown = 60;
                    }
                }
                if (!((Boolean)lupusRex.m_20088_().m_135370_(LupusRex.RUNNING_AROUND_TARGET)).booleanValue()) {
                    if (Math.abs(this.tempParent.f_20885_ + 180.0f) % 360.0f != Math.abs(this.playerPrevYRot + 180.0f) % 360.0f) {
                        if (Math.abs(this.tempParent.f_20885_ + 180.0f) % 360.0f - Math.abs(this.playerPrevYRot + 180.0f) % 360.0f < 180.0f && Math.abs(this.tempParent.f_20885_ + 180.0f) % 360.0f - Math.abs(this.playerPrevYRot + 180.0f) % 360.0f > -180.0f) {
                            this.playerYRotStage += Math.abs(this.tempParent.f_20885_ + 180.0f) % 360.0f - Math.abs(this.playerPrevYRot + 180.0f) % 360.0f;
                        }
                    } else {
                        this.playerYRotStage = 0.0f;
                    }
                }
                if (Math.abs(this.playerYRotStage) >= 340.0f && !((Boolean)lupusRex.m_20088_().m_135370_(LupusRex.RUNNING_AROUND_TARGET)).booleanValue()) {
                    this.playerYRotStage = 0.0f;
                    if (this.learningCooldown == 0) {
                        if ((float)new Random().nextInt(0, 100) < 20.0f || lupusRex.learnRunAround) {
                            ((LupusRex)this.original).m_20088_().m_135381_(LupusRex.COMMAND, (Object)-2);
                            lupusRex.learnRunAround = true;
                            this.side = Math.abs(this.tempParent.f_20885_ + 180.0f) % 360.0f - Math.abs(this.playerPrevYRot + 180.0f) % 360.0f > 0.0f;
                            lupusRex.m_20088_().m_135381_(LupusRex.RUNNING_AROUND_TARGET, (Object)true);
                            if (!this.isLogicalClient()) {
                                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_RUN, 0.0f);
                            }
                            ((ServerLevel)lupusRex.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, lupusRex.m_20208_(1.0), lupusRex.m_20187_() + 0.5, lupusRex.m_20262_(1.0), 20, (double)lupusRex.m_20205_(), (double)lupusRex.m_20206_(), (double)lupusRex.m_20205_(), 0.0);
                            this.learningCooldown = lupusRex.m_20160_() ? 600 : (int)(lupusRex.m_21172_(Attributes.f_22279_) * 160.0);
                        } else {
                            lupusRex.m_20088_().m_135381_(LupusRex.COMMAND, (Object)4);
                            lupusRex.m_20088_().m_135381_(LupusRex.SIT_LOCATION, (Object)new Vector3f());
                            lupusRex.m_21573_().m_26573_();
                            ((ServerLevel)lupusRex.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, lupusRex.m_20208_(1.0), lupusRex.m_20187_() + 0.5, lupusRex.m_20262_(1.0), 20, (double)lupusRex.m_20205_(), (double)lupusRex.m_20206_(), (double)lupusRex.m_20205_(), 0.0);
                            this.learningCooldown = 60;
                        }
                    }
                }
                if (this.playModTimer % 3 == 0) {
                    this.playerPrevYRot = this.tempParent.f_20885_;
                }
                if (((Boolean)lupusRex.m_20088_().m_135370_(LupusRex.RUNNING_AROUND_TARGET)).booleanValue() && !((LupusRex)this.original).m_20160_()) {
                    Player targetEntity = this.tempParent;
                    if (this.learningCooldown > 0 && !this.getEntityState().inaction() && targetEntity != null) {
                        double distanceToTarget = lupusRex.m_20275_(targetEntity.m_20185_(), targetEntity.m_20186_(), targetEntity.m_20189_());
                        float angle = (float)(lupusRex.m_21051_(Attributes.f_22279_).m_22135_() * (double)15.1f);
                        if (lupusRex.m_20184_().m_165924_() < 0.1) {
                            this.side = !this.side;
                        }
                        lupusRex.m_21573_().m_26573_();
                        if (Math.sqrt(distanceToTarget) < 5.0) {
                            angle = -10.0f;
                        } else if (Math.sqrt(distanceToTarget) > 6.0) {
                            angle = 10.0f;
                        }
                        this.rotateTo((Entity)targetEntity, 360.0f, false);
                        if (!this.side) {
                            this.rotateTo(this.getYRot() - 90.0f + angle, 360.0f, false);
                        } else {
                            this.rotateTo(this.getYRot() + 90.0f - angle, 360.0f, false);
                        }
                        lupusRex.m_21563_().m_148051_((Entity)targetEntity);
                        Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(0.0f, lupusRex.m_6080_()));
                        Vec3 jumpDir = OpenMatrix4f.transform((OpenMatrix4f)OpenMatrix4f.createRotatorDeg((float)0.0f, (Vec3f)Vec3f.Y_AXIS), (Vec3)forwardHorizontal.m_82490_(lupusRex.m_21172_(Attributes.f_22279_) * 2.0));
                        lupusRex.m_20334_(jumpDir.f_82479_, lupusRex.m_20184_().f_82480_, jumpDir.f_82481_);
                    } else {
                        lupusRex.m_20088_().m_135381_(LupusRex.RUNNING_AROUND_TARGET, (Object)false);
                    }
                }
                PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)this.tempParent, PlayerPatch.class);
                if ((playerPatch.getServerAnimator().animationPlayer.getAnimation().get() instanceof DodgeAnimation || playerPatch.getServerAnimator().animationPlayer.getAnimation().get() instanceof CancelableDodgeAnimation) && this.learningCooldown == 0) {
                    if ((float)new Random().nextInt(0, 100) < 20.0f || lupusRex.learnDodge) {
                        ((LupusRex)this.original).m_20088_().m_135381_(LupusRex.COMMAND, (Object)-2);
                        lupusRex.learnDodge = true;
                        this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_DODGE, 0.0f);
                        this.rotateTo((Entity)this.tempParent, 360.0f, true);
                        ((ServerLevel)lupusRex.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, lupusRex.m_20208_(1.0), lupusRex.m_20187_() + 0.5, lupusRex.m_20262_(1.0), 20, (double)lupusRex.m_20205_(), (double)lupusRex.m_20206_(), (double)lupusRex.m_20205_(), 0.0);
                        this.learningCooldown = 60;
                    } else {
                        lupusRex.m_20088_().m_135381_(LupusRex.COMMAND, (Object)4);
                        lupusRex.m_20088_().m_135381_(LupusRex.SIT_LOCATION, (Object)new Vector3f());
                        lupusRex.m_21573_().m_26573_();
                        ((ServerLevel)lupusRex.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, lupusRex.m_20208_(1.0), lupusRex.m_20187_() + 0.5, lupusRex.m_20262_(1.0), 20, (double)lupusRex.m_20205_(), (double)lupusRex.m_20206_(), (double)lupusRex.m_20205_(), 0.0);
                        this.learningCooldown = 60;
                    }
                }
            }
        }
        if (this.playModTimer == 0 && (Integer)lupusRex.m_20088_().m_135370_(LupusRex.COMMAND) == -2) {
            lupusRex.playingMode = false;
            if (!this.isLogicalClient()) {
                lupusRex.m_20088_().m_135381_(LupusRex.COMMAND, (Object)0);
                lupusRex.m_20088_().m_135381_(LupusRex.RUNNING_AROUND_TARGET, (Object)false);
                lupusRex.m_5496_(SoundEvents.f_12623_, 1.0f, lupusRex.m_6162_() ? 1.4f : 0.8f);
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_SHAKE, 0.1f);
            }
        }
        if (this.learningCooldown == 0 && lupusRex.learnDodge && lupusRex.learnJump && lupusRex.learnRunAround && !((Boolean)lupusRex.m_20088_().m_135370_(LupusRex.PLAYFUL)).booleanValue()) {
            lupusRex.m_20088_().m_135381_(LupusRex.PLAYFUL, (Object)true);
        }
        if (this.isLogicalClient()) {
            if (((Boolean)lupusRex.m_20088_().m_135370_(LupusRex.RUNNING_AROUND_TARGET)).booleanValue() && !this.getEntityState().inaction() && lupusRex.m_20184_().m_165924_() > 0.1) {
                // empty if block
            }
        } else {
            if ((Integer)((LupusRex)this.original).m_20088_().m_135370_(LupusRex.COMMAND) == -1) {
                ((LupusRex)this.original).m_20088_().m_135381_(LupusRex.COMMAND, (Object)0);
                this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_OATH, 0.0f);
                ((LupusRex)this.original).m_21573_().m_26573_();
                lupusRex.m_20334_(0.0, 0.0, 0.0);
            }
            if (lupusRex.m_5448_() != null && this.getServerAnimator().animationPlayer.getAnimation().equals(AnimsLupus.LUPUS_REX_BOMBE_BITE) && this.getServerAnimator().animationPlayer.getElapsedTime() > 0.6f && this.getServerAnimator().animationPlayer.getElapsedTime() < 1.15f) {
                lupusRex.m_6027_(lupusRex.m_5448_().m_20185_(), lupusRex.m_20186_(), lupusRex.m_5448_().m_20189_());
            }
        }
        if ((Integer)((LupusRex)this.original).m_20088_().m_135370_(LupusRex.COMMAND) == 1 && ((LupusRex)this.original).m_21573_().m_26571_() && !((LupusRex)this.original).isMovementLock() && ((LupusRex)this.original).getOriginalSitPosition() != null && Math.sqrt(((LupusRex)this.original).m_20238_(((LupusRex)this.original).getOriginalSitPosition())) > 3.0) {
            ((LupusRex)this.original).m_21573_().m_26519_(((LupusRex)this.original).getOriginalSitPosition().f_82479_, ((LupusRex)this.original).getOriginalSitPosition().f_82480_, ((LupusRex)this.original).getOriginalSitPosition().f_82481_, (double)0.8f);
        }
        if (lupusRex.learnDodge && lupusRex.learnJump && lupusRex.learnRunAround && !((LupusRex)this.original).m_30614_() && lupusRex.m_217043_().m_188502_() % 5 == 1) {
            ((ServerLevel)lupusRex.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123750_, ((LupusRex)this.original).m_20185_(), ((LupusRex)this.original).m_20186_() + (double)((LupusRex)this.original).m_20192_() + 1.0, ((LupusRex)this.original).m_20189_(), 1, 1.0, 1.0, 1.0, 0.0);
        }
    }

    protected void initAI() {
        super.initAI();
        ((LupusRex)this.original).f_21345_.m_25352_(0, new RunAroundTargetGoal<LupusRexPatch>(this, 40, 100, 100, 200, AnimsLupus.LUPUS_REX_RUN));
        ((LupusRex)this.original).f_21345_.m_25352_(1, (Goal)new DashAttackGoal(this, (PathfinderMob)this.original, 1.4, false, 3.0, false));
        ((LupusRex)this.original).f_21345_.m_25352_(8, (Goal)new WOMRandomLookAroundGoal(this));
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        this.epicFightDamageSource = damageSource;
        if (!target.m_20148_().equals(((LupusRex)this.original).m_21805_())) {
            ((LupusRex)this.original).m_7327_(target);
        }
        this.epicFightDamageSource = null;
        AttackResult attackResult = this.checkLastAttackSuccess(target) ? new AttackResult(this.lastAttackResultType, this.lastDealDamage) : AttackResult.missed((float)0.0f);
        ((LupusRex)this.original).m_6703_(null);
        ((LupusRex)this.original).m_21335_((Entity)((LivingEntity)null));
        ((LupusRex)this.original).m_6925_(null);
        ((LupusRex)this.original).m_7870_(0);
        ((LupusRex)this.original).m_6710_(null);
        return attackResult;
    }

    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        if (damageSource.m_7639_() == null) {
            return super.tryHurt(damageSource, amount);
        }
        if (((LupusRex)this.original).m_5803_()) {
            ((LupusRex)this.original).setSleeping(false);
            this.SleepingCooldown = 1;
        }
        if (((LupusRex)this.original).m_269323_() == damageSource.m_7639_() && ((LupusRex)this.original).m_30614_() && ((LupusRex)this.original).m_5647_() == damageSource.m_7639_().m_5647_()) {
            return AttackResult.missed((float)amount);
        }
        if (((LupusRex)this.original).m_5448_() == null && this.getEntityState().canBasicAttack() && !damageSource.m_276093_(DamageTypes.f_286979_)) {
            ((LupusRex)this.original).m_21573_().m_26573_();
            ((LupusRex)this.original).m_21563_().m_148051_(damageSource.m_7639_());
            this.rotateTo(damageSource.m_7639_(), 360.0f, true);
            this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_DODGE, 0.0f);
            Entity entity = damageSource.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (((LupusRex)this.original).m_269323_() != livingEntity && !((LupusRex)this.original).isOrderedToCome() && this.tempParent != livingEntity) {
                    ((LupusRex)this.original).m_6703_(livingEntity);
                    ((LupusRex)this.original).m_6925_(damageSource.m_7639_().m_20148_());
                    ((LupusRex)this.original).m_6710_(livingEntity);
                    ((LupusRex)this.original).m_7870_(100);
                }
            }
            return AttackResult.missed((float)amount);
        }
        if (!this.isLogicalClient() && ((LupusRex)this.original).m_269323_() != damageSource.m_7639_() && this.getServerAnimator().animationPlayer.getAnimation() == AnimsLupus.LUPUS_REX_DODGE && this.getServerAnimator().animationPlayer.getElapsedTime() > 0.5f && this.getServerAnimator().animationPlayer.getElapsedTime() < 1.5f && !damageSource.m_269533_(EpicFightDamageTypeTags.GUARD_PUNCTURE)) {
            ((LupusRex)this.original).m_5496_((SoundEvent)EpicFightSounds.BLUNT_HIT.get(), 1.5f, 0.5f);
            ((LupusRex)this.original).m_5496_((SoundEvent)EpicFightSounds.CLASH.get(), 0.5f, 0.75f);
            this.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_COUNTERATTACK, 0.0f);
            return AttackResult.blocked((float)amount);
        }
        if (this.currentAnimation().equals(AnimsLupus.LUPUS_REX_COUNTERATTACK) && this.getElapsedTime() < 0.35f) {
            ((LupusRex)this.original).m_5496_((SoundEvent)EpicFightSounds.BLUNT_HIT.get(), 1.5f, 0.5f);
            ((LupusRex)this.original).m_5496_((SoundEvent)EpicFightSounds.CLASH.get(), 0.5f, 0.75f);
            return AttackResult.blocked((float)amount);
        }
        return super.tryHurt(damageSource, amount);
    }

    @Override
    public boolean isTurningLock() {
        return this.getEntityState().turningLocked() || ((LupusRex)this.original).isOrderedToStay() || ((LupusRex)this.original).isOrderedToFollow() || ((LupusRex)this.original).playingMode;
    }

    public void onAttackBlocked(DamageSource damageSource, LivingEntityPatch<?> opponent) {
    }

    @Override
    public AssetAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return null;
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        return (SoundEvent)EpicFightSounds.BLADE_HIT.get();
    }

    public HitParticleType getWeaponHitParticle(InteractionHand hand) {
        return (HitParticleType)EpicFightParticles.HIT_BLADE.get();
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        return (SoundEvent)EpicFightSounds.WHOOSH_BIG.get();
    }

    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float yRot;
        float yRotO;
        float scale = 1.6f;
        if (((LupusRex)this.original).m_6162_()) {
            float age = Math.min((float)(24000 + ((LupusRex)this.original).getSyncAge()) / 24000.0f, 1.0f) * 1.2f;
            if (((LupusRex)this.original).getSyncAge() == 0) {
                age = 0.0f;
            }
            scale = 0.4f + age;
        } else {
            scale = 1.6f;
        }
        Entity entity = ((LupusRex)this.original).m_20202_();
        if (entity instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)entity;
            yRotO = ridingEntity.f_20884_;
            yRot = ridingEntity.f_20883_;
        } else {
            yRotO = this.isLogicalClient() ? ((LupusRex)this.original).f_20884_ : ((LupusRex)this.original).m_146908_();
            yRot = this.isLogicalClient() ? ((LupusRex)this.original).f_20883_ : ((LupusRex)this.original).m_146908_();
        }
        return MathUtils.getModelMatrixIntegral((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)yRotO, (float)yRot, (float)partialTicks, (float)scale, (float)scale, (float)scale);
    }

    public boolean causeFallDamage(float p_149499_, float p_149500_, DamageSource p_149501_) {
        return false;
    }
}

