/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.world.entity.mob;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import reascer.wom.gameasset.animations.entitys.AnimsSaulomonk;
import reascer.wom.particle.ParticlesTools;
import reascer.wom.particle.WOMParticles;
import reascer.wom.world.damagesources.WOMExtraDamageInstance;
import reascer.wom.world.entity.WOMEntities;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.StunType;

public class TargetingHelper
extends FlyingMob
implements OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(TamableAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public TargetingHelper(EntityType<? extends FlyingMob> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
        this.f_19794_ = true;
        this.m_20331_(true);
    }

    public TargetingHelper(ServerLevel level, Vec3 position, LivingEntity owner, LivingEntity target) {
        this((EntityType<? extends FlyingMob>)((EntityType)WOMEntities.TARGETING_HELPER.get()), (Level)level);
        this.m_146884_(position);
        this.m_6710_(target);
        this.setOwnerUUID(owner.m_20148_());
    }

    public boolean m_6469_(DamageSource damagesource, float damage) {
        if (!damagesource.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        return super.m_6469_(damagesource, damage);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_();
    }

    public void m_8024_() {
        if (this.f_19797_ >= 200) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        for (String tag : this.m_19880_()) {
            if (!tag.contains("saulomonk_beam")) continue;
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            if (this.f_19797_ < 7) {
                if (this.f_19797_ % 3 == 0) {
                    ParticlesTools.particle_circle_server((ParticleOptions)ParticleTypes.f_175830_, null, serverLevel, null, 10, 1.2f, 0.01f, 0.5f, new Vec3f(this.m_20182_().m_82520_(0.0, 0.1, 0.0)), null, new Vec2f(0.0f, 90.0f), false, false);
                }
                ParticlesTools.particle_circle_server((ParticleOptions)ParticleTypes.f_175830_, null, serverLevel, null, 10, 2.6f, 0.01f, 0.5f, new Vec3f(this.m_20182_().m_82520_(0.0, 0.1, 0.0)), null, new Vec2f(0.0f, 90.0f), false, false);
            }
            if (this.f_19797_ != 9) continue;
            serverLevel.m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SoundEvents.f_11736_, this.m_5720_(), 4.0f, 2.0f);
            serverLevel.m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, (SoundEvent)EpicFightSounds.LASER_BLAST.get(), this.m_5720_(), 0.5f, 1.2f);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)WOMParticles.BEAM_UP.get()), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            AABB box1 = AABB.m_165882_((Vec3)this.m_20182_(), (double)9.0, (double)9.0, (double)9.0);
            List list1 = this.m_9236_().m_45933_((Entity)this, box1);
            for (Entity entity1 : list1) {
                LivingEntityPatch lvPatch;
                if (!(Mth.m_14116_((float)((float)entity1.m_20275_(this.m_20182_().f_82479_, entity1.m_20182_().f_82480_, this.m_20182_().f_82481_))) < 3.0f) || this.m_21805_() == null || entity1 == null || !entity1.m_6084_()) continue;
                AABB box = AABB.m_165882_((Vec3)this.m_20182_(), (double)500.0, (double)500.0, (double)500.0);
                List list = this.m_9236_().m_45933_((Entity)this, box);
                LivingEntity owner = null;
                for (Entity entity : list) {
                    LivingEntity livingEntity;
                    if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_20148_().equals(this.m_21805_())) continue;
                    owner = livingEntity;
                    break;
                }
                if (owner == null || !owner.m_6084_() || entity1 == owner || (lvPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(owner, LivingEntityPatch.class)) == null || !(entity1 instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity1;
                EpicFightDamageSource damagesource = new EpicFightDamageSource((DamageSource)lvPatch.getDamageSource(AnimsSaulomonk.SAULOMONK_ORBIT_BEAM, InteractionHand.MAIN_HAND));
                damagesource.setBaseImpact(new Random().nextFloat(2.0f, 4.0f));
                damagesource.setStunType(new Random().nextBoolean() ? StunType.LONG : StunType.HOLD);
                damagesource.attachDamageModifier(ValueModifier.multiplier((float)1.8f));
                damagesource.addRuntimeTag(EpicFightDamageTypeTags.WEAPON_INNATE);
                damagesource.addRuntimeTag(EpicFightDamageTypeTags.GUARD_PUNCTURE);
                damagesource.addRuntimeTag(EpicFightDamageTypeTags.BYPASS_DODGE);
                damagesource.addExtraDamage(WOMExtraDamageInstance.WOM_SWEEPING_EDGE_ENCHANTMENT.create(new float[]{0.8f}));
                livingEntity.m_6469_((DamageSource)damagesource, (float)owner.m_21133_(Attributes.f_22281_));
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            break;
        }
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    public void m_7380_(CompoundTag p_21819_) {
        super.m_7380_(p_21819_);
        if (this.m_21805_() != null) {
            p_21819_.m_128362_("Owner", this.m_21805_());
        }
    }

    public void m_7378_(CompoundTag p_21815_) {
        UUID uuid;
        super.m_7378_(p_21815_);
        if (p_21815_.m_128403_("Owner")) {
            uuid = p_21815_.m_128342_("Owner");
        } else {
            String s = p_21815_.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID p_21817_) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(p_21817_));
    }
}

