/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponpassive;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.animation.dodges.CancelableDodgeAnimation;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.gameasset.WOMSounds;
import reascer.wom.gameasset.animations.weapons.AnimsNapoleon;
import reascer.wom.main.WeaponsOfMinecraft;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class NapoleonBusterPassive
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("13118679-312b-4dfa-bdf8-cc58ea9c5b07");

    public NapoleonBusterPassive(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder.setActivateType(Skill.ActivateType.DURATION_INFINITE));
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            ServerPlayerPatch executor = (ServerPlayerPatch)container.getExecutor();
            ServerPlayer player = (ServerPlayer)executor.getOriginal();
            boolean is_cancelable_dodging = executor.getServerAnimator().animationPlayer.getAnimation().get() instanceof CancelableDodgeAnimation;
            int current_basic_attack = (Integer)executor.getSkill((SkillSlot)SkillSlots.BASIC_ATTACK).getDataManager().getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get());
            int bullets = (Integer)executor.getSkill(WOMSkills.NAPOLEON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.BULLET_LOADED.get());
            if (bullets > 0 || ((Boolean)executor.getSkill(WOMSkills.NAPOLEON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue() && current_basic_attack == 4 && !executor.getServerAnimator().animationPlayer.getAnimation().equals(AnimsNapoleon.NAPOLEON_VERDUN)) {
                if (executor.getEntityState().canUseSkill()) {
                    if (!player.m_20096_() && !player.m_20069_() && player.f_19789_ < 0.1f && (player.m_9236_().m_46859_(player.m_20183_().m_7495_()) || player.f_19855_ - (double)player.m_20183_().m_123342_() > 0.2)) {
                        executor.playAnimationSynchronized(AnimsNapoleon.NAPOLEON_WATERLOW_SHOOT, 0.0f);
                    } else if ((((ServerPlayer)executor.getOriginal()).m_20142_() || is_cancelable_dodging) && !executor.getServerAnimator().animationPlayer.getAnimation().equals(AnimsNapoleon.NAPOLEON_AUSTERLITZ_SHOOT)) {
                        SkillDataManager napoleon_passive_SDM = executor.getSkill(WOMSkills.NAPOLEON_PASSIVE).getDataManager();
                        int current_bullets = (Integer)napoleon_passive_SDM.getDataValue((SkillDataKey)WOMSkillDataKeys.BULLET_LOADED.get());
                        int current_overloaded_bullets = (Integer)napoleon_passive_SDM.getDataValue((SkillDataKey)WOMSkillDataKeys.BULLET_OVERLOADED.get());
                        if (current_bullets > 0) {
                            ((ServerPlayer)executor.getOriginal()).m_9236_().m_6269_(null, (Entity)player, (SoundEvent)WOMSounds.NAPOLEON_SHOOT.get(), SoundSource.PLAYERS, current_overloaded_bullets > 0 ? 1.0f : 0.7f, current_overloaded_bullets > 0 ? 1.0f : 1.2f);
                        } else {
                            ((ServerPlayer)executor.getOriginal()).m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_11797_, SoundSource.PLAYERS, 1.5f, 1.0f);
                        }
                        executor.playAnimationSynchronized(AnimsNapoleon.NAPOLEON_AUSTERLITZ_SHOOT, 0.0f);
                    } else if (player.m_20096_()) {
                        if ((current_basic_attack == 1 || executor.getServerAnimator().animationPlayer.getAnimation().equals(AnimsNapoleon.NAPOLEON_AUSTERLITZ) || executor.getServerAnimator().animationPlayer.getAnimation().equals(AnimsNapoleon.NAPOLEON_RELOAD_1)) && !executor.getServerAnimator().animationPlayer.getAnimation().equals(AnimsNapoleon.NAPOLEON_SHOOT_1)) {
                            executor.playAnimationSynchronized(AnimsNapoleon.NAPOLEON_SHOOT_1, 0.0f);
                            executor.getSkill((SkillSlot)SkillSlots.BASIC_ATTACK).getDataManager().setData((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get(), (Object)2);
                        }
                        if (current_basic_attack == 2 && !executor.getServerAnimator().animationPlayer.getAnimation().equals(AnimsNapoleon.NAPOLEON_SHOOT_2)) {
                            executor.playAnimationSynchronized(AnimsNapoleon.NAPOLEON_SHOOT_2, 0.0f);
                            executor.getSkill((SkillSlot)SkillSlots.BASIC_ATTACK).getDataManager().setData((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get(), (Object)3);
                        }
                        if (current_basic_attack == 3 && !executor.getServerAnimator().animationPlayer.getAnimation().equals(AnimsNapoleon.NAPOLEON_SHOOT_3)) {
                            executor.playAnimationSynchronized(AnimsNapoleon.NAPOLEON_SHOOT_3, 0.0f);
                        }
                        if (current_basic_attack == 4 && !executor.getServerAnimator().animationPlayer.getAnimation().equals(AnimsNapoleon.NAPOLEON_VERDUN) && ((Boolean)executor.getSkill(WOMSkills.NAPOLEON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
                            executor.playAnimationSynchronized(AnimsNapoleon.NAPOLEON_VERDUN, 0.1f);
                        }
                    }
                }
                if ((executor.getServerAnimator().animationPlayer.getAnimation().equals(AnimsNapoleon.NAPOLEON_AUTO_3) || executor.getServerAnimator().animationPlayer.getAnimation().equals(AnimsNapoleon.NAPOLEON_SHOOT_2)) && !player.m_20096_() && !player.m_20069_() && player.f_19789_ < 0.1f && (player.m_9236_().m_46859_(player.m_20183_().m_7495_()) || player.f_19855_ - (double)player.m_20183_().m_123342_() > 0.2)) {
                    executor.playAnimationSynchronized(AnimsNapoleon.NAPOLEON_WATERLOW_SHOOT, 0.0f);
                }
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        int i;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        Window sr = Minecraft.m_91087_().m_91268_();
        int width = sr.m_85445_();
        int height = sr.m_85446_();
        int size = 32;
        int shells = 6;
        boolean perfect_reload = (Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.PERFECT_RELOAD.get());
        int bullets = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.BULLET_LOADED.get());
        int bullets_old = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.BULLET_LOADED_OLD.get());
        int overload_bullets = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.BULLET_OVERLOADED.get());
        int shells_added = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHELL_NUMBER.get());
        int shells_anim = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHELL_ANIM.get());
        int shells_delay = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHELL_DELAY.get());
        int[] anim = new int[]{0, 0, 0, 1, 1, 2, 3, 3, 3, 2, 1};
        int[] anim2 = new int[]{0, 1, 1, 2, 3, 4, 5, 5, 5, 4, 2};
        int[] anim3 = new int[]{0, 1, 1, 2, 2, 3, 4, 5, 6, 7, 10};
        int[] anim_for_shell = new int[]{0, 0, 0, 0, 0, 0};
        for (i = 0; i < shells; ++i) {
            if (bullets != bullets_old && bullets > i && i + 1 > bullets_old) {
                anim_for_shell[i] = anim[shells_anim];
            }
            if (overload_bullets <= 0 || bullets_old + shells_added <= 6 || overload_bullets - bullets + i + 1 <= 0 || i + 1 > 6 - overload_bullets + shells_added || shells_anim <= 0) continue;
            anim_for_shell[i] = anim2[shells_anim];
        }
        if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
            float alpha = 1.0f;
            if (bullets == 0) {
                alpha = 1.0f - (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHELL_ANIM.get())).intValue() / 10.0f;
                width += anim3[shells_anim];
            }
            RenderSystem.setShaderColor((float)0.5f, (float)0.2f, (float)0.8f, (float)alpha);
            guiGraphics.m_280411_(WeaponsOfMinecraft.identifier("textures/gui/skills/weapon_innate/bullet_phantom.png"), width - 102 - 14, height - size - 85, 102, 32, 0.0f, 0.0f, 1, 1, 1, 1);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            width = sr.m_85445_();
        }
        for (i = 0; i < shells; ++i) {
            height = sr.m_85446_();
            height -= anim_for_shell[i];
            if (bullets - i > 0) {
                if (overload_bullets - bullets + i + 1 > 0) {
                    RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    guiGraphics.m_280411_(WeaponsOfMinecraft.identifier("textures/gui/skills/weapon_innate/bullet_overloaded_shell.png"), width - size - 5 - 17 * i, height - size - 50, size, size, 0.0f, 0.0f, 1, 1, 1, 1);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    guiGraphics.m_280411_(WeaponsOfMinecraft.identifier("textures/gui/skills/weapon_innate/bullet_empty_shell.png"), width - size - 5 - 17 * i, height - size - 50, size, size, 0.0f, 0.0f, 1, 1, 1, 1);
                    continue;
                }
                guiGraphics.m_280411_(WeaponsOfMinecraft.identifier("textures/gui/skills/weapon_innate/bullet_loaded_shell.png"), width - size - 5 - 17 * i, height - size - 50, size, size, 0.0f, 0.0f, 1, 1, 1, 1);
                continue;
            }
            guiGraphics.m_280411_(WeaponsOfMinecraft.identifier("textures/gui/skills/weapon_innate/bullet_empty_shell.png"), width - size - 5 - 17 * i, height - size - 50, size, size, 0.0f, 0.0f, 1, 1, 1, 1);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (perfect_reload) {
            guiGraphics.drawString(gui.getFont(), "x2", (float)(width - 122 - gui.getFont().m_92895_("x2") / 2), y - 32.0f, 0xFFFFFF, true);
        }
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        if (!container.getExecutor().isLogicalClient()) {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHELL_ANIM.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHELL_ANIM.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHELL_ANIM.get()) - 1));
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHELL_ANIM.get()) == 0) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHELL_NUMBER.get(), (Object)0);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHELL_DELAY.get(), (Object)0);
                }
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHELL_ANIM.get()) < 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHELL_ANIM.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHELL_ANIM.get()) + 1));
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHELL_ANIM.get()) == 0) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHELL_NUMBER.get(), (Object)0);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHELL_DELAY.get(), (Object)0);
                }
            }
        }
    }
}

