/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponinnate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.joml.Math;
import reascer.wom.gameasset.ReuseableEvents;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.gameasset.animations.weapons.AnimsHerrscher;
import reascer.wom.particle.ParticlesTools;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.capabilities.item.GesetzCapability;
import reascer.wom.world.damagesources.WOMExtraDamageInstance;
import reascer.wom.world.item.HerscherItem;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.ConditionalWeaponInnateSkill;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.entity.eventlistener.DetachablePlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.RightClickItemEvent;
import yesman.epicfight.world.entity.eventlistener.SkillCastEvent;

public class RegierungSkill
extends ConditionalWeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("63c38d4f-cc97-4339-bedf-d9bba36ba29f");
    public static final AnimationManager.AnimationAccessor[] Shieldanims = new AnimationManager.AnimationAccessor[]{AnimsHerrscher.GESETZ_SPRENGKOPF, AnimsHerrscher.GESETZ_KRUMMEN, AnimsHerrscher.GESETZ_AUTO_1, AnimsHerrscher.GESETZ_AUTO_2, AnimsHerrscher.GESETZ_AUTO_3, AnimsHerrscher.GESETZ_WIDERSTAND};
    public static final AnimationManager.AnimationAccessor[] Swordanims = new AnimationManager.AnimationAccessor[]{AnimsHerrscher.HERRSCHER_AUTO_1, AnimsHerrscher.HERRSCHER_AUTO_2, AnimsHerrscher.HERRSCHER_AUTO_3, AnimsHerrscher.HERRSCHER_AUSROTTUNG, AnimsHerrscher.HERRSCHER_TRANE, AnimsHerrscher.HERRSCHER_BEFREIUNG, AnimsHerrscher.HERRSCHER_MAHER, AnimsHerrscher.HERRSCHER_VERDAMMNIS};

    public RegierungSkill(ConditionalWeaponInnateSkill.Builder builder) {
        super(builder.setSelector(executer -> {
            int combo = (Integer)executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get());
            return combo;
        }).setAnimations(new AnimationManager.AnimationAccessor[]{AnimsHerrscher.GESETZ_AUTO_1, AnimsHerrscher.GESETZ_AUTO_2, AnimsHerrscher.GESETZ_AUTO_3, AnimsHerrscher.GESETZ_KRUMMEN, AnimsHerrscher.GESETZ_SPRENGKOPF}));
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, event -> {
            if (((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6117_() && container.getRemainDuration() > 20 && !((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HOLDING_STANCE.get())).booleanValue() && (container.getRemainDuration() > 0 || ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7500_())) {
                event.setCanceled(true);
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(AnimsHerrscher.HERRSCHER_MAHER_HOLD_HIT, 0.3f);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HOLDING_STANCE.get(), (Object)true);
                this.setDurationSynchronize(container, container.getRemainDuration() - 20);
                ((ServerPlayerPatch)event.getPlayerPatch()).modifyLivingMotionByCurrentItem();
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            if (container.getExecutor().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()) != null) {
                int stack = (Integer)container.getExecutor().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get());
                for (AnimationManager.AnimationAccessor anims : Swordanims) {
                    if (!event.getDamageSource().getAnimation().equals(anims)) continue;
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGED.get(), (Object)true);
                }
                for (AnimationManager.AnimationAccessor anims : Shieldanims) {
                    if (!event.getDamageSource().getAnimation().equals(anims) || !((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGED.get())).booleanValue()) continue;
                    event.getDamageSource().addExtraDamage(WOMExtraDamageInstance.WOM_FLAT_DAMAGE.create(new float[]{(float)stack / 30.0f}));
                }
                if (event.getDamageSource().getAnimation().equals(AnimsHerrscher.HERRSCHER_MAHER)) {
                    event.getDamageSource().attachDamageModifier(ValueModifier.multiplier((float)((float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get())).intValue() / 50.0f)));
                }
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (event.getMovementInput().f_108568_ || event.getMovementInput().f_108569_ || event.getMovementInput().f_108570_ || event.getMovementInput().f_108571_) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.GUARD_POINT.get(), (Object)false);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (!container.getExecutor().isLogicalClient()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.GESETZ_SPRENGKOPF.get(), (Object)false);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40);
                if (!event.getAnimation().equals(AnimsHerrscher.HERRSCHER_AUTO_2) && !event.getAnimation().equals(AnimsHerrscher.GESETZ_AUTO_1)) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.GUARD_POINT.get(), (Object)false);
                }
                if (event.getAnimation().equals(AnimsHerrscher.HERRSCHER_AUTO_2)) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.GUARD_POINT.get(), (Object)true);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.GUARD_POINT_RESULT.get(), (Object)2);
                }
                if (event.getAnimation().equals(AnimsHerrscher.HERRSCHER_GUARD_HIT)) {
                    this.setDurationSynchronize(container, (int)((float)container.getRemainDuration() + 20.0f * (1.0f + (float)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecutor().getOriginal())) / 3.0f)));
                }
                if (event.getAnimation().equals(AnimsHerrscher.HERRSCHER_MAHER_HOLD_HIT)) {
                    this.setDurationSynchronize(container, (int)((float)container.getRemainDuration() + 20.0f * (1.0f + (float)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecutor().getOriginal())) / 3.0f)));
                }
                if (event.getAnimation().equals(AnimsHerrscher.HERRSCHER_TRANE)) {
                    this.setDurationSynchronize(container, (int)((float)container.getRemainDuration() + 100.0f * (1.0f + (float)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecutor().getOriginal())) / 3.0f)));
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)0);
                }
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            DamageSource damageSource = event.getDamageSource();
            ServerPlayer playerentity = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.GUARD_POINT.get())).booleanValue() && ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability && event.getDamageSource() != null && this.isBlockableSource(event.getDamageSource())) {
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    ItemStack shield = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21206_();
                    shield.m_41622_((int)Math.floor((float)event.getDamage()), (LivingEntity)playerentity, T -> {
                        T.m_21190_(InteractionHand.OFF_HAND);
                        ForgeEventFactory.onPlayerDestroyItem((Player)playerentity, (ItemStack)shield, (InteractionHand)InteractionHand.OFF_HAND);
                        playerentity.m_5810_();
                    });
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.CLASH.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.4f, 1.3f);
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.BLUNT_HIT.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.8f, 0.5f);
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.NEUTRALIZE_BOSSES.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 0.6f, 2.5f);
                    ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)playerentity.m_9236_(), HitParticleType.MIDDLE_OF_ENTITIES, HitParticleType.CENTER_OF_TARGET, (Entity)playerentity, damageSource.m_7640_());
                    Vec2f facing = ReuseableEvents.getYawPitchF(playerentity.m_146892_(), event.getDamageSource().m_7639_().m_146892_());
                    Vec3f offset = new Vec3f(ReuseableEvents.getPointInDirection(facing.y, -facing.x, 1.0).m_82520_(0.0, (double)(playerentity.m_20206_() / 2.0f), 0.0));
                    ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123747_, ((Player)container.getExecutor().getOriginal()).m_20185_() + (double)offset.x, ((Player)container.getExecutor().getOriginal()).m_20186_() + (double)offset.y, ((Player)container.getExecutor().getOriginal()).m_20189_() + (double)offset.z, 1, 0.0, 0.0, 0.0, 0.5);
                    ((Player)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 5, 2, true, false, false));
                    ParticlesTools.particle_circle_server((ParticleOptions)DustParticleOptions.f_123656_, event.getPlayerPatch(), playerentity.m_284548_(), null, 50, 1.2f, 0.01f, 0.5f, offset, null, facing, false, false);
                    ParticlesTools.particle_circle_server((ParticleOptions)DustParticleOptions.f_123656_, event.getPlayerPatch(), playerentity.m_284548_(), null, 30, 0.6f, 0.01f, 0.5f, offset, null, facing, false, false);
                    AnimationManager.AnimationAccessor animation = Animations.BIPED_HIT_SHIELD;
                    float convert = -0.05f;
                    switch ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.GUARD_POINT_RESULT.get())) {
                        case 1: {
                            animation = AnimsHerrscher.GESETZ_AUTO_1;
                            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)1);
                            this.setDurationSynchronize(container, (int)((float)container.getRemainDuration() + 50.0f * (1.0f + (float)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecutor().getOriginal())) / 3.0f)));
                            break;
                        }
                        case 2: {
                            animation = AnimsHerrscher.HERRSCHER_AUTO_2;
                            this.setDurationSynchronize(container, (int)((float)container.getRemainDuration() + 50.0f * (1.0f + (float)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecutor().getOriginal())) / 3.0f)));
                            break;
                        }
                        case 3: {
                            animation = AnimsHerrscher.HERRSCHER_AUTO_3;
                            this.setDurationSynchronize(container, (int)((float)container.getRemainDuration() + 200.0f * (1.0f + (float)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecutor().getOriginal())) / 3.0f)));
                            break;
                        }
                        case 4: {
                            animation = AnimsHerrscher.HERRSCHER_AUTO_3;
                            this.setDurationSynchronize(container, (int)((float)container.getRemainDuration() + 150.0f * (1.0f + (float)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecutor().getOriginal())) / 3.0f)));
                            convert = -0.15f;
                            break;
                        }
                        case 5: {
                            animation = AnimsHerrscher.HERRSCHER_AUTO_2;
                            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)1);
                            this.setDurationSynchronize(container, (int)((float)container.getRemainDuration() + 50.0f * (1.0f + (float)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecutor().getOriginal())) / 3.0f)));
                            break;
                        }
                        case 6: {
                            animation = AnimsHerrscher.HERRSCHER_AUTO_2;
                            this.setDurationSynchronize(container, (int)((float)container.getRemainDuration() + 50.0f * (1.0f + (float)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecutor().getOriginal())) / 3.0f)));
                            break;
                        }
                        default: {
                            animation = Animations.BIPED_HIT_SHIELD;
                        }
                    }
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.GUARD_POINT_RESULT.get()) != 3) {
                        ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized((AssetAccessor)animation, convert);
                    }
                    event.setCanceled(true);
                    event.setResult(AttackResult.ResultType.BLOCKED);
                    Entity directEntity = event.getDamageSource().m_7640_();
                    LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)directEntity, LivingEntityPatch.class);
                    if (entitypatch != null) {
                        entitypatch.onAttackBlocked(event.getDamageSource(), entitypatch);
                    }
                }
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        if (container.getExecutor().getSkill(WOMSkills.COUNTER_ATTACK) != null && !container.getExecutor().isLogicalClient()) {
            container.getExecutor().getSkill(WOMSkills.COUNTER_ATTACK).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get(), (Object)Float.valueOf(1.0f));
        }
    }

    private boolean isBlockableSource(DamageSource damageSource) {
        return !damageSource.m_269533_(DamageTypeTags.f_268738_) && !damageSource.m_269533_(EpicFightDamageTypeTags.UNBLOCKALBE) && !damageSource.m_269533_(DamageTypeTags.f_268490_) && !damageSource.m_276093_(DamageTypes.f_268515_) && !damageSource.m_269533_(DamageTypeTags.f_268745_) && !damageSource.m_269533_(EpicFightDamageTypeTags.GUARD_PUNCTURE);
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        ServerPlayer player = (ServerPlayer)container.getServerExecutor().getOriginal();
        if (player.m_6117_() && container.getRemainDuration() > 30 && container.getExecutor().getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability) {
            container.getExecutor().playAnimationSynchronized(AnimsHerrscher.GESETZ_WIDERSTAND, 0.0f);
        } else if (!player.m_20096_() && !player.m_20069_() && (player.m_9236_().m_46859_(player.m_20183_().m_7495_()) || player.f_19855_ - (double)player.m_20183_().m_123342_() > 0.2) && container.getServerExecutor().hasStamina(4.0f)) {
            container.getExecutor().playAnimationSynchronized((AssetAccessor)this.attackAnimations[this.attackAnimations.length - 1], 0.0f);
            container.getServerExecutor().consumeForSkill((Skill)this, Skill.Resource.STAMINA, 4.0f);
        } else if (((Player)container.getExecutor().getOriginal()).m_20142_()) {
            container.getExecutor().playAnimationSynchronized((AssetAccessor)this.attackAnimations[this.attackAnimations.length - 2], 0.0f);
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)0);
        } else {
            int animation = this.getAnimationInCondition(container.getServerExecutor());
            container.getExecutor().playAnimationSynchronized((AssetAccessor)this.attackAnimations[animation], 0.0f);
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get()) < 2) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get()) + 1));
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)0);
            }
        }
        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40);
    }

    public boolean canExecute(SkillContainer container) {
        return container.getExecutor().getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability && container.getExecutor().getValidItemInHand(InteractionHand.MAIN_HAND).m_41720_() instanceof HerscherItem;
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        EntityState playerState = executer.getEntityState();
        return !((Player)executer.getOriginal()).m_21255_() && executer.currentLivingMotion != LivingMotions.FALL && playerState.canUseSkill() && executer.getEntityState().canBasicAttack();
    }

    public boolean resourcePredicate(PlayerPatch<?> playerpatch, SkillCastEvent SCevent) {
        Player player = (Player)playerpatch.getOriginal();
        if (!player.m_20096_() && !player.m_20069_() && (player.m_9236_().m_46859_(player.m_20183_().m_7495_()) || player.f_19855_ - (double)player.m_20183_().m_123342_() > 0.2)) {
            return playerpatch.consumeForSkill((Skill)this, Skill.Resource.STAMINA, 3.0f);
        }
        if (((Player)playerpatch.getOriginal()).m_20142_()) {
            return playerpatch.consumeForSkill((Skill)this, Skill.Resource.STAMINA, 2.0f);
        }
        return true;
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        ArrayList list = Lists.newArrayList();
        String traslatableText = this.getTranslationKey();
        list.add(Component.m_237115_((String)traslatableText).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)String.format("[%.0f]", Float.valueOf(this.consumption))).m_130940_(ChatFormatting.AQUA)));
        list.add(Component.m_237115_((String)(traslatableText + ".tooltip")).m_130940_(ChatFormatting.DARK_GRAY));
        return list;
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            if (!container.getExecutor().isLogicalClient()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) - 1));
            }
        } else if (!container.getExecutor().isLogicalClient()) {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)0);
        }
        if (container.getExecutor().getSkill(WOMSkills.COUNTER_ATTACK) != null && ((Float)container.getExecutor().getSkill(WOMSkills.COUNTER_ATTACK).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get())).floatValue() != 0.2f && !container.getExecutor().isLogicalClient()) {
            container.getExecutor().getSkill(WOMSkills.COUNTER_ATTACK).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get(), (Object)Float.valueOf(0.2f));
        }
        if (!container.getExecutor().isLogicalClient()) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)container.getExecutor();
            if (((Player)container.getExecutor().getOriginal()).m_6117_()) {
                if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.PARRYING.get())).booleanValue()) {
                    container.getExecutor().getEventListener().triggerEvents(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, (DetachablePlayerEvent)new RightClickItemEvent((PlayerPatch)((ServerPlayerPatch)container.getExecutor())));
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARRYING.get(), (Object)true);
                }
                if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HOLDING_STANCE.get())).booleanValue()) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) + 5));
                    this.setDurationSynchronize(container, container.getRemainDuration() - 10);
                    if (container.getRemainDuration() == 0 && !((ServerPlayer)serverPlayerPatch.getOriginal()).m_7500_()) {
                        ((Player)container.getExecutor().getOriginal()).m_5810_();
                    }
                }
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARRYING.get(), (Object)false);
                if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HOLDING_STANCE.get())).booleanValue() && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) >= 10) {
                    serverPlayerPatch.playAnimationSynchronized(AnimsHerrscher.HERRSCHER_MAHER, 0.0f);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HOLDING_STANCE.get(), (Object)false);
                    serverPlayerPatch.modifyLivingMotionByCurrentItem();
                }
            }
            if ((serverPlayerPatch.getServerAnimator().animationPlayer.getAnimation().equals(AnimsHerrscher.HERRSCHER_MAHER) && serverPlayerPatch.getServerAnimator().animationPlayer.getElapsedTime() > 0.6f || !serverPlayerPatch.getServerAnimator().animationPlayer.getAnimation().equals(AnimsHerrscher.HERRSCHER_MAHER)) && !((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HOLDING_STANCE.get())).booleanValue()) {
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) > 0) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) - 1));
                } else {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get(), (Object)0);
                }
            }
            for (AnimationManager.AnimationAccessor anim : Shieldanims) {
                Object object;
                if (!serverPlayerPatch.getServerAnimator().animationPlayer.getAnimation().equals(anim) || !((object = serverPlayerPatch.getServerAnimator().animationPlayer.getAnimation().get()) instanceof AttackAnimation)) continue;
                AttackAnimation attackAnim = (AttackAnimation)object;
                if (!(serverPlayerPatch.getServerAnimator().animationPlayer.getElapsedTime() > attackAnim.phases[attackAnim.phases.length - 1].contact)) continue;
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGED.get(), (Object)false);
            }
        } else if (((Player)container.getExecutor().getOriginal()).m_6117_() && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HOLDING_STANCE.get())).booleanValue()) {
            int i = 0;
            while ((float)i < (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get())).intValue() / 100.0f) {
                OpenMatrix4f weaponMatrix = ParticlesTools.getJointPos(((HumanoidArmature)Armatures.BIPED.get()).toolR, container.getExecutor(), 0.0f);
                weaponMatrix.translate(new Random().nextFloat(-0.2f, 0.2f), new Random().nextFloat(0.0f, 0.4f), -new Random().nextFloat(0.3f, 2.5f));
                ((Player)container.getExecutor().getOriginal()).m_9236_().m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)weaponMatrix.toTranslationVector().x, (double)weaponMatrix.toTranslationVector().y, (double)weaponMatrix.toTranslationVector().z, 0.0, 0.0, 0.0);
                ++i;
            }
        }
        container.setResource(10.0f);
    }
}

