/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponinnate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.gameasset.WOMSounds;
import reascer.wom.gameasset.animations.weapons.AnimsEnderblaster;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import reascer.wom.world.item.WOMItems;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.camera.EpicFightCameraAPI;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPSkillRequest;
import yesman.epicfight.network.server.SPSkillExecutionFeedback;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.ConditionalWeaponInnateSkill;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.DetachablePlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillCastEvent;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;

public class EnderBlastSkill
extends ConditionalWeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("b9023f5e-ee42-11ec-8ea0-0242ac120002");

    public EnderBlastSkill(ConditionalWeaponInnateSkill.Builder builder) {
        super(builder.setSelector(executer -> {
            int combo = (Integer)executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get());
            return combo;
        }).setAnimations(new AnimationManager.AnimationAccessor[]{AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_1, AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_2, AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_3, AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_2_FORWARD, AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_2_LEFT, AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_2_RIGHT, AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_DASH, AnimsEnderblaster.ENDERBLASTER_ONEHAND_AIRSHOOT}));
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.ENDERBLASTER) {
                ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.ENDERBLASTER) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHOOT.get(), (Object)true);
            }
            if (!container.getExecutor().isLogicalClient() && ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.ENDERBLASTER) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ZOOM.get(), (Object)true);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.RELOAD_COOLDOWN.get(), (Object)80);
            if (!event.getAnimation().equals(AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT) && !event.getAnimation().equals(AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_LAYED)) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHOOT.get(), (Object)false);
            }
            if (!(event.getAnimation().equals(AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_1) || event.getAnimation().equals(AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_2) || event.getAnimation().equals(AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_3) || event.getAnimation().equals(AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_2_FORWARD) || event.getAnimation().equals(AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_2_LEFT) || event.getAnimation().equals(AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_2_RIGHT) || event.getAnimation().equals(AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_DASH) || event.getAnimation().equals(AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT) || event.getAnimation().equals(AnimsEnderblaster.ENDERBLASTER_ONEHAND_AIRSHOOT) || container.getExecutor().isLogicalClient())) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ZOOM.get(), (Object)false);
            }
            if (event.getAnimation().equals(AnimsEnderblaster.ENDERBLASTER_ONEHAND_AIRSHOOT)) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.NOFALLDAMAGE.get(), (Object)true);
            }
            if (event.getAnimation().equals(AnimsEnderblaster.ENDERBLASTER_ONEHAND_JUMPKICK)) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.NOFALLDAMAGE.get(), (Object)true);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ZOOM.get(), (Object)true);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onInitiateClient(SkillContainer container) {
        super.onInitiateClient(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.UPDATE_COMPOSITE_LIVING_MOTION_EVENT, EVENT_UUID, event -> {
            if (container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHOOT.get()) != null && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHOOT.get())).booleanValue()) {
                event.setMotion((LivingMotion)LivingMotions.BLOCK);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRemoveClient(SkillContainer container) {
        super.onRemoveClient(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.UPDATE_COMPOSITE_LIVING_MOTION_EVENT, EVENT_UUID);
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
    }

    public boolean resourcePredicate(PlayerPatch<?> playerpatch, SkillCastEvent SCevent) {
        Optional containerOpt = playerpatch.getSkillContainerFor((Skill)this);
        if (containerOpt.isEmpty()) {
            return false;
        }
        SkillContainer container = (SkillContainer)containerOpt.get();
        float consumption = this.getDefaultConsumptionAmount(playerpatch);
        SkillConsumeEvent event = new SkillConsumeEvent(playerpatch, (Skill)this, this.resource, consumption, null);
        playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, (DetachablePlayerEvent)event);
        if (event.isCanceled()) {
            return false;
        }
        if (event.getResourceType().predicate.canExecute(container, playerpatch, event.getAmount())) {
            int stack = container.getStack();
            if (playerpatch.getSkillContainerFor(EpicFightSkills.HYPERVITALITY).isPresent() && stack <= 0) {
                if (playerpatch.getSkill(EpicFightSkills.HYPERVITALITY).getStack() > 0) {
                    playerpatch.getSkill(EpicFightSkills.HYPERVITALITY).activate();
                    playerpatch.getSkill(EpicFightSkills.HYPERVITALITY).setMaxResource(6.0f);
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(SkillContainer container, FriendlyByteBuf args) {
        Input input = ((LocalPlayer)container.getExecutor().getOriginal()).f_108618_;
        int forward = input.f_108568_ ? 1 : 0;
        int backward = input.f_108569_ ? -1 : 0;
        int left = input.f_108570_ ? 1 : 0;
        int right = input.f_108571_ ? -1 : 0;
        int vertic = forward + backward;
        int horizon = left + right;
        int animation = vertic == 0 ? (horizon == 0 ? -3 : (horizon >= 0 ? 1 : 2)) : (vertic <= 0 ? -2 : 0);
        CPSkillRequest packet = new CPSkillRequest(container.getSlot());
        packet.getBuffer().writeInt(animation);
        return packet;
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        int i = args.readInt();
        boolean double_cost = false;
        ServerPlayer player = (ServerPlayer)container.getServerExecutor().getOriginal();
        if (!player.m_20096_() && !player.m_20069_() && (player.m_9236_().m_46859_(player.m_20183_().m_7495_()) || player.f_19855_ - (double)player.m_20183_().m_123342_() > 0.2)) {
            container.getExecutor().playAnimationSynchronized((AssetAccessor)this.attackAnimations[this.attackAnimations.length - 1], 0.0f);
        } else if (((Player)container.getExecutor().getOriginal()).m_20142_()) {
            container.getExecutor().playAnimationSynchronized((AssetAccessor)this.attackAnimations[this.attackAnimations.length - 2], 0.0f);
        } else {
            if (i != -3 && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get()) >= 1) {
                container.getExecutor().playAnimationSynchronized((AssetAccessor)this.attackAnimations[i + 3], 0.0f);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)1);
            } else {
                int animation = this.getAnimationInCondition(container.getServerExecutor());
                container.getExecutor().playAnimationSynchronized((AssetAccessor)this.attackAnimations[animation], 0.0f);
                if (animation == 2) {
                    double_cost = true;
                }
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get()) < 2) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get()) + 1));
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)0);
            }
        }
        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40);
        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ZOOM.get(), (Object)true);
        container.activate();
        if (!((Player)container.getExecutor().getOriginal()).m_7500_()) {
            int stack = container.getStack();
            SkillConsumeEvent event = new SkillConsumeEvent(container.getExecutor(), (Skill)this, this.resource, null);
            container.getExecutor().getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, (DetachablePlayerEvent)event);
            if (!event.isCanceled()) {
                event.getResourceType().consumer.consume(container, container.getServerExecutor(), event.getAmount());
                if (double_cost) {
                    event.getResourceType().consumer.consume(container, container.getServerExecutor(), event.getAmount());
                }
            }
            int sweeping_edge = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecutor().getOriginal()));
            Random random = new Random();
            if ((double)(Math.abs(random.nextInt()) % 100) < 100.0 * (-(1.0 / Math.sqrt(sweeping_edge + 1)) + 1.0)) {
                if (!double_cost || stack != 1) {
                    this.setStackSynchronize(container, container.getStack() + 1);
                }
                ((Player)container.getExecutor().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)WOMSounds.ENDERBLASTER_RELOAD.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.0f, 2.0f);
            }
        }
        container.activate();
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        EntityState playerState = executer.getEntityState();
        return !((Player)executer.getOriginal()).m_21255_() && executer.currentLivingMotion != LivingMotions.FALL && playerState.canUseSkill() && executer.getEntityState().canBasicAttack();
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        ArrayList list = Lists.newArrayList();
        String traslatableText = this.getTranslationKey();
        list.add(Component.m_237115_((String)traslatableText).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)String.format("[%.0f]", Float.valueOf(this.consumption))).m_130940_(ChatFormatting.AQUA)));
        list.add(Component.m_237115_((String)(traslatableText + ".tooltip")).m_130940_(ChatFormatting.DARK_GRAY));
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Close range shot:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Bullet shot:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(2), "Laser beam:");
        return list;
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient()) {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.RELOAD_COOLDOWN.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.RELOAD_COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.RELOAD_COOLDOWN.get()) - 1));
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.RELOAD_COOLDOWN.get(), (Object)80);
                if (container.getStack() < this.getMaxStack() && ((Player)container.getExecutor().getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.ENDER_BLASTER.get()) {
                    if (container.getExecutor().getSkill(WOMSkills.MEDITATION) == null) {
                        container.getExecutor().playAnimationSynchronized(AnimsEnderblaster.ENDERBLASTER_ONEHAND_RELOAD, 0.0f);
                    } else if ((Integer)container.getExecutor().getSkill(WOMSkills.MEDITATION).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0 || container.getExecutor().getSkill(WOMSkills.MEDITATION).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == null) {
                        container.getExecutor().playAnimationSynchronized(AnimsEnderblaster.ENDERBLASTER_ONEHAND_RELOAD, 0.0f);
                    }
                }
            }
        }
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            if (container.getExecutor().isLogicalClient()) {
                if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ZOOM.get())).booleanValue()) {
                    EpicFightCameraAPI.getInstance().zoomIn();
                } else {
                    EpicFightCameraAPI.getInstance().zoomOut(0);
                }
            }
            if (!container.getExecutor().isLogicalClient()) {
                ServerPlayerPatch executer = (ServerPlayerPatch)container.getExecutor();
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) - 1));
                if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.NOFALLDAMAGE.get())).booleanValue()) {
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 10) {
                        ((Player)container.getExecutor().getOriginal()).m_183634_();
                    } else {
                        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.NOFALLDAMAGE.get(), (Object)false);
                    }
                }
                int sweeping_edge = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)executer.getOriginal()));
                if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHOOT.get())).booleanValue() && !((Player)container.getExecutor().getOriginal()).m_6117_() && container.getExecutor().getEntityState().canBasicAttack()) {
                    ((Player)container.getExecutor().getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHOOT.get(), (Object)false);
                    if (executer.getSkill(EpicFightSkills.HYPERVITALITY) != null || container.getStack() > 0 || ((Player)container.getExecutor().getOriginal()).m_7500_()) {
                        boolean flag = true;
                        if (!((Player)container.getExecutor().getOriginal()).m_7500_()) {
                            int stack = container.getStack();
                            if (executer.getSkillContainerFor(EpicFightSkills.HYPERVITALITY).isPresent() && stack <= 0) {
                                SkillContainer hyperVitalityContainer = (SkillContainer)executer.getSkillContainerFor(EpicFightSkills.HYPERVITALITY).get();
                                if (hyperVitalityContainer.getStack() > 0) {
                                    hyperVitalityContainer.activate();
                                    hyperVitalityContainer.setMaxResource(6.0f);
                                    hyperVitalityContainer.getSkill().setStackSynchronize(hyperVitalityContainer, -1);
                                    EpicFightNetworkManager.sendToPlayer((Object)SPSkillExecutionFeedback.executed((int)hyperVitalityContainer.getSlotId()), (ServerPlayer)((ServerPlayer)executer.getOriginal()), (Object[])new Object[0]);
                                } else {
                                    flag = false;
                                }
                            }
                            if (flag) {
                                this.setStackSynchronize(container, container.getStack() - 1);
                                Random random = new Random();
                                if ((double)(Math.abs(random.nextInt()) % 100) < 100.0 * (-(1.0 / Math.sqrt(sweeping_edge + 1)) + 1.0)) {
                                    this.setStackSynchronize(container, container.getStack() + 1);
                                    ((Player)container.getExecutor().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)WOMSounds.ENDERBLASTER_RELOAD.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.0f, 2.0f);
                                }
                            }
                        }
                        if (flag) {
                            if (((ServerPlayer)executer.getOriginal()).m_6067_() || ((ServerPlayer)executer.getOriginal()).m_21255_() || executer.getCurrentLivingMotion() == LivingMotions.CREATIVE_FLY || executer.getCurrentLivingMotion() == LivingMotions.SWIM) {
                                container.getExecutor().playAnimationSynchronized(AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_LAYED, 0.0f);
                            } else {
                                container.getExecutor().playAnimationSynchronized(AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT, 0.0f);
                            }
                        }
                    }
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ZOOM.get(), (Object)true);
                } else if (((Player)container.getExecutor().getOriginal()).m_6117_()) {
                    ((Player)container.getExecutor().getOriginal()).m_6858_(false);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40);
                }
            }
        } else {
            if (!container.getExecutor().isLogicalClient()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)0);
            }
            if (container.getExecutor().isLogicalClient()) {
                EpicFightCameraAPI.getInstance().zoomOut(0);
            }
        }
    }
}

