/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.passive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class CriticalKnowledgeSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("1d807798-1a3f-11ed-861d-0242ac120002");
    private float critDamage = 60.0f;
    private float critRate = 20.0f;

    public CriticalKnowledgeSkill(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            int fire = 0;
            int blast = 0;
            for (ItemStack ArmorPiece : ((Player)container.getExecutor().getOriginal()).m_6168_()) {
                fire += ArmorPiece.getEnchantmentLevel(Enchantments.f_44966_);
                blast += ArmorPiece.getEnchantmentLevel(Enchantments.f_44968_);
            }
            this.critRate = (float)fire / 16.0f * 80.0f + 20.0f;
            this.critDamage = (1.0f + 0.15f * (float)blast) * 100.0f;
            int chance = Math.abs(new Random().nextInt()) % 100;
            if ((float)chance < this.critRate) {
                event.getDamageSource().attachDamageModifier(ValueModifier.multiplier((float)(2.0f + 0.15f * (float)blast)));
                if (!((ServerPlayerPatch)event.getPlayerPatch()).isLogicalClient()) {
                    ServerPlayerPatch executer = (ServerPlayerPatch)event.getPlayerPatch();
                    event.getTarget().m_5496_(SoundEvents.f_11928_, 1.5f, 0.5f);
                    event.getTarget().m_5496_(SoundEvents.f_11934_, 1.5f, 2.0f);
                    ((ServerLevel)((ServerPlayer)executer.getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 1.2, event.getTarget().m_20189_(), 30, 0.1, 0.1, 0.1, 1.0);
                }
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.0f", Float.valueOf(this.critRate)));
        list.add(String.format("%.0f", Float.valueOf(this.critDamage)));
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        String string = String.format("%.0f", Float.valueOf(this.critRate)) + "%";
        String string2 = String.format("%.1f", Float.valueOf(1.0f + this.critDamage / 100.0f));
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)1.0f, (float)1.0f);
        guiGraphics.drawString(gui.getFont(), string, x + 13.0f - (float)(gui.getFont().m_92895_(string) / 2), y + 3.0f, 0xFFFFFF, true);
        RenderSystem.setShaderColor((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
        guiGraphics.drawString(gui.getFont(), string2, x + 13.0f - (float)(gui.getFont().m_92895_(string2) / 2), y + 13.0f, 0xFFFFFF, true);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (container.getExecutor().isLogicalClient()) {
            int fire = 0;
            int blast = 0;
            for (ItemStack ArmorPiece : ((Player)container.getExecutor().getOriginal()).m_6168_()) {
                fire += ArmorPiece.getEnchantmentLevel(Enchantments.f_44966_);
                blast += ArmorPiece.getEnchantmentLevel(Enchantments.f_44968_);
            }
            this.critRate = (float)fire / 16.0f * 80.0f + 20.0f;
            this.critDamage = (1.0f + 0.15f * (float)blast) * 100.0f;
        }
    }
}

